/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.oidc.usecase;

import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import com.nimbusds.openid.connect.sdk.token.OIDCTokens;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import systems.dmx.accesscontrol.event.PostLoginUser;
import systems.dmx.accountmanagement.AccountManagementService;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.oidc.repository.StateRepository;

@Singleton
public class HandleOAuthCallbackUseCase {
    private static final Logger logger = Logger.getLogger(HandleOAuthCallbackUseCase.class.getName());
    private final StateRepository repository;
    private final CoreService dmx;
    private AccountManagementService accountManagementService;
    private static final DMXEvent POST_LOGIN_USER = new DMXEvent(PostLoginUser.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((PostLoginUser)listener).postLoginUser((String)params[0]);
        }
    };

    @Inject
    HandleOAuthCallbackUseCase(StateRepository repository, CoreService dmx) {
        this.repository = repository;
        this.dmx = dmx;
    }

    public URI invoke(HttpServletRequest servletRequest, String authorizationCode, String stateStr) {
        if (authorizationCode == null || StringUtils.isBlank((CharSequence)authorizationCode)) {
            throw new IllegalArgumentException("Authorization code not provided");
        }
        logger.info("Callback with state: " + stateStr);
        StateRepository.Authorization authorization = this.repository.removeAuthorization(new State(stateStr));
        if (authorization == null) {
            throw new IllegalArgumentException("State not known or already used");
        }
        try {
            Tokens tokens = authorization.callback(authorizationCode);
            if (tokens instanceof OIDCTokens) {
                String username = tokens.toOIDCTokens().getIDToken().getJWTClaimsSet().getStringClaim("preferred_username");
                logger.info(String.format("received OpenID Connect tokens. Username: %s", username));
                this.login(username, servletRequest);
            } else {
                SignedJWT jwt = SignedJWT.parse((String)tokens.getAccessToken().getValue());
                String username = jwt.getJWTClaimsSet().getStringClaim("preferred_username");
                logger.info(String.format("received OAuth tokens. Username: %s", username));
                this.login(username, servletRequest);
            }
            return authorization.getAppHomeUri();
        }
        catch (ParseException | IOException | java.text.ParseException e) {
            throw new IllegalStateException("Failed to handle callback", e);
        }
    }

    private void login(String username, HttpServletRequest request) {
        request.getSession(false).setAttribute("username", (Object)username);
        this.dmx.fireEvent(POST_LOGIN_USER, new Object[]{username});
    }
}

