/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.pdfsearch;

import java.io.File;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.event.PostCreateTopic;
import systems.dmx.files.FilesService;
import systems.dmx.tesseract.TesseractService;

public class PDFSearchPlugin
extends PluginActivator
implements PostCreateTopic {
    @Inject
    private FilesService files;
    @Inject
    private TesseractService tesseract;
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public void postCreateTopic(Topic topic) {
        if (topic.getTypeUri().equals("dmx.files.file")) {
            ChildTopics ct = topic.getChildTopics();
            String path = ct.getTopic("dmx.files.path").getSimpleValue().toString();
            RelatedTopic mediaType = ct.getTopicOrNull("dmx.files.media_type");
            if (mediaType == null) {
                this.logger.warning("No media type set for File topic " + topic.getId() + ", path=\"" + path + "\"");
                return;
            }
            if (mediaType.getSimpleValue().toString().equals("application/pdf")) {
                this.logger.info("### Indexing PDF file \"" + path + "\"");
                this.indexPDF(path, topic.getId());
            }
        }
    }

    private void indexPDF(String path, long topicId) {
        try {
            File file = this.files.getFile(path);
            PDDocument pdfDocument = Loader.loadPDF((File)file);
            String text = new PDFTextStripper().getText(pdfDocument);
            this.logger.fine("\"" + text + "\"");
            this.logger.info(text.length() + " characters extracted" + (text.length() < 100 ? "\n" + Arrays.toString(text.getBytes()) : ""));
            if (this.isTextAvailable(text)) {
                this.dmx.indexTopicFulltext(topicId, text, "dmx.files.file");
                return;
            }
            text = this.tesseract.doOCR(path);
            this.dmx.indexTopicFulltext(topicId, text, "dmx.files.file");
        }
        catch (Exception e) {
            throw new RuntimeException("Indexing PDF failed, path=\"" + path + "\", File topicId=" + topicId, e);
        }
    }

    private boolean isTextAvailable(String text) {
        return text.chars().anyMatch(c -> c != 10);
    }
}

