/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.sendmail;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.HtmlEmail;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.sendmail.util.SendgridMail;
import systems.dmx.sendmail.util.SendgridWebApiV3;

public class SendmailPlugin
extends PluginActivator
implements SendmailService {
    private static Logger log = Logger.getLogger(SendmailPlugin.class.getName());
    private String SYSTEM_FROM_NAME = null;
    private String SYSTEM_FROM_MAILBOX = null;
    private String SYSTEM_ADMIN_MAILBOX = null;
    private String SENDMAIL_TYPE = null;
    private String SMTP_HOST = null;
    private String SMTP_USERNAME = null;
    private String SMTP_PASSWORD = null;
    private int SMTP_PORT = -1;
    private String SMTP_SECURITY = null;
    private boolean SMTP_DEBUG = false;
    private String SENDGRID_API_KEY = null;

    public void init() {
        try {
            this.loadPluginPropertiesConfig();
            log.info("Sending test mail per " + this.SENDMAIL_TYPE + " on init to \"" + this.SYSTEM_ADMIN_MAILBOX + "\"");
            this.doEmailSystemMailbox("Sendmail Plugin Activated", "Hello dear, this is your new email sending service.\n\nWe hope you can enjoy the comforts!");
        }
        catch (IOException ex) {
            Logger.getLogger(SendmailPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void loadPluginPropertiesConfig() throws IOException {
        String sendmailType = System.getProperty("dmx.sendmail.type");
        this.SENDMAIL_TYPE = sendmailType == null ? "smtp" : sendmailType.trim();
        String fromName = System.getProperty("dmx.sendmail.system_from_name");
        this.SYSTEM_FROM_NAME = fromName == null ? "DMX Sendmail" : fromName.trim();
        String fromMailbox = System.getProperty("dmx.sendmail.system_from_mailbox");
        this.SYSTEM_FROM_MAILBOX = fromMailbox == null ? "dmx@localhost" : fromMailbox.trim();
        String adminMailbox = System.getProperty("dmx.sendmail.system_admin_mailbox");
        this.SYSTEM_ADMIN_MAILBOX = adminMailbox == null ? "root@localhost" : adminMailbox.trim();
        log.info("\n\tdmx.sendmail.system_from_name: " + this.SYSTEM_FROM_NAME + "\n\tdmx.sendmail.system_from_mailbox: " + this.SYSTEM_FROM_MAILBOX + "\n\tdmx.sendmail.system_admin_mailbox: " + this.SYSTEM_ADMIN_MAILBOX + "\n\tdmx.sendmail.type: " + this.SENDMAIL_TYPE);
        String smtpHostName = System.getProperty("dmx.sendmail.smtp_host");
        this.SMTP_HOST = smtpHostName == null ? "localhost" : smtpHostName.trim();
        String smtpUsername = System.getProperty("dmx.sendmail.smtp_username");
        this.SMTP_USERNAME = smtpUsername == null ? "" : smtpUsername.trim();
        String passwd = System.getProperty("dmx.sendmail.smtp_password");
        this.SMTP_PASSWORD = passwd == null ? "" : passwd;
        String smtpPort = System.getProperty("dmx.sendmail.smtp_port");
        this.SMTP_PORT = smtpPort == null ? 25 : Integer.parseInt(smtpPort);
        String smtpSecurity = System.getProperty("dmx.sendmail.smtp_security");
        this.SMTP_SECURITY = smtpSecurity == null ? "" : smtpSecurity.trim();
        String smtpDebug = System.getProperty("dmx.sendmail.smtp_debug");
        boolean bl = this.SMTP_DEBUG = smtpDebug == null ? this.SMTP_DEBUG : Boolean.parseBoolean(smtpDebug);
        if (this.SENDMAIL_TYPE.toLowerCase().equals("smtp")) {
            log.info("\n\tdmx.sendmail.smtp_host: " + this.SMTP_HOST + "\n\tdmx.sendmail.smtp_username: " + this.SMTP_USERNAME + "\n\tdmx.sendmail.smtp_password: PASSWORD HIDDEN FOR LOG\n\tdmx.sendmail.smtp_port: " + this.SMTP_PORT + "\n\tdmx.sendmail.smtp_security: " + this.SMTP_SECURITY + "\n\tdmx.sendmail.smtp_debug: " + this.SMTP_DEBUG);
        } else if (this.SENDMAIL_TYPE.toLowerCase().equals("sendgrid")) {
            this.SENDGRID_API_KEY = System.getProperty("dmx.sendmail.sendgrid_api_key");
            if (this.SENDGRID_API_KEY.isEmpty()) {
                log.severe("Configuration Error: DMX Sendmail is configured to send mails via Sendgrid API but has no\"dmx.sendmail.sendgrid_api_key\" value set");
            } else {
                log.info("dmx.sendmail.sendgrid_api_key: API KEY HIDDEN FOR LOG");
            }
        } else {
            log.severe("Configuration Error: DMX Sendmail has an invalid \"dmx.sendmail.type\" value set");
        }
    }

    @Override
    public void doEmailUser(String username, String subject, String message) {
        String userMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(username);
        if (userMailbox != null) {
            this.sendMailTo(userMailbox, subject, message);
        } else {
            log.severe("Sending email notification to user not possible, \"" + username + "\" has not signed-up with an Email Address");
        }
    }

    @Override
    public void doEmailUser(String fromUsername, String toUsername, String subject, String message) {
        String senderMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(toUsername);
        String recipientMailbox = this.dmx.getPrivilegedAccess().getEmailAddress(toUsername);
        if (recipientMailbox != null && senderMailbox != null) {
            this.sendMailFromTo(senderMailbox, fromUsername, recipientMailbox, toUsername, subject, message);
        } else {
            log.severe("Sending email notification to user not possible. Either \"" + toUsername + "\" or \"" + fromUsername + "\" has not signed-up with an Email Address");
        }
    }

    @Override
    public void doEmailRecipientAs(String from, String fromName, String subject, String message, String recipientMail) {
        this.sendMailFromTo(from, fromName, recipientMail, null, subject, message);
    }

    @Override
    public void doEmailRecipient(String subject, String message, String recipientMail) {
        this.sendMailTo(recipientMail, subject, message);
    }

    @Override
    public void doEmailSystemMailbox(String subject, String message) {
        this.sendMailTo(this.SYSTEM_ADMIN_MAILBOX, subject, message);
    }

    private void sendMailTo(String recipient, String subject, String textMessage) {
        this.sendMailFromTo(this.SYSTEM_FROM_MAILBOX, this.SYSTEM_FROM_NAME, recipient, null, subject, textMessage);
    }

    private void sendMailFromTo(String sender, String senderName, String recipientMailbox, String recipientName, String subject, String htmlMessage) {
        try {
            if (this.SENDMAIL_TYPE.toLowerCase().equals("sendgrid")) {
                SendgridWebApiV3 mailApi = new SendgridWebApiV3(this.SENDGRID_API_KEY);
                SendgridMail mail = mailApi.newMailFromTo(sender, senderName, recipientMailbox, recipientName, subject, htmlMessage);
                mail.send();
            } else if (this.SENDMAIL_TYPE.toLowerCase().equals("smtp")) {
                this.sendSystemMail(recipientMailbox, subject, htmlMessage);
            }
        }
        catch (Exception json) {
            throw new RuntimeException("Sending mail via " + this.SENDMAIL_TYPE + " failed", json);
        }
    }

    private void sendSystemMail(String recipient, String subject, String htmlMessage) {
        Thread.currentThread().setContextClassLoader(SendmailPlugin.class.getClassLoader());
        log.info("BeforeSend: Set classloader to " + Thread.currentThread().getContextClassLoader().toString());
        HtmlEmail email = new HtmlEmail();
        email.setDebug(this.SMTP_DEBUG);
        email.setHostName(this.SMTP_HOST);
        email.setSmtpPort(this.SMTP_PORT);
        if (this.SMTP_SECURITY.toLowerCase().equals("smtps")) {
            email.setSslSmtpPort("" + this.SMTP_PORT);
            email.setSSLOnConnect(true);
            log.info("Set SSLOnConnect...");
        } else if (this.SMTP_SECURITY.toLowerCase().equals("tls")) {
            email.setSslSmtpPort("" + this.SMTP_PORT);
            email.setSSLOnConnect(true);
            email.setStartTLSEnabled(true);
            log.info("Set SSLOnConnect + StartTLSEnabled...");
        }
        if (!this.SMTP_USERNAME.isEmpty() && !this.SMTP_PASSWORD.isEmpty()) {
            log.info("Using SMTP Authentication...");
            email.setAuthentication(this.SMTP_USERNAME, this.SMTP_PASSWORD);
        }
        try {
            String textMessage = JavaUtils.stripHTML((String)htmlMessage);
            log.info("textMessage=\"" + textMessage + "\"+\rhtmlMessage=\"" + htmlMessage + "\"");
            email.setFrom(this.SYSTEM_FROM_MAILBOX, this.SYSTEM_FROM_NAME);
            email.setSubject(subject);
            email.setMsg(textMessage);
            String recipientValue = recipient.trim();
            ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
            if (recipientValue.contains(";")) {
                for (String recipientPart : recipientValue.split(";")) {
                    recipients.add(new InternetAddress(recipientPart.trim()));
                }
            } else {
                recipients.add(new InternetAddress(recipientValue));
            }
            email.setTo(recipients);
            email.send();
            log.info("Mail was SUCCESSFULLY sent to " + email.getToAddresses() + " mail addresses");
        }
        catch (Exception ex) {
            throw new RuntimeException("Sending mail per SMTP FAILED", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(CoreService.class.getClassLoader());
            log.info("AfterSend: Set Classloader back " + Thread.currentThread().getContextClassLoader().toString());
        }
    }
}

