/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.sendmail.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;

public class SendgridMail
implements JSONEnabled {
    private static Logger log = Logger.getLogger(SendgridMail.class.getName());
    private static final String DM4_HOST_URL = System.getProperty("dm4.host.url");
    private JSONObject mail = null;
    private String apiKey = null;

    public SendgridMail(String apiKey, String from, String fromName) {
        try {
            this.apiKey = apiKey;
            this.mail = new JSONObject();
            this.addSender(from, fromName, this.mail);
            JSONObject settings = this.initializeMailSettings(this.mail);
            this.addHostUrlFooter(settings);
        }
        catch (JSONException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void addRecipient(String recipient, String recipientName, String type, String subject) throws JSONException {
        this.addPersonalizations(recipient, recipientName, type, subject, this.mail);
    }

    public void addHTMLMessage(String htmlMessage) throws JSONException {
        this.addContent("text/html", htmlMessage, this.mail);
    }

    public void addTextMessage(String textMessage) throws JSONException {
        this.addContent("text/plain", textMessage, this.mail);
    }

    public void send() {
        try {
            URL apiUrl = new URL("https://api.sendgrid.com/v3/mail/send");
            HttpURLConnection httpConnection = (HttpURLConnection)apiUrl.openConnection();
            httpConnection.setRequestMethod("POST");
            httpConnection.setDoOutput(true);
            httpConnection.setRequestProperty("Authorization", "Bearer " + this.apiKey);
            httpConnection.setRequestProperty("Content-Type", "application/json");
            httpConnection.setRequestProperty("User-Agent", "DeepaMehta 4 Sendgrid Plugin (Java, OSGi)");
            if (this.mail != null) {
                String line;
                log.info("Sendgrid API Mail Request: " + this.mail.toString());
                OutputStream output = httpConnection.getOutputStream();
                output.write(this.mail.toString().getBytes("UTF-8"));
                InputStream response = httpConnection.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(response));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line);
                }
                br.close();
                if (httpConnection.getResponseCode() != 202) {
                    log.severe("An error occured during sending mail via the Sendgrid API ResponseStatus: (" + httpConnection.getResponseCode() + "), Answer:" + sb.toString());
                } else {
                    log.info("Sendgrid API Response OK (" + httpConnection.getResponseCode() + ")");
                }
            } else {
                log.severe("Could not send SendgridApi Mail due to a previous error.");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void addPersonalizations(String recipient, String recipientName, String recipientType, String subject, JSONObject query) throws JSONException {
        JSONArray personals = new JSONArray();
        if (query.has("personalizations")) {
            personals = query.getJSONArray("personalizations");
        } else {
            query.put("personalizations", (Object)personals);
        }
        this.addRecipient(recipient, recipientName, recipientType, subject, personals);
    }

    private void addRecipient(String recipient, String recipientName, String recipientType, String subject, JSONArray personals) throws JSONException {
        JSONArray standardRecipients = null;
        JSONArray copyRecipients = null;
        JSONArray blindCopyRecipients = null;
        for (int idx = 0; idx < personals.length(); ++idx) {
            JSONObject recipientObject = personals.getJSONObject(idx);
            if (recipientObject.has("to")) {
                standardRecipients = recipientObject.getJSONArray("to");
            }
            if (recipientObject.has("cc")) {
                copyRecipients = recipientObject.getJSONArray("cc");
            }
            if (!recipientObject.has("bcc")) continue;
            blindCopyRecipients = recipientObject.getJSONArray("bcc");
        }
        if (recipientType.equals("to")) {
            if (standardRecipients == null) {
                standardRecipients = new JSONArray();
                personals.put((Object)new JSONObject().put("to", (Object)standardRecipients).put("subject", (Object)subject));
            }
            standardRecipients.put((Object)this.createRecipientObject(recipient, recipientName));
        }
        if (recipientType.equals("cc")) {
            if (copyRecipients == null) {
                copyRecipients = new JSONArray();
                personals.put((Object)new JSONObject().put("cc", (Object)copyRecipients).put("subject", (Object)subject));
            }
            copyRecipients.put((Object)this.createRecipientObject(recipient, recipientName));
        }
        if (recipientType.equals("bcc")) {
            if (blindCopyRecipients == null) {
                blindCopyRecipients = new JSONArray();
                personals.put((Object)new JSONObject().put("cc", (Object)blindCopyRecipients).put("subject", (Object)subject));
            }
            blindCopyRecipients.put((Object)this.createRecipientObject(recipient, recipientName));
        }
    }

    private JSONObject createRecipientObject(String recipient, String recipientName) throws JSONException {
        JSONObject entry = new JSONObject();
        if (recipient == null || !recipient.contains("@") || !recipient.contains(".")) {
            throw new RuntimeException("Invalid recipient address " + recipient);
        }
        entry.put("email", (Object)recipient);
        if (recipientName != null && !recipientName.isEmpty()) {
            entry.put("name", (Object)recipientName);
        }
        return entry;
    }

    private void addSender(String from, String fromName, JSONObject query) throws JSONException {
        JSONObject entry = new JSONObject();
        entry.put("email", (Object)from);
        if (fromName != null && !fromName.isEmpty()) {
            entry.put("name", (Object)fromName);
        }
        query.put("from", (Object)entry);
    }

    private void addContent(String contentType, String contentValue, JSONObject query) throws JSONException {
        JSONObject content = new JSONObject();
        content.put("type", (Object)contentType);
        content.put("value", (Object)contentValue);
        if (query.has("content")) {
            query.getJSONArray("content").put((Object)content);
        } else {
            query.put("content", (Object)new JSONArray().put((Object)content));
        }
    }

    private void addHostUrlFooter(JSONObject settings) throws JSONException {
        String htmlValue = "<br/><br/>---<br/><a href=\"" + DM4_HOST_URL + "\">" + DM4_HOST_URL + "</a><br/>";
        String textValue = "\n\n---\n" + DM4_HOST_URL + "\n";
        this.addFooterSetting(textValue, htmlValue, settings);
    }

    private void addFooterSetting(String textValue, String htmlValue, JSONObject settings) throws JSONException {
        JSONObject footer = new JSONObject();
        if (settings.has("footer")) {
            footer = settings.getJSONObject("footer");
            footer.put("text", (Object)textValue);
            if (htmlValue != null) {
                footer.put("html", (Object)htmlValue);
            }
        } else {
            settings.put("footer", (Object)footer);
            footer.put("text", (Object)textValue);
            if (htmlValue != null) {
                footer.put("html", (Object)htmlValue);
            }
        }
        footer.put("enable", true);
    }

    private JSONObject initializeMailSettings(JSONObject query) throws JSONException {
        if (!query.has("mail_settings")) {
            query.put("mail_settings", (Object)new JSONObject());
        }
        return query.getJSONObject("mail_settings");
    }

    public JSONObject toJSON() {
        return this.mail;
    }
}

