/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.sendmail;

import java.util.ArrayList;
import java.util.logging.Logger;
import javax.mail.internet.InternetAddress;
import org.apache.commons.mail.HtmlEmail;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.JavaUtils;
import systems.dmx.sendmail.Configuration;

class JavaMail {
    private static final Logger log = Logger.getLogger(JavaMail.class.getName());
    Configuration configuration;

    JavaMail(Configuration configuration) {
        this.configuration = configuration;
    }

    void sendSystemMail(String recipient, String subject, String textMessage, String htmlMessage) {
        Thread.currentThread().setContextClassLoader(JavaMail.class.getClassLoader());
        log.info("BeforeSend: Set classloader to " + Thread.currentThread().getContextClassLoader().toString());
        HtmlEmail email = new HtmlEmail();
        email.setDebug(this.configuration.isSmtpDebugEnabled());
        email.setHostName(this.configuration.getSmtpHost());
        email.setSmtpPort(this.configuration.getSmtpPort());
        if (this.configuration.getSmtpSecurity().equals("smtps")) {
            email.setSslSmtpPort(String.valueOf(this.configuration.getSmtpPort()));
            email.setSSLOnConnect(true);
            log.info("Set SSLOnConnect...");
        } else if (this.configuration.getSmtpSecurity().equals("tls")) {
            email.setSslSmtpPort(String.valueOf(this.configuration.getSmtpPort()));
            email.setSSLOnConnect(true);
            email.setStartTLSEnabled(true);
            log.info("Set SSLOnConnect + StartTLSEnabled...");
        }
        if (!this.configuration.getSmtpUsername().isEmpty() && !this.configuration.getSmtpPassword().isEmpty()) {
            log.info("Using SMTP Authentication...");
            email.setAuthentication(this.configuration.getSmtpUsername(), this.configuration.getSmtpPassword());
        }
        try {
            email.setFrom(this.configuration.getSystemAdminEmailAddress(), this.configuration.getSystemFromName());
            email.setSubject(subject);
            if (textMessage == null) {
                textMessage = JavaUtils.stripHTML((String)htmlMessage);
            }
            email.setTextMsg(textMessage);
            if (htmlMessage != null) {
                email.setHtmlMsg(new String(htmlMessage.getBytes("UTF-8"), 0));
            }
            String recipientValue = recipient.trim();
            ArrayList<InternetAddress> recipients = new ArrayList<InternetAddress>();
            if (recipientValue.contains(";")) {
                for (String recipientPart : recipientValue.split(";")) {
                    recipients.add(new InternetAddress(recipientPart.trim()));
                }
            } else {
                recipients.add(new InternetAddress(recipientValue));
            }
            email.setTo(recipients);
            email.send();
            log.info("Mail was SUCCESSFULLY sent to " + email.getToAddresses() + " mail addresses");
        }
        catch (Exception ex) {
            throw new RuntimeException("Sending mail per SMTP FAILED", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(CoreService.class.getClassLoader());
            log.info("AfterSend: Set Classloader back " + Thread.currentThread().getContextClassLoader().toString());
        }
    }
}

