/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.sendmail;

import java.util.logging.Logger;
import systems.dmx.sendmail.JavaMail;
import systems.dmx.sendmail.util.SendgridMail;
import systems.dmx.sendmail.util.SendgridWebApiV3;

class SendMailFromToUseCase {
    private static final Logger log = Logger.getLogger(SendMailFromToUseCase.class.getName());
    String sendmailType;
    JavaMail javaMail;
    SendgridWebApiV3 sendgridWebApi;

    SendMailFromToUseCase(String sendMailType, JavaMail javaMail, SendgridWebApiV3 sendgridWebApi) {
        this.sendmailType = sendMailType;
        this.javaMail = javaMail;
        this.sendgridWebApi = sendgridWebApi;
    }

    void invoke(String sender, String senderName, String recipientMailbox, String recipientName, String subject, String textMessage, String htmlMessage) {
        if (textMessage == null && htmlMessage == null) {
            throw new IllegalArgumentException("Either textMessage or htmlMessage must not be null but never both!");
        }
        try {
            if (this.sendmailType.equals("sendgrid")) {
                SendgridMail mail = this.sendgridWebApi.newMailFromTo(sender, senderName, recipientMailbox, recipientName, subject, textMessage, htmlMessage);
                mail.send();
            } else if (this.sendmailType.equals("smtp")) {
                this.javaMail.sendSystemMail(recipientMailbox, subject, textMessage, htmlMessage);
            }
        }
        catch (Exception json) {
            throw new RuntimeException("Sending mail via " + this.sendmailType + " failed", json);
        }
    }
}

