/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.migrations;

import java.util.logging.Logger;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration2
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    WorkspacesService wsService;
    private static final String MIGRATION2_SIGNUP_UI_DEFAULT_CONFIGURATION_URI = "dmx.signup_ui.default_configuration";
    private static final String MIGRATION2_SIGNUP_CONFIGURATION = "dmx.signup_ui.configuration";
    private static final String MIGRATION2_CONFIG_PROJECT_TITLE = "dmx.signup_ui.project_title";
    private static final String MIGRATION2_CONFIG_WEBAPP_TITLE = "dmx.signup_ui.webapp_title";
    private static final String MIGRATION2_CONFIG_LOGO_PATH = "dmx.signup_ui.webapp_logo_path";
    private static final String MIGRATION2_CONFIG_CUSTOM_CSS_PATH = "dmx.signup_ui.custom_css_path";
    private static final String MIGRATION2_CONFIG_READ_MORE_URL = "dmx.signup_ui.read_more_url";
    private static final String MIGRATION2_CONFIG_PAGES_FOOTER = "dmx.signup_ui.pages_footer";
    private static final String MIGRATION2_CONFIG_TOS_LABEL = "dmx.signup_ui.tos_label";
    private static final String MIGRATION2_CONFIG_TOS_DETAILS = "dmx.signup_ui.tos_detail";
    private static final String MIGRATION2_CONFIG_PD_LABEL = "dmx.signup_ui.pd_label";
    private static final String MIGRATION2_CONFIG_PD_DETAILS = "dmx.signup_ui.pd_detail";
    private static final String MIGRATION2_CONFIG_START_PAGE_URL = "dmx.signup_ui.start_page_url";
    private static final String MIGRATION2_CONFIG_HOME_PAGE_URL = "dmx.signup_ui.home_page_url";
    private static final String MIGRATION2_CONFIG_IMPRINT_URL = "dmx.signup_ui.imprint_url";
    private static final String MIGRATION2_CONFIG_PRIVACY_POLICY_URL = "dmx.signup_ui.privacy_policy_url";
    private static final String MIGRATION2_CONFIG_LOADING_APP_HINT = "dmx.signup_ui.loading_app_hint";
    private static final String MIGRATION2_CONFIG_LOGGING_OUT_HINT = "dmx.signup_ui.logging_out_hint";
    private static final String PLUGIN_URI = "systems.dmx.sign-up-ui";
    private static final String DEFAULT_CONFIG_PROJECT_TITLE = System.getProperty("dmx.signup_ui.project_title", "My Sign-Up UI DMX");
    private static final String DEFAULT_CONFIG_WEBAPP_TITLE = System.getProperty("dmx.signup_ui.webapp_title", "My Sign-Up UI DMX");
    private static final String DEFAULT_CONFIG_LOGO_PATH = System.getProperty("dmx.signup_ui.webapp_logo_path", "/systems.dmx.sign-up-ui/dmx-logo.svg");
    private static final String DEFAULT_CONFIG_CUSTOM_CSS_PATH = System.getProperty("dmx.signup_ui.custom_css_path", "/systems.dmx.sign-up-ui/style/style.css");
    private static final String DEFAULT_CONFIG_READ_MORE_URL = System.getProperty("dmx.signup_ui.read_more_url", "...");
    private static final String DEFAULT_CONFIG_PAGES_FOOTER = System.getProperty("dmx.signup_ui.pages_footer", "standard");
    private static final String DEFAULT_CONFIG_TOS_LABEL = System.getProperty("dmx.signup_ui.tos_label", "Terms of Service");
    private static final String DEFAULT_CONFIG_TOS_DETAILS = System.getProperty("dmx.signup_ui.tos_detail", "...");
    private static final String DEFAULT_CONFIG_PD_LABEL = System.getProperty("dmx.signup_ui.pd_label", "I understand that any private information I give to this site may be made publicly available.");
    private static final String DEFAULT_CONFIG_PD_DETAILS = System.getProperty("dmx.signup_ui.pd_detail", "...");
    private static final String DEFAULT_START_PAGE_URL = System.getProperty("dmx.signup_ui.start_page_url", "/systems.dmx.webclient/");
    private static final String DEFAULT_IMPRINT_URL = System.getProperty("dmx.signup_ui.imprint_url", "/systems.dmx.webclient/#/imprint");
    private static final String DEFAULT_PRIVACY_POLICY_URL = System.getProperty("dmx.signup_ui.privacy_policy_url", "/systems.dmx.webclient/#/privacy_policy");
    private static final String DEFAULT_HOME_PAGE_URL = System.getProperty("dmx.signup_ui.home_page_url", "/systems.dmx.webclient/");
    private static final String DEFAULT_LOADING_APP_HINT = System.getProperty("dmx.signup_ui.loading_app_hint", "Loading DMX Webclient");
    private static final String DEFAULT_LOGGING_OUT_HINT = System.getProperty("dmx.signup_ui.logging_out_hint", "Logging out..");

    public void run() {
        this.createConfigTopicWithDefaultValues();
        this.assignToAdminworkspace();
    }

    private void createConfigTopicWithDefaultValues() {
        this.logger.info("###### Create default configuration with default values coming from platform configuration or built-in values.");
        ChildTopicsModel ctm = this.mf.newChildTopicsModel();
        ctm.set(MIGRATION2_CONFIG_PROJECT_TITLE, (Object)DEFAULT_CONFIG_PROJECT_TITLE);
        ctm.set(MIGRATION2_CONFIG_WEBAPP_TITLE, (Object)DEFAULT_CONFIG_WEBAPP_TITLE);
        ctm.set(MIGRATION2_CONFIG_LOGO_PATH, (Object)DEFAULT_CONFIG_LOGO_PATH);
        ctm.set(MIGRATION2_CONFIG_CUSTOM_CSS_PATH, (Object)DEFAULT_CONFIG_CUSTOM_CSS_PATH);
        ctm.set(MIGRATION2_CONFIG_READ_MORE_URL, (Object)DEFAULT_CONFIG_READ_MORE_URL);
        ctm.set(MIGRATION2_CONFIG_PAGES_FOOTER, (Object)DEFAULT_CONFIG_PAGES_FOOTER);
        ctm.set(MIGRATION2_CONFIG_TOS_LABEL, (Object)DEFAULT_CONFIG_TOS_LABEL);
        ctm.set(MIGRATION2_CONFIG_TOS_DETAILS, (Object)DEFAULT_CONFIG_TOS_DETAILS);
        ctm.set(MIGRATION2_CONFIG_PD_LABEL, (Object)DEFAULT_CONFIG_PD_LABEL);
        ctm.set(MIGRATION2_CONFIG_PD_DETAILS, (Object)DEFAULT_CONFIG_PD_DETAILS);
        ctm.set(MIGRATION2_CONFIG_START_PAGE_URL, (Object)DEFAULT_START_PAGE_URL);
        ctm.set(MIGRATION2_CONFIG_HOME_PAGE_URL, (Object)DEFAULT_HOME_PAGE_URL);
        ctm.set(MIGRATION2_CONFIG_IMPRINT_URL, (Object)DEFAULT_IMPRINT_URL);
        ctm.set(MIGRATION2_CONFIG_PRIVACY_POLICY_URL, (Object)DEFAULT_PRIVACY_POLICY_URL);
        ctm.set(MIGRATION2_CONFIG_LOADING_APP_HINT, (Object)DEFAULT_LOADING_APP_HINT);
        ctm.set(MIGRATION2_CONFIG_LOGGING_OUT_HINT, (Object)DEFAULT_LOGGING_OUT_HINT);
        this.dmx.createTopic(this.mf.newTopicModel(MIGRATION2_SIGNUP_UI_DEFAULT_CONFIGURATION_URI, MIGRATION2_SIGNUP_CONFIGURATION, ctm));
    }

    private void assignToAdminworkspace() {
        long administrationWsId = this.dmx.getPrivilegedAccess().getAdminWorkspaceId();
        this.logger.info("###### Migrate all relevant Sign-up UI Configration Topics to \"Administration\" Workspace");
        Topic standardConfiguration = this.dmx.getTopicByUri(MIGRATION2_SIGNUP_UI_DEFAULT_CONFIGURATION_URI);
        this.wsService.assignToWorkspace((DMXObject)standardConfiguration, administrationWsId);
        standardConfiguration.loadChildTopics();
        RelatedTopic webAppTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_WEBAPP_TITLE);
        RelatedTopic logoPath = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_LOGO_PATH);
        RelatedTopic cssPath = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_CUSTOM_CSS_PATH);
        RelatedTopic projectTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_PROJECT_TITLE);
        RelatedTopic tosLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_TOS_LABEL);
        RelatedTopic tosDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_TOS_DETAILS);
        RelatedTopic pdLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_PD_LABEL);
        RelatedTopic pdDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_PD_DETAILS);
        RelatedTopic readMoreUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_READ_MORE_URL);
        RelatedTopic pagesFooter = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_PAGES_FOOTER);
        RelatedTopic startPageUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_START_PAGE_URL);
        RelatedTopic homePageUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_HOME_PAGE_URL);
        RelatedTopic loadingAppHint = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_LOADING_APP_HINT);
        RelatedTopic loggingOutHint = standardConfiguration.getChildTopics().getTopic(MIGRATION2_CONFIG_LOGGING_OUT_HINT);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)logoPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)logoPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)startPageUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)startPageUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)homePageUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)homePageUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loadingAppHint, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loadingAppHint.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loggingOutHint, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loggingOutHint.getRelatingAssoc(), administrationWsId);
    }
}

