/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.view;

import java.util.ResourceBundle;
import javax.inject.Inject;
import org.thymeleaf.context.AbstractContext;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup_ui.configuration.ModuleConfiguration;
import systems.dmx.signup_ui.view.ViewRenderer;

public class ViewRendererImpl
implements ViewRenderer {
    private AccessControlService accessControlService;
    private SignupService signupService;
    private AbstractContext context;

    @Inject
    public ViewRendererImpl(AccessControlService accessControlService, SignupService signupService, AbstractContext context) {
        this.accessControlService = accessControlService;
        this.signupService = signupService;
        this.context = context;
    }

    private void viewData(String name, Object value) {
        this.context.setVariable(name, value);
    }

    @Override
    public void prepare(ModuleConfiguration moduleConfiguration, ResourceBundle rb, String lastAuthorizationMethod, String templateName) {
        this.viewData("username_policy", SignUpConfigOptions.CONFIG_USERNAME_POLICY.name().toLowerCase());
        this.viewData("authorization_methods", this.signupService.getAuthorizationMethods());
        this.viewData("last_authorization_method", lastAuthorizationMethod);
        this.viewData("is_account_creation_password_editable", null);
        this.viewData("self_registration_enabled", this.signupService.isSelfRegistrationEnabled());
        this.viewData("title", moduleConfiguration.getWebAppTitle());
        this.viewData("logo_path", moduleConfiguration.getLogoPath());
        this.viewData("css_path", moduleConfiguration.getCssPath());
        this.viewData("project_name", moduleConfiguration.getProjectTitle());
        this.viewData("read_more_url", moduleConfiguration.getReadMoreUrl());
        this.viewData("tos_label", moduleConfiguration.getTosLabel());
        this.viewData("tos_details", moduleConfiguration.getTosDetails());
        this.viewData("pd_label", moduleConfiguration.getPdLabel());
        this.viewData("pd_details", moduleConfiguration.getPdDetails());
        this.viewData("footer", moduleConfiguration.getPagesFooter());
        this.viewData("custom_workspace_enabled", this.signupService.getConfiguration().getApiEnabled());
        this.viewData("custom_workspace_description", this.signupService.getConfiguration().getApiDescription());
        this.viewData("custom_workspace_details", this.signupService.getConfiguration().getApiDetails());
        this.viewData("custom_workspace_uri", this.signupService.getConfiguration().getApiWorkspaceUri());
        this.viewData("start_url", moduleConfiguration.getStartUrl());
        this.viewData("visit_start_url", rb.getString("visit_start_url"));
        this.viewData("home_url", moduleConfiguration.getHomeUrl());
        this.viewData("visit_home_url", rb.getString("visit_home_url"));
        this.viewData("loading_app_hint", moduleConfiguration.getLoadingAppHint());
        this.viewData("logging_out_hint", moduleConfiguration.getLoggingOutHint());
        this.viewData("password_length_hint", rb.getString("password_length_hint"));
        this.viewData("password_match_hint", rb.getString("password_match_hint"));
        this.viewData("check_terms_hint", rb.getString("check_terms_hint"));
        this.viewData("username_invalid_hint", rb.getString("username_invalid_hint"));
        this.viewData("username_taken_hint", rb.getString("username_taken_hint"));
        this.viewData("email_invalid_hint", rb.getString("email_invalid_hint"));
        this.viewData("email_taken_hint", rb.getString("email_taken_hint"));
        this.viewData("not_authorized_message", rb.getString("not_authorized_message"));
        this.viewData("signup_title", rb.getString("signup_title"));
        this.viewData("create_account", rb.getString("create_account"));
        this.viewData("login_title", rb.getString("login_title"));
        this.viewData("log_in_small", rb.getString("log_in_small"));
        this.viewData("login", rb.getString("login"));
        this.viewData("or_label", rb.getString("or_label"));
        this.viewData("logout", rb.getString("logout"));
        this.viewData("logged_in_as", rb.getString("logged_in_as"));
        this.viewData("label_username", rb.getString("label_username"));
        this.viewData("label_displayname", rb.getString("label_displayname"));
        this.viewData("label_email", rb.getString("label_email"));
        this.viewData("label_password", rb.getString("label_password"));
        this.viewData("label_password_repeat", rb.getString("label_password_repeat"));
        this.viewData("read_more", rb.getString("read_more"));
        this.viewData("label_forgot_password", rb.getString("forgot_password"));
        this.viewData("label_reset_password", rb.getString("reset_password"));
        this.viewData("label_reset_password_submit", rb.getString("reset_password_submit"));
        this.viewData("info_reset_password", rb.getString("reset_password_hint"));
        this.viewData("password_reset_ok_message", rb.getString("password_reset_success_1"));
        this.viewData("your_account_title", rb.getString("your_account_title"));
        this.viewData("your_account_heading", rb.getString("your_account_heading"));
        this.viewData("your_account_username_label", rb.getString("your_account_username_label"));
        this.viewData("your_account_email_label", rb.getString("your_account_email_label"));
        this.viewData("api_option_title", rb.getString("api_option_title"));
        this.viewData("api_option_descr", rb.getString("api_option_descr"));
        this.viewData("api_option_revoke", rb.getString("api_option_revoke"));
        this.viewData("api_workspace_member", this.signupService.isApiWorkspaceMember());
        this.viewData("api_email_contact", this.signupService.getSystemEmailContactOrEmpty());
        this.viewData("api_contact_revoke", rb.getString("api_contact_revoke"));
        this.viewData("imprint", rb.getString("imprint"));
        this.viewData("imprint_url", moduleConfiguration.getImprintUrl());
        this.viewData("privacy_policy", rb.getString("privacy_policy"));
        this.viewData("privacy_policy_url", moduleConfiguration.getPrivacyPolicyUrl());
        this.viewData("created_page_title", rb.getString("page_account_created_title"));
        this.viewData("created_page_body_1", rb.getString("page_account_created_body_1"));
        this.viewData("created_page_body_2", rb.getString("page_account_created_body_2"));
        this.viewData("created_page_body_3", rb.getString("page_account_created_body_3"));
        this.viewData("created_page_body_4", rb.getString("page_account_created_body_4"));
        this.viewData("requested_page_title", rb.getString("page_account_requested_title"));
        this.viewData("requested_page_1", rb.getString("page_account_requested_1"));
        this.viewData("requested_page_2", rb.getString("page_account_requested_2"));
        this.viewData("requested_page_3", rb.getString("page_account_requested_3"));
        this.viewData("email_confirmation_active", SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION);
        this.viewData("skip_confirmation_mail_label", rb.getString("admin_skip_email_confirmation_mail"));
        this.viewData("can_create_new_account", this.signupService.hasAccountCreationPrivilege());
        String username = this.accessControlService.getUsername();
        this.viewData("authenticated", username != null);
        this.viewData("username", username);
        this.viewData("template", templateName);
        this.viewData("hostUrl", SignUpConfigOptions.DMX_HOST_URL);
    }
}

