/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui;

import com.sun.jersey.api.view.Viewable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.osgi.framework.Bundle;
import org.thymeleaf.context.AbstractContext;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Topic;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.signup.EmailTextProducer;
import systems.dmx.signup.PasswordResetTokenCheckRequestResult;
import systems.dmx.signup.ProcessSignUpRequestResult;
import systems.dmx.signup.SignUpRequestResult;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.configuration.AccountCreation;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup_ui.SignupUiService;
import systems.dmx.signup_ui.configuration.ModuleConfiguration;
import systems.dmx.signup_ui.di.DaggerSignupUiComponent;
import systems.dmx.signup_ui.di.SignupUiComponent;
import systems.dmx.signup_ui.email.SignUpUiEmailTextProducer;
import systems.dmx.signup_ui.events.SignupResourceRequestedListener;
import systems.dmx.signup_ui.view.ViewRenderer;
import systems.dmx.signup_ui.web.ResponseBuilder;
import systems.dmx.thymeleaf.ThymeleafPlugin;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/sign-up-ui")
public class SignupUiPlugin
extends ThymeleafPlugin
implements SignupUiService {
    static final Logger logger = Logger.getLogger(SignupUiPlugin.class.getName());
    private ModuleConfiguration activeModuleConfiguration = null;
    private Topic customWorkspaceAssignmentTopic = null;
    private ResourceBundle rb = null;
    @Inject
    private AccessControlService accesscontrol;
    @Inject
    SignupService signupService;
    @Inject
    WorkspacesService wsService;
    ViewRenderer viewRenderer;
    ResponseBuilder responseBuilder;
    static DMXEvent SIGNUP_RESOURCE_REQUESTED = new DMXEvent(SignupResourceRequestedListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((SignupResourceRequestedListener)listener).signupResourceRequested((AbstractContext)params[0], (String)params[1]);
        }
    };

    public void init() {
        this.initTemplateEngine();
        this.reloadAssociatedSignupConfiguration();
        this.loadPluginLanguageProperty();
        SignupUiComponent component = DaggerSignupUiComponent.builder().signupService(this.signupService).accessControlService(this.accesscontrol).abstractContextProvider(() -> ((SignupUiPlugin)this).context()).build();
        this.responseBuilder = component.responseBuilder();
        this.viewRenderer = component.viewRenderer();
    }

    @GET
    @Path(value="/translation/{locale}")
    @Produces(value={"application/json"})
    public String getTranslationTable(@PathParam(value="locale") String language) {
        if (language.isEmpty()) {
            return null;
        }
        Locale le = new Locale(language);
        ResourceBundle newRb = ResourceBundle.getBundle("SignupMessages", le);
        Enumeration<String> bundleKeys = newRb.getKeys();
        JSONObject response = new JSONObject();
        while (bundleKeys.hasMoreElements()) {
            try {
                String key = bundleKeys.nextElement();
                response.put(key, (Object)newRb.getString(key));
            }
            catch (JSONException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return response.toString();
    }

    @GET
    @Path(value="/password-token/{email}/{redirectUrl}")
    @Produces(value={"application/json"})
    public Response initiateRedirectPasswordReset(@PathParam(value="email") String email, @PathParam(value="redirectUrl") String redirectUrl) {
        logger.info("Password reset requested for user with Email: \"" + email + "\" wishing to redirect to: \"" + redirectUrl + "\"");
        switch (this.signupService.requestInitiateRedirectPasswordReset(email, redirectUrl)) {
            case SUCCESS: {
                return this.responseBuilder.ok();
            }
        }
        return this.responseBuilder.serverError();
    }

    @Override
    @GET
    @Path(value="/password-token/{email}")
    @Produces(value={"text/html"})
    public Response initiatePasswordReset(@PathParam(value="email") String email) throws URISyntaxException {
        logger.info("Password reset requested for user with Email: \"" + email + "\"");
        return this.initiatePasswordResetWithName(email, null);
    }

    @Override
    @GET
    @Path(value="/password-token/{emailAddress}/{name}")
    @Produces(value={"text/html"})
    public Response initiatePasswordResetWithName(@PathParam(value="emailAddress") String emailAddress, @PathParam(value="name") String name) throws URISyntaxException {
        logger.info("Password reset requested for user with Email: \"" + emailAddress + "\" and Name: \"" + name + "\"");
        switch (this.signupService.requestInitiatePasswordReset(emailAddress, name)) {
            case SUCCESS: {
                return this.responseBuilder.temporaryRedirect("/sign-up-ui/token-info");
            }
        }
        return this.responseBuilder.temporaryRedirect("/sign-up-ui/error");
    }

    @GET
    @Path(value="/password-reset/{token}")
    @Produces(value={"application/xhtml+xml"})
    public Viewable handlePasswordResetRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token) {
        PasswordResetTokenCheckRequestResult result = this.signupService.requestPasswordResetTokenCheck(token);
        switch (result.code) {
            case INVALID_TOKEN: {
                this.viewData("message", this.rb.getString("link_invalid"));
                return this.getFailureView("updated");
            }
            case SUCCESS: {
                this.viewData("token", token);
                this.viewData("mailbox", result.email);
                this.viewData("requested_username", result.username);
                this.viewData("requested_display_name", result.displayName);
                this.viewData("password_requested_title", this.rb.getString("password_requested_title"));
                this.viewData("password_requested_button", this.rb.getString("password_requested_button"));
                if (result.redirectUrl != null) {
                    this.viewData("redirect_url", result.redirectUrl);
                }
                this.prepareSignupPage("password-reset", lastAuthorizationMethod);
                return this.view("password-reset");
            }
            case LINK_EXPIRED: {
                this.viewData("message", this.rb.getString("reset_link_expired"));
                return this.getFailureView("updated");
            }
        }
        this.viewData("message", this.rb.getString("reset_link_error"));
        return this.getFailureView("updated");
    }

    @GET
    @Path(value="/password-reset/{token}/{password}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processPasswordUpdateRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token, @PathParam(value="password") String password) {
        logger.info("Processing Password Update Request Token... ");
        switch (this.signupService.requestPasswordChange(token, password)) {
            case SUCCESS: {
                this.viewData("message", this.rb.getString("reset_password_ok"));
                this.prepareSignupPage("password-ok", lastAuthorizationMethod);
                return this.view("password-ok");
            }
        }
        this.viewData("message", this.rb.getString("reset_password_error"));
        return this.getFailureView("updated");
    }

    @GET
    @Path(value="/handle/{username}/{emailAddress}/{displayName}/{pass-one}/{skipConfirmation}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="emailAddress") String emailAddress, @PathParam(value="displayName") String displayName, @PathParam(value="pass-one") String password, @PathParam(value="skipConfirmation") boolean skipConfirmation) {
        SignUpRequestResult result = this.signupService.requestSignUp(username, emailAddress, displayName, password, skipConfirmation);
        try {
            switch (result.code) {
                case SUCCESS_ACCOUNT_PENDING: {
                    logger.info("Account pending");
                    throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up-ui/pending")).build());
                }
                case SUCCESS_ACCOUNT_CREATED: {
                    logger.info("Account created");
                    throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up-ui/" + result.username + "/ok")).build());
                }
                case SUCCESS_EMAIL_CONFIRMATION_NEEDED: {
                    throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up-ui/token-info")).build());
                }
                case ACCOUNT_CREATION_DENIED: {
                    logger.warning("Account creation denied");
                }
                case ERROR_INVALID_EMAIL: {
                    logger.warning("Error invalid email");
                }
                case ADMIN_PRIVILEGE_MISSING: {
                    logger.warning("Admin privilege missing");
                }
                case UNEXPECTED_ERROR: {
                    logger.warning("Unexpected error");
                }
            }
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Could not build response URI while handling sign-up request", ex);
        }
        return this.getFailureView("created");
    }

    @GET
    @Path(value="/handle/{username}/{emailAddress}/{displayName}/{pass-one}")
    @Produces(value={"text/html"})
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="emailAddress") String emailAddress, @PathParam(value="displayName") String displayName, @PathParam(value="pass-one") String password) {
        return this.handleSignupRequest(username, emailAddress, displayName, password, false);
    }

    @GET
    @Path(value="/confirm/{token}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processSignupRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token) {
        ProcessSignUpRequestResult result = this.signupService.requestProcessSignUp(token);
        switch (result.code) {
            case SUCCESS: {
                this.viewData("message", this.rb.getString("account_created"));
                return this.getAccountCreationOKView(lastAuthorizationMethod, result.username);
            }
            case SUCCESS_ACCOUNT_PENDING: {
                this.viewData("message", this.rb.getString("account_created"));
                return this.getAccountCreationPendingView(lastAuthorizationMethod);
            }
            case INVALID_TOKEN: {
                this.viewData("username", null);
                this.viewData("message", this.rb.getString("link_invalid"));
                return this.getFailureView("created");
            }
            case LINK_EXPIRED: {
                this.viewData("username", null);
                this.viewData("message", this.rb.getString("link_expired"));
                return this.getFailureView("created");
            }
        }
        this.viewData("message", this.rb.getString("internal_error"));
        return this.getFailureView("created");
    }

    @GET
    @Path(value="/check/{username}")
    public String getUsernameAvailability(@PathParam(value="username") String username) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", !this.signupService.isUsernameTaken(username));
            return response.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/check/mailbox/{emailAddress}")
    public String getMailboxAvailability(@PathParam(value="emailAddress") String emailAddress) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", !this.signupService.isEmailAddressTaken(emailAddress));
            return response.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Viewable getSignupFormView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        String page = null;
        switch (SignUpConfigOptions.CONFIG_ACCOUNT_CREATION) {
            case DISABLED: {
                page = this.signupService.isLoggedIn() != false ? "logout" : "login";
                break;
            }
            case ADMIN: {
                page = this.signupService.isLoggedIn().booleanValue() ? (this.signupService.hasAccountCreationPrivilege() ? "sign-up" : "logout") : "login";
                break;
            }
            case PUBLIC: {
                page = this.signupService.isLoggedIn() == false || this.signupService.hasAccountCreationPrivilege() ? "sign-up" : "logout";
            }
        }
        this.prepareSignupPage(page, lastAuthorizationMethod);
        return this.view(page);
    }

    @GET
    @Path(value="/login")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getLoginView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        if (this.accesscontrol.getUsername() != null) {
            this.prepareSignupPage("logout", lastAuthorizationMethod);
            return this.view("logout");
        }
        this.prepareSignupPage("login", lastAuthorizationMethod);
        return this.view("login");
    }

    @GET
    @Path(value="/request-password")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getPasswordResetView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.prepareSignupPage("request-password", lastAuthorizationMethod);
        return this.view("request-password");
    }

    @GET
    @Path(value="/{username}/ok")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationOKView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="username") String username) {
        this.prepareSignupPage("ok", lastAuthorizationMethod);
        this.viewData("requested_username", username);
        return this.view("ok");
    }

    @GET
    @Path(value="/pending")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationPendingView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.prepareSignupPage("pending", lastAuthorizationMethod);
        return this.view("pending");
    }

    @GET
    @Path(value="/error")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getFailureView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        return this.getFailureView(null, lastAuthorizationMethod);
    }

    private Viewable getFailureView(String status, String lastAuthorizationMethod) {
        if (status != null && status.equals("created")) {
            this.viewData("status_label", this.rb.getString("status_label_created"));
        } else {
            this.viewData("status_label", this.rb.getString("status_label_updated"));
        }
        this.viewData("account_failure_message", this.rb.getString("account_failure_message"));
        this.viewData("please_try_1", this.rb.getString("please_try_1"));
        this.viewData("please_try_2", this.rb.getString("please_try_2"));
        this.viewData("please_try_3", this.rb.getString("please_try_3"));
        this.prepareSignupPage("failure", lastAuthorizationMethod);
        return this.view("failure");
    }

    @GET
    @Path(value="/token-info")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getConfirmationInfoView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.prepareSignupPage("account-confirmation", lastAuthorizationMethod);
        return this.view("account-confirmation");
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountDetailsView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.prepareSignupPage("account-edit", lastAuthorizationMethod);
        this.prepareAccountEditPage();
        return this.view("account-edit");
    }

    private boolean isAccountCreationPasswordEditable() {
        return SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_PASSWORD_HANDLING == AccountCreation.PasswordHandling.EDITABLE;
    }

    private void reloadAssociatedSignupConfiguration() {
        this.activeModuleConfiguration = this.getCurrentSignupConfiguration();
        if (!this.activeModuleConfiguration.isValid()) {
            logger.warning("Could not load associated Sign-up Plugin Configuration Topic during init/postUpdate");
            return;
        }
        this.activeModuleConfiguration.reload();
        this.customWorkspaceAssignmentTopic = this.activeModuleConfiguration.getCustomWorkspaceAssignmentTopic();
        if (this.customWorkspaceAssignmentTopic != null) {
            logger.info("Configured Custom Sign-up Workspace => \"" + this.customWorkspaceAssignmentTopic.getSimpleValue() + "\"");
        }
        logger.log(Level.INFO, "Sign-up Configuration Loaded (URI=\"{0}\"), Name=\"{1}\"", new Object[]{this.activeModuleConfiguration.getConfigurationUri(), this.activeModuleConfiguration.getConfigurationName()});
    }

    private ResourceBundle tryLoadResourceBundleFromPluginConfDir(Locale locale) {
        try {
            return ResourceBundle.getBundle("SignupMessages", locale, new URLClassLoader(new URL[]{this.getPluginConfDir().toURI().toURL()}));
        }
        catch (IOException | MissingResourceException e) {
            return null;
        }
    }

    private void loadPluginLanguageProperty() {
        try {
            Locale locale = Locale.forLanguageTag(this.activeModuleConfiguration.getLanguage());
            logger.info("Sign-up Plugin Language option sets labels to " + locale.getDisplayLanguage());
            this.rb = this.tryLoadResourceBundleFromPluginConfDir(locale);
            if (this.rb == null) {
                logger.info("Using built-in messages");
                this.rb = ResourceBundle.getBundle("SignupMessages", locale);
            } else {
                logger.info("Using messages from plugin conf dir");
            }
        }
        catch (MissingResourceException mre) {
            logger.warning("Could not find Sign-up plugin properties - use default resource bundle for labels");
            this.rb = ResourceBundle.getBundle("SignupMessages", Locale.ENGLISH);
        }
        this.signupService.setEmailTextProducer((EmailTextProducer)new SignUpUiEmailTextProducer(System.getProperty("dmx.host.url"), this.activeModuleConfiguration.getWebAppTitle(), this.rb));
    }

    private ModuleConfiguration getCurrentSignupConfiguration() {
        return new ModuleConfiguration(this.dmx.getTopicByUri("dmx.signup_ui.default_configuration"));
    }

    private void prepareSignupPage(String templateName, String lastAuthorizationMethod) {
        if (this.activeModuleConfiguration.isValid()) {
            this.dmx.fireEvent(SIGNUP_RESOURCE_REQUESTED, new Object[]{this.context(), templateName});
            this.viewRenderer.prepare(this.activeModuleConfiguration, this.rb, lastAuthorizationMethod, templateName);
        } else {
            logger.severe("Could not load module configuration of sign-up plugin during page preparation!");
        }
    }

    private void prepareAccountEditPage() {
        String username = this.accesscontrol.getUsername();
        if (username != null) {
            String eMailAddressValue = "None";
            try {
                eMailAddressValue = this.dmx.getPrivilegedAccess().getEmailAddress(username);
            }
            catch (Exception e) {
                logger.warning("Username has no Email Address topic related via \"dmx.base.user_mailbox\"");
            }
            this.viewData("logged_in", true);
            this.viewData("username", username);
            this.viewData("display_name", this.signupService.getDisplayName(username));
            this.viewData("email", eMailAddressValue);
            this.viewData("link", "");
        } else {
            this.viewData("logged_in", false);
            this.viewData("username", "Not logged in");
            this.viewData("email", "Not logged in");
            this.viewData("link", "/sign-up-ui/login");
        }
    }

    @Override
    public void reinitTemplateEngine() {
        super.initTemplateEngine();
    }

    @Override
    public void addTemplateResolverBundle(Bundle bundle) {
        super.addTemplateResourceBundle(bundle);
    }

    @Override
    public void removeTemplateResolverBundle(Bundle bundle) {
        super.removeTemplateResourceBundle(bundle);
    }

    private File getPluginConfDir() {
        return new File(this.getConfDir(), "dmx-sign-up-ui");
    }

    private String getConfDir() {
        String systemProps = System.getProperty("felix.system.properties");
        if (systemProps != null) {
            if (systemProps.startsWith("file:") && systemProps.endsWith("config.properties")) {
                return systemProps.substring("file:".length(), systemProps.length() - "config.properties".length());
            }
            throw new RuntimeException("Unexpected felix.system.properties: \"" + systemProps + "\"");
        }
        return "";
    }
}

