/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.configuration;

import systems.dmx.core.Topic;

public class ModuleConfiguration {
    private final Topic topic;

    public ModuleConfiguration(Topic topic) {
        this.topic = topic;
    }

    public String getConfigurationUri() {
        return this.topic.getUri();
    }

    public String getConfigurationName() {
        return this.topic.getSimpleValue().toString();
    }

    public boolean isValid() {
        return this.topic != null;
    }

    public void reload() {
        this.topic.loadChildTopics();
    }

    private String getString(String key) {
        return this.topic.getChildTopics().getString(key);
    }

    private boolean getBoolean(String key) {
        return this.topic.getChildTopics().getBoolean(key);
    }

    public String getProjectTitle() {
        return this.getString("dmx.signup_ui.project_title");
    }

    public String getWebAppTitle() {
        return this.getString("dmx.signup_ui.webapp_title");
    }

    public String getLogoPath() {
        return this.getString("dmx.signup_ui.webapp_logo_path");
    }

    public String getCssPath() {
        return this.getString("dmx.signup_ui.custom_css_path");
    }

    public String getReadMoreUrl() {
        return this.getString("dmx.signup_ui.read_more_url");
    }

    public String getTosLabel() {
        return this.getString("dmx.signup_ui.tos_label");
    }

    public String getTosDetails() {
        return this.getString("dmx.signup_ui.tos_detail");
    }

    public String getPdLabel() {
        return this.getString("dmx.signup_ui.pd_label");
    }

    public String getPdDetails() {
        return this.getString("dmx.signup_ui.pd_detail");
    }

    public String getPagesFooter() {
        return this.getString("dmx.signup_ui.pages_footer");
    }

    public String getStartUrl() {
        return this.getString("dmx.signup_ui.start_page_url");
    }

    public String getHomeUrl() {
        return this.getString("dmx.signup_ui.home_page_url");
    }

    public String getLoadingAppHint() {
        return this.getString("dmx.signup_ui.loading_app_hint");
    }

    public String getLoggingOutHint() {
        return this.getString("dmx.signup_ui.logging_out_hint");
    }

    public String getImprintUrl() {
        return this.getString("dmx.signup_ui.imprint_url");
    }

    public String getPrivacyPolicyUrl() {
        return this.getString("dmx.signup_ui.privacy_policy_url");
    }

    public String getLanguage() {
        return this.getString("dmx.signup_ui.language");
    }

    public Topic getCustomWorkspaceAssignmentTopic() {
        return this.topic.getRelatedTopic("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }
}

