/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup_ui.configuration.Environment;
import systems.dmx.signup_ui.repository.ResourceBundleRepository;

@Singleton
public class LoadSignupMessagesUseCase {
    static final String RESOURCE_BUNDLE_NAME = "SignupMessages";
    private final Environment environment;
    private final ResourceBundleRepository repository;
    static final Logger logger = Logger.getLogger(LoadSignupMessagesUseCase.class.getName());

    @Inject
    public LoadSignupMessagesUseCase(Environment environment, ResourceBundleRepository repository) {
        this.environment = environment;
        this.repository = repository;
    }

    public ResourceBundle invoke(Locale locale) {
        ResourceBundle rb = this.repository.load(this.environment.getPluginConfDir(), RESOURCE_BUNDLE_NAME, locale);
        if (rb != null) {
            logger.info("Using messages from plugin conf dir  in " + locale.getLanguage());
            return rb;
        }
        rb = this.repository.load(RESOURCE_BUNDLE_NAME, locale);
        if (rb != null) {
            logger.info("Using built-in messages in " + locale.getLanguage());
            return rb;
        }
        logger.warning("Could not find Sign-up plugin properties - use default english resource bundle for labels");
        return this.repository.load(RESOURCE_BUNDLE_NAME, Locale.ENGLISH);
    }
}

