/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.configuration;

import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup_ui.configuration.Identifier;
import systems.dmx.signup_ui.configuration.datasource.ConfigurationDatasource;

@Singleton
public class Configuration {
    private ConfigurationDatasource datasource;

    @Inject
    Configuration(ConfigurationDatasource datasource) {
        this.datasource = datasource;
    }

    private String getString(Identifier identifier) {
        return this.datasource.getString(identifier.key, identifier.defaultValue);
    }

    public String getHostUrl() {
        return this.getString(Identifier.DMX_CONFIG_HOST_URL);
    }

    public String getProjectTitle() {
        return this.getString(Identifier.CONFIG_UI_PROJECT_TITLE);
    }

    public String getWebAppTitle() {
        return this.getString(Identifier.CONFIG_UI_WEBAPP_TITLE);
    }

    public String getLogoPath() {
        return this.getString(Identifier.CONFIG_UI_LOGO_PATH);
    }

    public String getCssPath() {
        return this.getString(Identifier.CONFIG_UI_CUSTOM_CSS_PATH);
    }

    public String getReadMoreUrl() {
        return this.getString(Identifier.CONFIG_UI_READ_MORE_URL);
    }

    public String getTosLabel() {
        return this.getString(Identifier.CONFIG_UI_TOS_LABEL);
    }

    public String getTosDetails() {
        return this.getString(Identifier.CONFIG_UI_TOS_DETAILS);
    }

    public String getPdLabel() {
        return this.getString(Identifier.CONFIG_UI_PD_LABEL);
    }

    public String getPdDetails() {
        return this.getString(Identifier.CONFIG_UI_PD_DETAILS);
    }

    public String getPagesFooter() {
        return this.getString(Identifier.CONFIG_UI_PAGES_FOOTER);
    }

    public String getStartUrl() {
        return this.getString(Identifier.CONFIG_UI_START_PAGE_URL);
    }

    public String getHomeUrl() {
        return this.getString(Identifier.CONFIG_UI_HOME_PAGE_URL);
    }

    public String getLoadingAppHint() {
        return this.getString(Identifier.CONFIG_UI_LOADING_APP_HINT);
    }

    public String getLoggingOutHint() {
        return this.getString(Identifier.CONFIG_UI_LOGGING_OUT_HINT);
    }

    public String getImprintUrl() {
        return this.getString(Identifier.CONFIG_UI_IMPRINT_URL);
    }

    public String getPrivacyPolicyUrl() {
        return this.getString(Identifier.CONFIG_UI_PRIVACY_POLICY_URL);
    }

    public String getLanguage() {
        return this.getString(Identifier.CONFIG_UI_LANGUAGE);
    }
}

