/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.email;

import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup.EmailTextProducer;
import systems.dmx.signup_ui.configuration.Configuration;
import systems.dmx.signup_ui.usecase.GetMessageUseCase;

@Singleton
public class SignUpUiEmailTextProducer
implements EmailTextProducer {
    private GetMessageUseCase getMessageUseCase;
    private String webAppTitle;
    private String hostUrl;

    @Inject
    public SignUpUiEmailTextProducer(Configuration configuration, GetMessageUseCase getMessageUseCase) {
        this.hostUrl = configuration.getHostUrl();
        this.webAppTitle = configuration.getWebAppTitle();
        this.getMessageUseCase = getMessageUseCase;
    }

    private String getString(String key) {
        return this.getMessageUseCase.invoke(key);
    }

    public boolean isHtml() {
        return true;
    }

    String getPasswordResetUrl(String key) {
        return this.hostUrl + "/sign-up-ui/password-reset/" + key;
    }

    private String getConfirmationLink(String key) {
        String href = this.hostUrl + "sign-up-ui/confirm/" + key;
        return "<a href=\"" + href + "\">" + this.getString("mail_confirmation_link_label") + "</a>";
    }

    public String getConfirmationActiveMailSubject() {
        return this.getString("mail_confirmation_subject") + " - " + this.webAppTitle;
    }

    public String getConfirmationActiveMailMessage(String username, String key) {
        String linkHref = this.getConfirmationLink(key);
        return this.getString("mail_hello") + " " + username + ",<br><br>" + this.getString("mail_confirmation_active_body") + "<br><br>" + linkHref + "<br><br>" + this.getString("mail_ciao");
    }

    public String getConfirmationProceedMailSubject() {
        return this.getString("mail_confirmation_subject") + " - " + this.webAppTitle;
    }

    public String getUserConfirmationProceedMailMessage(String username, String key) {
        String linkHref = this.getConfirmationLink(key);
        return this.getString("mail_hello") + " " + username + ",<br><br>" + this.getString("mail_confirmation_proceed_1") + "<br>" + linkHref + "<br><br>" + this.getString("mail_confirmation_proceed_2") + "<br><br>" + this.getString("mail_ciao");
    }

    public String getApiUsageRevokedMailSubject() {
        return "API Usage Revoked";
    }

    public String getApiUsageRevokedMailText(String username) {
        return "<br>Hi admin,<br><br>" + username + " just revoked his/her acceptance to your Terms of Service for API-Usage.<br><br>Just wanted to let you know.<br>Cheers!";
    }

    public String getAccountActiveEmailSubject() {
        return "Your account on " + this.webAppTitle + " is now active";
    }

    public String getAccountActiveEmailMessage(String username) {
        return this.getString("mail_hello") + " " + username + ",<br><br>your account on <a href=\"" + this.hostUrl + "\">" + this.webAppTitle + "</a> is now active.<br><br>" + this.getString("mail_ciao");
    }

    public String getApiUsageRequestedSubject() {
        return "API Usage Requested";
    }

    public String getApiUsageRequestedMessage(String username) {
        return "<br>Hi admin,<br><br>" + username + " accepted the Terms of Service for API Usage.<br><br>Just wanted to let you know.<br>Cheers!";
    }

    public String getPasswordResetMailSubject() {
        return this.getString("mail_pw_reset_title") + " " + this.webAppTitle;
    }

    public String getPasswordResetMailMessage(String addressee, String key) {
        String href = this.getPasswordResetUrl(key);
        return this.getString("mail_hello") + "!<br><br>" + this.getString("mail_pw_reset_body") + "<br><a href=\"" + href + "\">" + href + "</a><br><br>" + this.getString("mail_cheers") + "<br>" + this.getString("mail_signature");
    }

    public String getAccountCreationSystemEmailSubject() {
        return "Account registration on " + this.webAppTitle;
    }

    public String getAccountCreationSystemEmailMessage(String username, String mailbox) {
        return "<br>A user has registered.<br><br>Username: " + username + "<br>Email: " + mailbox;
    }
}

