/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup_ui.repository.ResourceBundleRepository;

@Singleton
public class GetTranslationsUseCase {
    private ResourceBundleRepository repository;

    @Inject
    public GetTranslationsUseCase(ResourceBundleRepository repository) {
        this.repository = repository;
    }

    public Map<String, String> invoke(String languageTag) {
        ResourceBundle rb = this.repository.getResourceBundle(Locale.forLanguageTag(languageTag));
        return rb.keySet().stream().collect(Collectors.toMap(Function.identity(), rb::getString));
    }
}

