/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import systems.dmx.signup.SignupService;
import systems.dmx.signup_ui.web.ResponseBuilder;

@Singleton
public class InitiateRedirectPasswordResetUseCase {
    static final Logger logger = Logger.getLogger(InitiateRedirectPasswordResetUseCase.class.getName());
    private final SignupService signupService;
    private final ResponseBuilder responseBuilder;

    @Inject
    InitiateRedirectPasswordResetUseCase(SignupService signupService, ResponseBuilder responseBuilder) {
        this.signupService = signupService;
        this.responseBuilder = responseBuilder;
    }

    public Response invoke(String email, String redirectUrl) {
        logger.info("Password reset requested for user with Email: \"" + email + "\" wishing to redirect to: \"" + redirectUrl + "\"");
        switch (this.signupService.requestInitiateRedirectPasswordReset(email, redirectUrl)) {
            case SUCCESS: {
                return this.responseBuilder.ok();
            }
        }
        return this.responseBuilder.serverError();
    }
}

