/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.view;

import com.sun.jersey.api.view.Viewable;
import javax.inject.Inject;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup_ui.configuration.Configuration;
import systems.dmx.signup_ui.usecase.FireEventSignupResourceRequestedUseCase;
import systems.dmx.signup_ui.usecase.GetMessageUseCase;
import systems.dmx.signup_ui.view.AbstractContextProvider;
import systems.dmx.signup_ui.view.ViewRenderer;

public class ViewRendererImpl
implements ViewRenderer {
    static final String VIEW_DATA_MESSAGE = "message";
    private final Configuration configuration;
    private final AccessControlService accessControlService;
    private final SignupService signupService;
    private final AbstractContextProvider contextProvider;
    private final GetMessageUseCase getMessageUseCase;
    private final FireEventSignupResourceRequestedUseCase fireEventSignupResourceRequestedUseCase;

    @Inject
    public ViewRendererImpl(Configuration configuration, AccessControlService accessControlService, SignupService signupService, AbstractContextProvider contextProvider, GetMessageUseCase getMessageUseCase, FireEventSignupResourceRequestedUseCase fireEventSignupResourceRequestedUseCase) {
        this.configuration = configuration;
        this.accessControlService = accessControlService;
        this.signupService = signupService;
        this.contextProvider = contextProvider;
        this.getMessageUseCase = getMessageUseCase;
        this.fireEventSignupResourceRequestedUseCase = fireEventSignupResourceRequestedUseCase;
    }

    private String getString(String key) {
        return this.getMessageUseCase.invoke(key);
    }

    private void viewData(String name, Object value) {
        this.contextProvider.getAbstractContext().setVariable(name, value);
    }

    private Viewable view(String templateName) {
        return new Viewable(templateName, (Object)this.contextProvider.getAbstractContext());
    }

    @Override
    public void prepare(String lastAuthorizationMethod, String templateName) {
        this.viewData("username_policy", SignUpConfigOptions.CONFIG_USERNAME_POLICY.name().toLowerCase());
        this.viewData("authorization_methods", this.signupService.getAuthorizationMethods());
        this.viewData("last_authorization_method", lastAuthorizationMethod);
        this.viewData("is_account_creation_password_editable", this.signupService.isAccountCreationPasswordEditable());
        this.viewData("self_registration_enabled", this.signupService.isSelfRegistrationEnabled());
        this.viewData("title", this.configuration.getWebAppTitle());
        this.viewData("logo_path", this.configuration.getLogoPath());
        this.viewData("css_path", this.configuration.getCssPath());
        this.viewData("project_name", this.configuration.getProjectTitle());
        this.viewData("read_more_url", this.configuration.getReadMoreUrl());
        this.viewData("tos_label", this.configuration.getTosLabel());
        this.viewData("tos_details", this.configuration.getTosDetails());
        this.viewData("pd_label", this.configuration.getPdLabel());
        this.viewData("pd_details", this.configuration.getPdDetails());
        this.viewData("footer", this.configuration.getPagesFooter());
        this.viewData("custom_workspace_enabled", this.signupService.getConfiguration().getApiEnabled());
        this.viewData("custom_workspace_description", this.signupService.getConfiguration().getApiDescription());
        this.viewData("custom_workspace_details", this.signupService.getConfiguration().getApiDetails());
        this.viewData("custom_workspace_uri", this.signupService.getConfiguration().getApiWorkspaceUri());
        this.viewData("start_url", this.configuration.getStartUrl());
        this.viewData("visit_start_url", this.getString("visit_start_url"));
        this.viewData("home_url", this.configuration.getHomeUrl());
        this.viewData("visit_home_url", this.getString("visit_home_url"));
        this.viewData("loading_app_hint", this.configuration.getLoadingAppHint());
        this.viewData("logging_out_hint", this.configuration.getLoggingOutHint());
        this.viewData("password_length_hint", this.getString("password_length_hint"));
        this.viewData("password_match_hint", this.getString("password_match_hint"));
        this.viewData("check_terms_hint", this.getString("check_terms_hint"));
        this.viewData("username_invalid_hint", this.getString("username_invalid_hint"));
        this.viewData("username_taken_hint", this.getString("username_taken_hint"));
        this.viewData("email_invalid_hint", this.getString("email_invalid_hint"));
        this.viewData("email_taken_hint", this.getString("email_taken_hint"));
        this.viewData("not_authorized_message", this.getString("not_authorized_message"));
        this.viewData("signup_title", this.getString("signup_title"));
        this.viewData("create_account", this.getString("create_account"));
        this.viewData("login_title", this.getString("login_title"));
        this.viewData("log_in_small", this.getString("log_in_small"));
        this.viewData("login", this.getString("login"));
        this.viewData("or_label", this.getString("or_label"));
        this.viewData("logout", this.getString("logout"));
        this.viewData("logged_in_as", this.getString("logged_in_as"));
        this.viewData("label_username", this.getString("label_username"));
        this.viewData("label_displayname", this.getString("label_displayname"));
        this.viewData("label_email", this.getString("label_email"));
        this.viewData("label_password", this.getString("label_password"));
        this.viewData("label_password_repeat", this.getString("label_password_repeat"));
        this.viewData("read_more", this.getString("read_more"));
        this.viewData("label_forgot_password", this.getString("forgot_password"));
        this.viewData("label_reset_password", this.getString("reset_password"));
        this.viewData("label_reset_password_submit", this.getString("reset_password_submit"));
        this.viewData("info_reset_password", this.getString("reset_password_hint"));
        this.viewData("password_reset_ok_message", this.getString("password_reset_success_1"));
        this.viewData("your_account_title", this.getString("your_account_title"));
        this.viewData("your_account_heading", this.getString("your_account_heading"));
        this.viewData("your_account_username_label", this.getString("your_account_username_label"));
        this.viewData("your_account_email_label", this.getString("your_account_email_label"));
        this.viewData("api_option_title", this.getString("api_option_title"));
        this.viewData("api_option_descr", this.getString("api_option_descr"));
        this.viewData("api_option_revoke", this.getString("api_option_revoke"));
        this.viewData("api_workspace_member", this.signupService.isApiWorkspaceMember());
        this.viewData("api_email_contact", this.signupService.getSystemEmailContactOrEmpty());
        this.viewData("api_contact_revoke", this.getString("api_contact_revoke"));
        this.viewData("imprint", this.getString("imprint"));
        this.viewData("imprint_url", this.configuration.getImprintUrl());
        this.viewData("privacy_policy", this.getString("privacy_policy"));
        this.viewData("privacy_policy_url", this.configuration.getPrivacyPolicyUrl());
        this.viewData("created_page_title", this.getString("page_account_created_title"));
        this.viewData("created_page_body_1", this.getString("page_account_created_body_1"));
        this.viewData("created_page_body_2", this.getString("page_account_created_body_2"));
        this.viewData("created_page_body_3", this.getString("page_account_created_body_3"));
        this.viewData("created_page_body_4", this.getString("page_account_created_body_4"));
        this.viewData("requested_page_title", this.getString("page_account_requested_title"));
        this.viewData("requested_page_1", this.getString("page_account_requested_1"));
        this.viewData("requested_page_2", this.getString("page_account_requested_2"));
        this.viewData("requested_page_3", this.getString("page_account_requested_3"));
        this.viewData("email_confirmation_active", SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION);
        this.viewData("skip_confirmation_mail_label", this.getString("admin_skip_email_confirmation_mail"));
        this.viewData("can_create_new_account", this.signupService.hasAccountCreationPrivilege());
        String username = this.accessControlService.getUsername();
        this.viewData("authenticated", username != null);
        this.viewData("username", username);
        this.viewData("template", templateName);
        this.viewData("hostUrl", SignUpConfigOptions.DMX_HOST_URL);
    }

    @Override
    public void prepareSignupPage(String templateName, String lastAuthorizationMethod) {
        this.fireEventSignupResourceRequestedUseCase.invoke(templateName);
        this.prepare(lastAuthorizationMethod, templateName);
    }

    @Override
    public Viewable getFailureView(ViewRenderer.Status status, String lastAuthorizationMethod) {
        if (status == ViewRenderer.Status.CREATED) {
            this.viewData("status_label", this.getString("status_label_created"));
        } else {
            this.viewData("status_label", this.getString("status_label_updated"));
        }
        this.viewData("account_failure_message", this.getString("account_failure_message"));
        this.viewData("please_try_1", this.getString("please_try_1"));
        this.viewData("please_try_2", this.getString("please_try_2"));
        this.viewData("please_try_3", this.getString("please_try_3"));
        this.prepareSignupPage("failure", lastAuthorizationMethod);
        return this.view("failure");
    }

    @Override
    public Viewable invalidToken() {
        this.viewData(VIEW_DATA_MESSAGE, this.getString("link_invalid"));
        return this.getFailureView(ViewRenderer.Status.UPDATED, null);
    }

    @Override
    public Viewable linkExpired() {
        this.viewData(VIEW_DATA_MESSAGE, this.getString("reset_link_expired"));
        return this.getFailureView(ViewRenderer.Status.UPDATED, null);
    }

    @Override
    public Viewable resetLinkError() {
        this.viewData(VIEW_DATA_MESSAGE, this.getString("reset_link_error"));
        return this.getFailureView(ViewRenderer.Status.UPDATED, null);
    }

    @Override
    public Viewable passwordResetSuccess(String lastAuthorizationMethod, String token, String email, String username, String displayName, String redirectUrl) {
        this.viewData("token", token);
        this.viewData("mailbox", email);
        this.viewData("requested_username", username);
        this.viewData("requested_display_name", displayName);
        this.viewData("password_requested_title", this.getString("password_requested_title"));
        this.viewData("password_requested_button", this.getString("password_requested_button"));
        if (redirectUrl != null) {
            this.viewData("redirect_url", redirectUrl);
        }
        this.prepareSignupPage("password-reset", lastAuthorizationMethod);
        return this.view("password-reset");
    }

    @Override
    public Viewable logout(String lastAuthorizationMethod) {
        this.prepareSignupPage("logout", lastAuthorizationMethod);
        return this.view("logout");
    }

    @Override
    public Viewable login(String lastAuthorizationMethod) {
        this.prepareSignupPage("login", lastAuthorizationMethod);
        return this.view("login");
    }
}

