/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui;

import com.sun.jersey.api.view.Viewable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.CookieParam;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.osgi.framework.Bundle;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.signup.EmailTextProducer;
import systems.dmx.signup.PasswordResetTokenCheckRequestResult;
import systems.dmx.signup.ProcessSignUpRequestResult;
import systems.dmx.signup.SignUpRequestResult;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup_ui.SignupUiService;
import systems.dmx.signup_ui.configuration.Configuration;
import systems.dmx.signup_ui.di.DaggerSignupUiComponent;
import systems.dmx.signup_ui.di.SignupUiComponent;
import systems.dmx.signup_ui.model.TranslationTable;
import systems.dmx.signup_ui.usecase.FireEventSignupResourceRequestedUseCase;
import systems.dmx.signup_ui.usecase.GetMessageUseCase;
import systems.dmx.signup_ui.usecase.GetTranslationsUseCase;
import systems.dmx.signup_ui.usecase.InitiatePasswordResetWithNameUseCase;
import systems.dmx.signup_ui.usecase.InitiateRedirectPasswordResetUseCase;
import systems.dmx.signup_ui.view.ViewRenderer;
import systems.dmx.signup_ui.web.ResponseBuilder;
import systems.dmx.thymeleaf.ThymeleafPlugin;

@Path(value="/sign-up-ui")
public class SignupUiPlugin
extends ThymeleafPlugin
implements SignupUiService {
    static final Logger logger = Logger.getLogger(SignupUiPlugin.class.getName());
    @Inject
    AccessControlService accessControlService;
    @Inject
    SignupService signupService;
    Configuration configuration;
    ViewRenderer viewRenderer;
    ResponseBuilder responseBuilder;
    GetMessageUseCase getMessageUseCase;
    GetTranslationsUseCase getTranslationsUseCase;
    FireEventSignupResourceRequestedUseCase fireEventSignupResourceRequestedUseCase;
    InitiateRedirectPasswordResetUseCase initiateRedirectPasswordResetUseCase;
    InitiatePasswordResetWithNameUseCase initiatePasswordResetWithNameUseCase;

    public void init() {
        this.initTemplateEngine();
        SignupUiComponent component = DaggerSignupUiComponent.builder().coreService(this.dmx).signupService(this.signupService).accessControlService(this.accessControlService).abstractContextProvider(() -> ((SignupUiPlugin)this).context()).build();
        this.configuration = component.configuration();
        this.responseBuilder = component.responseBuilder();
        this.viewRenderer = component.viewRenderer();
        this.getMessageUseCase = component.getMessageUseCase();
        this.getTranslationsUseCase = component.getTranslationUseCase();
        this.fireEventSignupResourceRequestedUseCase = component.fireEventSignupResourceRequestedUseCase();
        this.initiateRedirectPasswordResetUseCase = component.initiateRedirectPasswordResetUseCase();
        this.initiatePasswordResetWithNameUseCase = component.initiatePasswordResetWithNameUseCase();
        this.signupService.setEmailTextProducer((EmailTextProducer)component.signUpUiEmailTextProducer());
    }

    private String getString(String key) {
        return this.getMessageUseCase.invoke(key);
    }

    @GET
    @Path(value="/translation/{locale}")
    @Produces(value={"application/json"})
    public TranslationTable getTranslationTable(@PathParam(value="locale") String language) {
        return new TranslationTable(this.getTranslationsUseCase.invoke(language));
    }

    @GET
    @Path(value="/password-token/{email}/{redirectUrl}")
    @Produces(value={"application/json"})
    public Response initiateRedirectPasswordReset(@PathParam(value="email") String email, @PathParam(value="redirectUrl") String redirectUrl) {
        return this.initiateRedirectPasswordResetUseCase.invoke(email, redirectUrl);
    }

    @Override
    @GET
    @Path(value="/password-token/{email}")
    @Produces(value={"text/html"})
    public Response initiatePasswordReset(@PathParam(value="email") String email) throws URISyntaxException {
        logger.info("Password reset requested for user with Email: \"" + email + "\"");
        return this.initiatePasswordResetWithName(email, null);
    }

    @Override
    @GET
    @Path(value="/password-token/{emailAddress}/{name}")
    @Produces(value={"text/html"})
    public Response initiatePasswordResetWithName(@PathParam(value="emailAddress") String emailAddress, @PathParam(value="name") String name) throws URISyntaxException {
        return this.initiatePasswordResetWithNameUseCase.invoke(emailAddress, name);
    }

    @GET
    @Path(value="/password-reset/{token}")
    @Produces(value={"application/xhtml+xml"})
    public Viewable handlePasswordResetRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token) {
        PasswordResetTokenCheckRequestResult result = this.signupService.requestPasswordResetTokenCheck(token);
        switch (result.code) {
            case INVALID_TOKEN: {
                return this.viewRenderer.invalidToken();
            }
            case SUCCESS: {
                return this.viewRenderer.passwordResetSuccess(lastAuthorizationMethod, token, result.email, result.username, result.displayName, result.redirectUrl);
            }
            case LINK_EXPIRED: {
                return this.viewRenderer.linkExpired();
            }
        }
        return this.viewRenderer.resetLinkError();
    }

    @GET
    @Path(value="/password-reset/{token}/{password}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processPasswordUpdateRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token, @PathParam(value="password") String password) {
        logger.info("Processing Password Update Request Token... ");
        switch (this.signupService.requestPasswordChange(token, password)) {
            case SUCCESS: {
                this.viewData("message", this.getString("reset_password_ok"));
                this.viewRenderer.prepareSignupPage("password-ok", lastAuthorizationMethod);
                return this.view("password-ok");
            }
        }
        this.viewData("message", this.getString("reset_password_error"));
        return this.getFailureView("updated");
    }

    @GET
    @Path(value="/handle/{username}/{emailAddress}/{displayName}/{pass-one}/{skipConfirmation}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="emailAddress") String emailAddress, @PathParam(value="displayName") String displayName, @PathParam(value="pass-one") String password, @PathParam(value="skipConfirmation") boolean skipConfirmation) {
        SignUpRequestResult result = this.signupService.requestSignUp(username, emailAddress, displayName, password, skipConfirmation);
        try {
            switch (result.code) {
                case SUCCESS_ACCOUNT_PENDING: {
                    logger.info("Account pending");
                    throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up-ui/pending")).build());
                }
                case SUCCESS_ACCOUNT_CREATED: {
                    logger.info("Account created");
                    throw new WebApplicationException(this.responseBuilder.temporaryRedirect(UriBuilder.fromPath((String)"/sign-up-ui").segment(new String[]{result.username}).segment(new String[]{"ok"}).build(new Object[0])));
                }
                case SUCCESS_EMAIL_CONFIRMATION_NEEDED: {
                    throw new WebApplicationException(this.responseBuilder.temporaryRedirect("/sign-up-ui/token-info"));
                }
                case ACCOUNT_CREATION_DENIED: {
                    logger.warning("Account creation denied");
                }
                case ERROR_INVALID_EMAIL: {
                    logger.warning("Error invalid email");
                }
                case ADMIN_PRIVILEGE_MISSING: {
                    logger.warning("Admin privilege missing");
                }
                case UNEXPECTED_ERROR: {
                    logger.warning("Unexpected error");
                }
            }
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, "Could not build response URI while handling sign-up request", ex);
        }
        return this.getFailureView("created");
    }

    @GET
    @Path(value="/handle/{username}/{emailAddress}/{displayName}/{pass-one}")
    @Produces(value={"text/html"})
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="emailAddress") String emailAddress, @PathParam(value="displayName") String displayName, @PathParam(value="pass-one") String password) {
        return this.handleSignupRequest(username, emailAddress, displayName, password, false);
    }

    @GET
    @Path(value="/confirm/{token}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processSignupRequest(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="token") String token) {
        ProcessSignUpRequestResult result = this.signupService.requestProcessSignUp(token);
        switch (result.code) {
            case SUCCESS: {
                this.viewData("message", this.getString("account_created"));
                return this.getAccountCreationOKView(lastAuthorizationMethod, result.username);
            }
            case SUCCESS_ACCOUNT_PENDING: {
                this.viewData("message", this.getString("account_created"));
                return this.getAccountCreationPendingView(lastAuthorizationMethod);
            }
            case INVALID_TOKEN: {
                this.viewData("username", null);
                this.viewData("message", this.getString("link_invalid"));
                return this.viewRenderer.getFailureView(ViewRenderer.Status.CREATED, lastAuthorizationMethod);
            }
            case LINK_EXPIRED: {
                this.viewData("username", null);
                this.viewData("message", this.getString("link_expired"));
                return this.viewRenderer.getFailureView(ViewRenderer.Status.CREATED, lastAuthorizationMethod);
            }
        }
        this.viewData("message", this.getString("internal_error"));
        return this.viewRenderer.getFailureView(ViewRenderer.Status.CREATED, lastAuthorizationMethod);
    }

    @GET
    @Path(value="/check/username/{username}")
    @Produces(value={"application/json"})
    public Boolean getUsernameAvailability(@PathParam(value="username") String username) {
        return !this.signupService.isUsernameTaken(username);
    }

    @GET
    @Path(value="/check/emailaddress/{emailAddress}")
    @Produces(value={"application/json"})
    public Boolean getEmailAddressAvailability(@PathParam(value="emailAddress") String emailAddress) {
        return !this.signupService.isEmailAddressTaken(emailAddress);
    }

    @GET
    @Path(value="/check/passwordcomplexity/{password}")
    @Produces(value={"application/json"})
    public Boolean isPasswordComplexEnough(@PathParam(value="password") String password) {
        return this.signupService.isPasswordComplexEnough(password);
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Viewable getSignupFormView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        String page = null;
        switch (SignUpConfigOptions.CONFIG_ACCOUNT_CREATION) {
            case DISABLED: {
                page = this.signupService.isLoggedIn() != false ? "logout" : "login";
                break;
            }
            case ADMIN: {
                page = this.signupService.isLoggedIn().booleanValue() ? (this.signupService.hasAccountCreationPrivilege() ? "sign-up" : "logout") : "login";
                break;
            }
            case PUBLIC: {
                page = this.signupService.isLoggedIn() == false || this.signupService.hasAccountCreationPrivilege() ? "sign-up" : "logout";
            }
        }
        this.viewRenderer.prepareSignupPage(page, lastAuthorizationMethod);
        return this.view(page);
    }

    @GET
    @Path(value="/login")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getLoginView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        if (this.accessControlService.getUsername() != null) {
            return this.viewRenderer.logout(lastAuthorizationMethod);
        }
        return this.viewRenderer.login(lastAuthorizationMethod);
    }

    @GET
    @Path(value="/request-password")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getPasswordResetView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.viewRenderer.prepareSignupPage("request-password", lastAuthorizationMethod);
        return this.view("request-password");
    }

    @GET
    @Path(value="/{username}/ok")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationOKView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod, @PathParam(value="username") String username) {
        this.viewRenderer.prepareSignupPage("ok", lastAuthorizationMethod);
        this.viewData("requested_username", username);
        return this.view("ok");
    }

    @GET
    @Path(value="/pending")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationPendingView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.viewRenderer.prepareSignupPage("pending", lastAuthorizationMethod);
        return this.view("pending");
    }

    @GET
    @Path(value="/error")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getFailureView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        return this.viewRenderer.getFailureView(null, lastAuthorizationMethod);
    }

    @GET
    @Path(value="/token-info")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getConfirmationInfoView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.viewRenderer.prepareSignupPage("account-confirmation", lastAuthorizationMethod);
        return this.view("account-confirmation");
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountDetailsView(@CookieParam(value="last_authorization_method") String lastAuthorizationMethod) {
        this.viewRenderer.prepareSignupPage("account-edit", lastAuthorizationMethod);
        this.prepareAccountEditPage();
        return this.view("account-edit");
    }

    private void prepareAccountEditPage() {
        String username = this.accessControlService.getUsername();
        if (username != null) {
            String eMailAddressValue = "None";
            try {
                eMailAddressValue = this.dmx.getPrivilegedAccess().getEmailAddress(username);
            }
            catch (Exception e) {
                logger.warning("Username has no related email address");
            }
            this.viewData("logged_in", true);
            this.viewData("username", username);
            this.viewData("display_name", this.signupService.getDisplayName(username));
            this.viewData("email", eMailAddressValue);
            this.viewData("link", "");
        } else {
            this.viewData("logged_in", false);
            this.viewData("username", "Not logged in");
            this.viewData("email", "Not logged in");
            this.viewData("link", "/sign-up-ui/login");
        }
    }

    @Override
    public void reinitTemplateEngine() {
        super.initTemplateEngine();
    }

    @Override
    public void addTemplateResolverBundle(Bundle bundle) {
        super.addTemplateResourceBundle(bundle);
    }

    @Override
    public void removeTemplateResolverBundle(Bundle bundle) {
        super.removeTemplateResourceBundle(bundle);
    }
}

