/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup_ui.configuration.Configuration;
import systems.dmx.signup_ui.repository.ResourceBundleRepository;

@Singleton
public class GetMessageUseCase {
    private ResourceBundle localizedResourceBundle;
    private ResourceBundle defaultResourceBundle;

    @Inject
    public GetMessageUseCase(Configuration configuration, ResourceBundleRepository repository) {
        this.localizedResourceBundle = repository.getResourceBundle(Locale.forLanguageTag(configuration.getLanguage()));
        this.defaultResourceBundle = repository.getDefaultResourceBundle();
    }

    public String invoke(String key) {
        try {
            return this.localizedResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return this.defaultResourceBundle.getString(key);
        }
    }

    public String invoke(String key, Object ... args) {
        return String.format(this.invoke(key), args);
    }
}

