
    var EMPTY_STRING = ""
    var OK_STRING = "OK"
    var CREATE_DISABLED_BACKGROUND = "background-color: #a9a9a9;"
    var inputInvalidated = false

    // Sign-up Configuration Object Initialized via Thymeleaf
    var signupConfig = {
        "usernamePolicy"    : "unconfined",
        "lastAuthorizationMethod": "Basic",
        "authorizationMethods": ["Basic"],
        "appLoadingMessage" : "Loading Webclient",
        "appLoggingOutHint" : "Logging out...",
        "appStartPageURL"   : "/",
        "appHomePageURL"    : "/",
        "passwordLength"    : "Your password must be at least 8 characters long.",
        "passwordMatch"     : "Your passwords do not match.",
        "checkTerms"        : "First, please check our terms and conditions.",
        "usernameInvalid"   : "This username would be invalid.",
        "usernameTaken"     : "This username is already taken.",
        "emailInvalid"      : "This E-Mail Address would be invalid.",
        "emailTaken"        : "This E-Mail address is already registered.",
        "passwordNotComplexEnough": "The given password is not complex enough.",
        "notAuthorized"     : "The given password and username do not match for authorization method {0}. You're not authorized. Sorry.",
        "isAccountCreationPasswordEditable": true
    }


    // --- Plain DMX login method used by "/sign-up-ui/login" page. --- //

    function doLogout() {
        xhr = new XMLHttpRequest()
        xhr.onload = function(e) {
            if (xhr.response === "") {
                renderFriendlyMessage(signupConfig.appLoggingOutHint)
                window.document.location.assign(signupConfig.appHomePageURL)
            } else {
                renderWarning(xhr.response)
            }
        }
        xhr.open("POST", "/access-control/logout", false)
        xhr.send()
    }

    function login() {
        var username = document.getElementById("username")?.value || "username placeholder"
        var mailbox = document.getElementById("email")?.value || "email@placeholder"
        var password = document.getElementById("password").value

        doLogin(username, mailbox, password)
    }

    function doLogin(username, mailbox, password, success) {
        var id = signupConfig["usernamePolicy"] == 'username_is_email' ? mailbox.toLowerCase() : username
        var secret = password

        checkAuthorization(id, secret)

        function checkAuthorization(id, secret) {

            var authorization = authorization()
            if (authorization === undefined) return null

            xhr = new XMLHttpRequest()
            xhr.onload = function(e) {
                  if (xhr.response === "") { // login success
                      if (typeof success !== "undefined") {
                        console.log("Login successful triggering callback", success)
                        success()
                      } else {
                        console.log("Login successful standard redirect")
                        renderFriendlyMessage(signupConfig.appLoadingMessage)
                        redirectToStartPageURL()
                      }
                  } else {
                      console.log("Login unsuccessful", xhr.response)
                      renderWarning(signupConfig.notAuthorized.replace("{0}", getAuthMethod()))
                  }
            }
            xhr.open("POST", "/access-control/login", false)
            xhr.setRequestHeader("Authorization", authorization)
            xhr.send()

            function getAuthMethod() {
                var selectElement = document.getElementById("auth_method");
                return selectElement.options[selectElement.selectedIndex].value
            }

            /** Returns value for the "Authorization" header. */
            function authorization() {
                try {
                    var authMethod = getAuthMethod()

                    document.cookie = "last_authorization_method=" + authMethod;

                    // See https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/btoa
                    return authMethod + " " + window.btoa(id + ":" + secret) // IE >= 10 compatible
                } catch (error) {
                    console.error("Error encoding Auth-Header", error)
                }
            }
        }

    }

    // --- Plain JavaScript form validation --- //
    function createAccount() {
        // TODO: Account and username should only be taken from document when configured as such

        function getUsername() {
            return document.getElementById("username")?.value || "username placeholder"
        }

        function getEmailAddress() {
            // email is always present
            return document.getElementById("email").value
        }

        function getDisplayName() {
            return document.getElementById("displayname")?.value || "displayname placeholder"
        }

        function getPassword() {
            return signupConfig["isAccountCreationPasswordEditable"]
                ? document.getElementById("pass-one").value : "password-placeholder"
        }

        function doCreateRequest() {
            var username = encodeURIComponent(getUsername())
            // when sign-up creates ldap accounts, make sure, these are always in lower-case
            var emailAddress = encodeURIComponent(getEmailAddress().toLowerCase())
            var displayName = encodeURIComponent(getDisplayName())
            var passwordVal = encodeURIComponent(getPassword())

            // sends a GET to handle the account creation request
            var url = `//${window.location.host}/sign-up-ui/handle/${username}/${emailAddress}/${displayName}/${passwordVal}`
            window.location.assign(url)
        }

        // any of these should prevent submission of form
        if (!isValidEmailAddress()) return false
        doCreateRequest()
    }

    function isValidEmailAddress() {
        var mailboxField = document.getElementById("email") // fixme: maybe its better to acces the form element
        if (mailboxField.value.indexOf("@") === -1 || mailboxField.value.indexOf(".") === -1) {
            renderWarning(signupConfig.emailInvalid)
            disableSignupForm()
            return null
        }
        enableSignupForm()
        renderWarning(EMPTY_STRING)
        return OK_STRING
    }

    function isValidUsername() {
        var usernameInput = document.getElementById("username") // fixme: maybe its better to acces the form element
        var userInput = usernameInput.value
        if (userInput.length <= 1) {
            renderWarning(signupConfig.usernameInvalid)
            disableSignupForm()
            return false
        }
        enableSignupForm()
        return true
    }

    function checkAccountAvailability(handler) {
        var elementToTakeUserInputFrom = signupConfig["usernamePolicy"] == 'username_is_email' ? "email" : "username"

        var userInput = document.getElementById(elementToTakeUserInputFrom).value

        xhr = new XMLHttpRequest()
        if (userInput) {
            xhr.onload = function(e) {
                var response = JSON.parse(xhr.response)
                if (!response.value) {
                    renderWarning(signupConfig.usernameTaken)
                    disableSignupForm()
                    inputInvalidated = true
                    if (handler) handler(false)
                } else {
                    enableSignupForm()
                    renderWarning(EMPTY_STRING)
                    if (handler) handler(true)
                }
            }
            xhr.open("GET", `/sign-up-ui/check/username/${encodeURIComponent(userInput)}`, true)
            xhr.send()   
        }
    }
    
    function checkEmailAddressAvailability(handler) {
        var emailAddress = document.getElementById("email")?.value
        if (emailAddress) {
            xhr = new XMLHttpRequest()
            xhr.onload = function(e) {
                var response = JSON.parse(xhr.response)
                if (!response.value) {
                    renderWarning(signupConfig.emailTaken)
                    disableSignupForm()
                    inputInvalidated = true
                    if (handler) handler(false)
                } else {
                    enableSignupForm()
                    renderWarning(EMPTY_STRING)
                    if (handler) handler(true)
                }
            }
            xhr.open("GET", `/sign-up-ui/check/emailaddress/${encodeURIComponent(emailAddress)}`, true)
            xhr.send()   
        }
    }

    function checkPasswordComplexity(handler) {
        var password = document.getElementById("pass-one")?.value
        if (password) {
            xhr = new XMLHttpRequest()
            xhr.onload = function(e) {
                var response = JSON.parse(xhr.response)
                if (!response.value) {
                    renderWarning(signupConfig.passwordNotComplexEnough)
                    disableSignupForm()
                    inputInvalidated = true
                    if (handler) handler(false)
                } else {
                    enableSignupForm()
                    renderWarning(EMPTY_STRING)
                    if (handler) handler(true)
                }
            }
            xhr.open("GET", `/sign-up-ui/check/passwordcomplexity/${encodeURIComponent(password)}`, true)
            xhr.send()
        }
    }

    function checkMailbox() {
        var mailboxField = document.getElementById("mailbox") // fixme: maybe its better to acces the form element
        if (mailboxField.value.indexOf("@") === -1 || mailboxField.value.indexOf(".") === -1) {
            renderWarning(signupConfig.emailInvalid)
            disableSignupForm()
            return null
        }
        enableSignupForm()
        renderWarning(EMPTY_STRING)
        return OK_STRING
    }

    function comparePasswords() {
        var passwordFieldTwo = document.getElementById("pass-one") // fixme: maybe its better to acces the form element
        var passwordFieldOne = document.getElementById("pass-two") // fixme: maybe its better to acces the form element
        if (passwordFieldOne.value !== passwordFieldTwo.value) {
            renderWarning(signupConfig.passwordMatch)
            disableSignupForm()
            return null
        }
        enableSignupForm()
        renderWarning(EMPTY_STRING)
        checkPasswordComplexity()
        return OK_STRING
    }

    function checkAgreements() {
        var tosCheck = document.getElementById("toscheck").checked
        var privateOk = document.getElementById("privateinfo").checked
        //
        if (tosCheck && privateOk) {
            renderWarning(EMPTY_STRING)
            enableSignupForm()
            return OK_STRING
        }
        renderWarning(signupConfig.checkTerms)
        disableSignupForm()
        return null
    }

    function resetPassword() {
        // var name = document.getElementById("name").value.trim()
        var emailAddress = document.getElementById("mailbox").value.trim()
        xhr = new XMLHttpRequest()
        xhr.onload = function(e) {
            console.log("Loaded Password Reset Response", e)
        }
        xhr.open("GET", "/sign-up-ui/password-token/" + emailAddress, true) // Asynchronous request
        xhr.send()
        redirectToTokenInfoPage()
    }

    function updatePassword() {
            function getUsername() {
                return document.getElementById("username")?.value || "username placeholder"
            }

            function getMailbox() {
                return document.getElementById("email")?.value || "email@placeholder"
            }

        comparePasswords()
        var token = document.getElementById("token-info").value
        var username = getUsername()
        var mailbox = getMailbox()
        var pwInput = document.getElementById("pass-one").value
        var secret = encodeURIComponent(pwInput)
        // a) Form-based way
        // window.document.location.replace("/sign-up-ui/password-reset/" + token + "/" + secret)
        // b) Custom ajax-way 
        xhr = new XMLHttpRequest()
        xhr.onload = function(e) {
            console.log("Updated Password for ", username, "start auto-login sequence in 1sec")
            setTimeout(function (e) {
              doLogin(username, mailbox, pwInput, function(e) {
                console.log("Autologin successful", signupConfig.redirectUrl, signupConfig.appStartPageURL)
                // if (!signupConfig.redirectUrl) {     // commented by jri 2022/07/26
                renderFriendlyMessage(signupConfig.appLoadingMessage)
                redirectToStartPageURL()
                // } else {
                //   console.log("Redirect URL", signupConfig.redirectUrl)
                // }
              })
            }, 1000)
        }
        xhr.open("GET", `/sign-up-ui/password-reset/${token}/${secret}`, true)
        xhr.setRequestHeader('Content-Type', 'application/json');
        xhr.send()
    }

    function voidFunction() {
        // a custom void(); return false; }
    }

    function showLabsPrivateText() {
        var textArea = document.getElementById('private-details')
            textArea.setAttribute("style", "display: block;")
    }

    function showLabsTermsText() {
        var textArea = document.getElementById('tos-details')
            textArea.setAttribute("style", "display: block;")
    }

    function renderWarning(message) {
        var textNode = document.createTextNode(message)
        var messageElement = document.getElementById('message')
        while(messageElement.hasChildNodes()) {
            // looping over lastChild thx to http://stackoverflow.com/questions/5402525/remove-all-child-nodes
            messageElement.removeChild(messageElement.lastChild);
        }
        messageElement.appendChild(textNode)
    }

    function renderFriendlyMessage(message) {
        var textNode = document.createTextNode(message)
        var messageElement = document.getElementById('message-view')
        if (messageElement !== null) {
            while(messageElement.hasChildNodes()) {
                // looping over lastChild thx to http://stackoverflow.com/questions/5402525/remove-all-child-nodes
                messageElement.removeChild(messageElement.lastChild);
            }
            messageElement.appendChild(textNode)
        }
    }

    function disableSignupForm() {
        document.getElementById("create").setAttribute("disabled", "true")
        document.getElementById("create").setAttribute("style", CREATE_DISABLED_BACKGROUND)
    }

    function enableSignupForm() {
        document.getElementById("create").removeAttribute("disabled")
        document.getElementById("create").removeAttribute("style")
    }

    function redirectToStartPageURL() {
        setTimeout(function (e) {
            window.location.href = signupConfig.appStartPageURL
        }, 1500)
    }

    function redirectToTokenInfoPage() {
        setTimeout(function (e) {
            window.location.replace("/sign-up-ui/token-info")
        }, 500)
    }

if (typeof exports !== 'undefined') {
    module.exports = {
        signupConfig,
        CREATE_DISABLED_BACKGROUND,
        EMPTY_STRING,
        OK_STRING,
        checkAccountAvailability,
        checkEmailAddressAvailability,
        checkPasswordComplexity,
        createAccount,
        disableSignupForm,
        doLogin,
        enableSignupForm,
        isValidEmailAddress,
        comparePasswords
    };
}