/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.repository;

import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.inject.Inject;
import systems.dmx.signup_ui.configuration.Environment;
import systems.dmx.signup_ui.repository.ResourceBundleDatasource;
import systems.dmx.signup_ui.repository.ResourceBundleRepository;

public class ResourceBundleRepositoryImpl
implements ResourceBundleRepository {
    static final Logger logger = Logger.getLogger(ResourceBundleRepositoryImpl.class.getName());
    static final String RESOURCE_BUNDLE_NAME = "SignupMessages";
    private final Environment environment;
    private final ResourceBundleDatasource datasource;

    @Inject
    ResourceBundleRepositoryImpl(Environment environment, ResourceBundleDatasource datasource) {
        this.environment = environment;
        this.datasource = datasource;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle rb = this.datasource.load(this.environment.getPluginConfDir(), RESOURCE_BUNDLE_NAME, locale);
        if (rb != null) {
            logger.info("Using messages from plugin conf dir  in " + locale.getLanguage());
            return rb;
        }
        rb = this.datasource.load(RESOURCE_BUNDLE_NAME, locale);
        if (rb != null) {
            logger.info("Using built-in messages in " + locale.getLanguage());
            return rb;
        }
        logger.warning("Could not find Sign-up plugin properties - use default english resource bundle for labels");
        return this.datasource.load(RESOURCE_BUNDLE_NAME, Locale.ENGLISH);
    }

    @Override
    public ResourceBundle getDefaultResourceBundle() {
        return this.datasource.load(RESOURCE_BUNDLE_NAME, Locale.ENGLISH);
    }
}

