/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.repository;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ResourceBundleDatasource {
    @Inject
    ResourceBundleDatasource() {
    }

    public ResourceBundle load(File baseDir, String baseName, Locale locale) {
        try {
            return ResourceBundle.getBundle(baseName, locale, new URLClassLoader(new URL[]{baseDir.toURI().toURL()}));
        }
        catch (IOException | MissingResourceException e) {
            return null;
        }
    }

    public ResourceBundle load(String baseName, Locale locale) {
        try {
            return ResourceBundle.getBundle(baseName, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

