/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.signup.configuration.ExpectedPasswordComplexity;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup_ui.usecase.GetMessageUseCase;

@Singleton
public class GetPasswordComplexityFailedHintUseCase {
    private final GetMessageUseCase getMessageUseCase;
    private final int minPasswordLength;
    private final int maxPasswordLength;
    private final ExpectedPasswordComplexity expectedPasswordComplexity;

    GetPasswordComplexityFailedHintUseCase(GetMessageUseCase getMessageUseCase, int minPasswordLength, int maxPasswordLength, ExpectedPasswordComplexity expectedPasswordComplexity) {
        this.getMessageUseCase = getMessageUseCase;
        this.minPasswordLength = minPasswordLength;
        this.maxPasswordLength = maxPasswordLength;
        this.expectedPasswordComplexity = expectedPasswordComplexity;
    }

    @Inject
    public GetPasswordComplexityFailedHintUseCase(GetMessageUseCase getMessageUseCase) {
        this.getMessageUseCase = getMessageUseCase;
        this.minPasswordLength = SignUpConfigOptions.CONFIG_EXPECTED_MIN_PASSWORD_LENGTH;
        this.maxPasswordLength = SignUpConfigOptions.CONFIG_EXPECTED_MAX_PASSWORD_LENGTH;
        this.expectedPasswordComplexity = SignUpConfigOptions.CONFIG_EXPECTED_PASSWORD_COMPLEXITY;
    }

    public String invoke() {
        switch (this.expectedPasswordComplexity) {
            case NONE: {
                throw new IllegalStateException("When expected password complexity is 'none' it can never fail.");
            }
            case SIMPLE: {
                return this.getMessageUseCase.invoke("simple_password_check_failed_hint", this.minPasswordLength, this.maxPasswordLength);
            }
            case COMPLEX: {
                return this.getMessageUseCase.invoke("complex_password_check_failed_hint", this.minPasswordLength, this.maxPasswordLength);
            }
        }
        throw new IllegalStateException("Unexpected password complexity: " + this.expectedPasswordComplexity);
    }
}

