/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup_ui.usecase;

import java.net.URISyntaxException;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import systems.dmx.signup.SignupService;
import systems.dmx.signup_ui.web.ResponseBuilder;

@Singleton
public class InitiatePasswordResetWithNameUseCase {
    static final Logger logger = Logger.getLogger(InitiatePasswordResetWithNameUseCase.class.getName());
    private final SignupService signupService;
    private final ResponseBuilder responseBuilder;

    @Inject
    InitiatePasswordResetWithNameUseCase(SignupService signupService, ResponseBuilder responseBuilder) {
        this.signupService = signupService;
        this.responseBuilder = responseBuilder;
    }

    public Response invoke(String emailAddress, String name) throws URISyntaxException {
        logger.info("Password reset requested for user with Email: \"" + emailAddress + "\" and Name: \"" + name + "\"");
        switch (this.signupService.requestInitiatePasswordReset(emailAddress, name)) {
            case SUCCESS: {
                return this.responseBuilder.temporaryRedirect("/sign-up-ui/token-info");
            }
        }
        return this.responseBuilder.temporaryRedirect("/sign-up-ui/error");
    }
}

