/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration10
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    private WorkspacesService wsService;

    public void run() {
        long administrationWsId = this.dmx.getPrivilegedAccess().getAdminWorkspaceId();
        this.logger.info("###### Migrate all relevant Sign-up Configration Topics to \"Administration\" Workspace");
        Topic standardConfiguration = this.dmx.getTopicByUri("org.deepamehta.signup.default_configuration");
        this.wsService.assignToWorkspace((DMXObject)standardConfiguration, administrationWsId);
        standardConfiguration.loadChildTopics();
        RelatedTopic webAppTitle = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_webapp_title");
        RelatedTopic logoPath = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_webapp_logo_path");
        RelatedTopic cssPath = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_custom_css_path");
        RelatedTopic projectTitle = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_project_title");
        RelatedTopic tosLabel = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_tos_label");
        RelatedTopic tosDetail = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_tos_detail");
        RelatedTopic pdLabel = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_pd_label");
        RelatedTopic pdDetail = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_pd_detail");
        RelatedTopic readMoreUrl = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_read_more_url");
        RelatedTopic pagesFooter = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_pages_footer");
        RelatedTopic emailConfirmaton = standardConfiguration.getChildTopics().getTopic("org.deepamehta.signup.config_email_confirmation");
        this.wsService.assignToWorkspace((DMXObject)webAppTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter.getRelatingAssoc(), administrationWsId);
        TopicType tokenConfirmationType = this.dmx.getTopicType("org.deepamehta.signup.config_email_confirmation");
        List tokenConfirmationTypeAssignments = tokenConfirmationType.getAssocs();
        for (Assoc assoc : tokenConfirmationTypeAssignments) {
            if (!assoc.getPlayer1().getDMXObject().getTypeUri().equals("dmx.workspaces.workspace") && !assoc.getPlayer2().getDMXObject().getTypeUri().equals("dmx.workspaces.workspace")) continue;
            assoc.delete();
        }
        Topic pluginTopic = this.dmx.getTopicByUri("systems.dmx.sign-up");
        if (pluginTopic != null) {
            List configs = pluginTopic.getAssocs();
            for (Assoc assoc : configs) {
                if (!assoc.getPlayer1().getDMXObject().getTypeUri().equals("org.deepamehta.signup.configuration") && !assoc.getPlayer2().getDMXObject().getTypeUri().equals("org.deepamehta.signup.configuration")) continue;
                this.wsService.assignToWorkspace((DMXObject)assoc, administrationWsId);
                assoc.setSimpleValue(new SimpleValue("Active Configuration"));
            }
        }
        Topic apiMembershipNote = this.dmx.getTopicByUri("org.deepamehta.signup.api_membership_requests");
        this.wsService.assignToWorkspace((DMXObject)apiMembershipNote, administrationWsId);
        this.logger.info("###### Migrate all users Email Addresses to \"Administration\" Workspace");
        List emails = this.dmx.getTopicsByType("dmx.contacts.email_address");
        for (Topic email : emails) {
            RelatedTopic username = email.getRelatedTopic("org.deepamehta.signup.user_mailbox", "dmx.core.child", "dmx.core.parent", "dmx.accesscontrol.username");
            if (username == null) continue;
            this.wsService.assignToWorkspace((DMXObject)email, administrationWsId);
        }
        this.logger.info("###### Email Address topic migration to \"Administration\" Workspace complete");
    }
}

