/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration13
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    private WorkspacesService wsService;

    public void run() {
        this.logger.info("###### Migrating \"User Mailbox\" edges...");
        List users = this.dmx.getTopicsByType("dmx.accesscontrol.username");
        for (Topic user : users) {
            RelatedTopic emailAddress = user.getRelatedTopic("org.deepamehta.signup.user_mailbox", "dmx.core.parent", "dmx.core.child", "dmx.contacts.email_address");
            if (emailAddress == null) continue;
            this.logger.info("###### Creating new \"User Mailbox\" edge for existing email address");
            Assoc newMailEdge = this.dmx.createAssoc(this.mf.newAssocModel("dmx.base.user_mailbox", (PlayerModel)this.mf.newTopicPlayerModel(user.getId(), "dmx.core.parent"), (PlayerModel)this.mf.newTopicPlayerModel(emailAddress.getId(), "dmx.core.child")));
            this.logger.info("###### Moving new \"User Mailbox\" edge into \"System\" workspace");
            this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)newMailEdge, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
            this.logger.info("###### Removing outdated \"User Mailbox\" edge");
            emailAddress.getRelatingAssoc().delete();
        }
        this.logger.info("###### Deleting outdated \"User Mailbox\" association type");
        this.dmx.deleteAssocType("org.deepamehta.signup.user_mailbox");
    }
}

