/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup;

import com.sun.jersey.api.view.Viewable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.osgi.framework.Bundle;
import org.thymeleaf.context.AbstractContext;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.Constants;
import systems.dmx.signup.UserAccountCreateListener;
import systems.dmx.signup.events.SignupResourceRequestedListener;
import systems.dmx.signup.service.SignupPluginService;
import systems.dmx.thymeleaf.ThymeleafPlugin;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/sign-up")
public class SignupPlugin
extends ThymeleafPlugin
implements SignupPluginService,
PostUpdateTopic {
    private static Logger log = Logger.getLogger(SignupPlugin.class.getName());
    public static final String MAILBOX_TYPE_URI = "dmx.contacts.email_address";
    public static final String DMX_HOST_URL = System.getProperty("dmx.host.url");
    public static final boolean DMX_ACCOUNTS_ENABLED = Boolean.parseBoolean(System.getProperty("dmx.security.new_accounts_are_enabled"));
    private Topic activeModuleConfiguration = null;
    private Topic customWorkspaceAssignmentTopic = null;
    private String systemEmailContact = null;
    private ResourceBundle rb = null;
    @Inject
    private AccessControlService acService;
    @Inject
    private SendmailService sendmail;
    @Inject
    private WorkspacesService wsService;
    @Context
    UriInfo uri;
    HashMap<String, JSONObject> token = new HashMap();
    HashMap<String, JSONObject> pwToken = new HashMap();
    static DMXEvent USER_ACCOUNT_CREATE_LISTENER = new DMXEvent(UserAccountCreateListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((UserAccountCreateListener)listener).userAccountCreated((Topic)params[0]);
        }
    };
    static DMXEvent SIGNUP_RESOURCE_REQUESTED = new DMXEvent(SignupResourceRequestedListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((SignupResourceRequestedListener)listener).signupResourceRequested((AbstractContext)params[0], (String)params[1]);
        }
    };

    public void init() {
        this.initTemplateEngine();
        this.loadPluginLanguageProperty();
        this.reloadAssociatedSignupConfiguration();
        log.info("\n\tdmx.signup.self_registration: " + Constants.CONFIG_SELF_REGISTRATION + "\n\tdmx.signup.confirm_email_address: " + Constants.CONFIG_EMAIL_CONFIRMATION + "\n\tdmx.signup.admin_mailbox: " + Constants.CONFIG_ADMIN_MAILBOX + "\n\tdmx.signup.system_mailbox: " + Constants.CONFIG_FROM_MAILBOX);
    }

    @GET
    @Path(value="/translation/{locale}")
    @Produces(value={"application/json"})
    public String getTranslationTable(@PathParam(value="locale") String language) {
        if (language.isEmpty()) {
            return null;
        }
        Locale le = new Locale(language);
        ResourceBundle newRb = ResourceBundle.getBundle("SignupMessages", le);
        Enumeration<String> bundleKeys = newRb.getKeys();
        JSONObject response = new JSONObject();
        while (bundleKeys.hasMoreElements()) {
            try {
                String key = bundleKeys.nextElement();
                response.put(key, (Object)newRb.getString(key));
            }
            catch (JSONException ex) {
                Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return response.toString();
    }

    @Override
    @GET
    @Path(value="/check/{username}")
    @Produces(value={"application/json"})
    public String getUsernameAvailability(@PathParam(value="username") String username) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", true);
            if (this.isUsernameTaken(username)) {
                response.put("isAvailable", false);
            }
            return response.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @GET
    @Path(value="/check/mailbox/{email}")
    @Produces(value={"application/json"})
    public String getMailboxAvailability(@PathParam(value="email") String email) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", true);
            if (this.isMailboxTaken(email)) {
                response.put("isAvailable", false);
            }
            return response.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GET
    @Path(value="/password-token/{email}")
    @Produces(value={"text/html"})
    public Response initiatePasswordReset(@PathParam(value="email") String email) throws URISyntaxException {
        log.info("Password reset requested for user with Email: \"" + email + "\"");
        try {
            String emailAddressValue = email.trim();
            boolean emailExists = this.dmx.getPrivilegedAccess().emailAddressExists(emailAddressValue);
            if (emailExists) {
                log.info("Email based password reset workflow do'able, sending out passwort reset mail.");
                this.sendPasswordResetToken(emailAddressValue);
                return Response.temporaryRedirect((URI)new URI("/sign-up/token-info")).build();
            }
            log.info("Email based password reset workflow not do'able, Email Address does NOT EXIST => " + email.trim());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.temporaryRedirect((URI)new URI("/sign-up/error")).build();
    }

    @GET
    @Path(value="/self-registration-active")
    @Produces(value={"application/json"})
    public Response getSelfRegistrationStatus() {
        return Response.ok((Object)("" + Constants.CONFIG_SELF_REGISTRATION)).build();
    }

    @GET
    @Path(value="/password-reset/{token}")
    @Produces(value={"text/html"})
    public Viewable handlePasswordResetRequest(@PathParam(value="token") String token) {
        try {
            if (!this.pwToken.containsKey(token)) {
                this.viewData("message", this.rb.getString("link_invalid"));
            }
            JSONObject input = this.pwToken.get(token);
            this.viewData("token", token);
            if (input != null && input.getLong("expiration") > new Date().getTime()) {
                String username = input.getString("username");
                String email = input.getString("mailbox");
                log.info("Handling password reset request for Email: \"" + email);
                this.viewData("requested_username", username);
                this.viewData("password_requested_title", this.rb.getString("password_requested_title"));
                this.prepareSignupPage("password-reset");
                return this.view("password-reset");
            }
            log.warning("Sorry the link to reset the password for ... has expired.");
            this.viewData("message", this.rb.getString("reset_link_expired"));
            return this.getFailureView("updated");
        }
        catch (JSONException ex) {
            log.severe("Sorry, an error occured during retriving your token. Please try again. " + ex.getMessage());
            this.viewData("message", this.rb.getString("reset_link_error"));
            return this.getFailureView("updated");
        }
    }

    @GET
    @Path(value="/password-reset/{token}/{password}")
    @Transactional
    public Viewable processPasswordUpdateRequest(@PathParam(value="token") String token, @PathParam(value="password") String password) {
        log.info("Processing Password Update Request Token... ");
        try {
            JSONObject entry = this.pwToken.get(token);
            if (entry != null) {
                Credentials newCreds = new Credentials("dummy", "pass");
                newCreds.username = entry.getString("username");
                newCreds.password = password;
                this.dmx.getPrivilegedAccess().changePassword(newCreds);
                this.pwToken.remove(token);
                log.info("Credentials for user " + newCreds.username + " were changed succesfully.");
                this.viewData("message", this.rb.getString("reset_password_ok"));
                this.prepareSignupPage("password-ok");
                return this.view("password-ok");
            }
            this.viewData("message", this.rb.getString("reset_password_error"));
            return this.getFailureView("updated");
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            this.viewData("message", this.rb.getString("reset_password_error"));
            return this.getFailureView("updated");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GET
    @Path(value="/handle/{username}/{pass-one}/{mailbox}/{skipConfirmation}")
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="pass-one") String password, @PathParam(value="mailbox") String mailbox, @PathParam(value="skipConfirmation") boolean skipConfirmation) {
        if (!Constants.CONFIG_SELF_REGISTRATION & !this.isAdministrationWorkspaceMember()) {
            throw new WebApplicationException(Response.noContent().build());
        }
        try {
            if (!Constants.CONFIG_EMAIL_CONFIRMATION) {
                this.createSimpleUserAccount(username, password, mailbox);
                this.handleAccountCreatedRedirect(username);
                return this.getFailureView("created");
            }
            if (skipConfirmation && this.isAdministrationWorkspaceMember()) {
                log.info("Sign-up Configuration: Email based confirmation workflow active, Administrator skipping confirmation mail.");
                this.createSimpleUserAccount(username, password, mailbox);
                this.handleAccountCreatedRedirect(username);
                return this.getFailureView("created");
            }
            log.info("Sign-up Configuration: Email based confirmation workflow active, send out confirmation mail.");
            this.sendUserValidationToken(username, password, mailbox);
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/token-info")).build());
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Could not build response URI while handling sign-up request", e);
        }
        return this.getFailureView("created");
    }

    @Override
    @GET
    @Path(value="/handle/{username}/{pass-one}/{mailbox}")
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="pass-one") String password, @PathParam(value="mailbox") String mailbox) {
        return this.handleSignupRequest(username, password, mailbox, false);
    }

    @GET
    @Path(value="/confirm/{token}")
    public Viewable processSignupRequest(@PathParam(value="token") String key) {
        String username;
        if (!this.token.containsKey(key)) {
            this.viewData("username", null);
            this.viewData("message", this.rb.getString("link_invalid"));
            return this.getFailureView("created");
        }
        JSONObject input = this.token.get(key);
        this.token.remove(key);
        try {
            username = input.getString("username");
            if (input.getLong("expiration") <= new Date().getTime()) {
                this.viewData("username", null);
                this.viewData("message", this.rb.getString("link_expired"));
                return this.getFailureView("created");
            }
            log.log(Level.INFO, "Trying to create user account for {0}", input.getString("mailbox"));
            this.createSimpleUserAccount(username, input.getString("password"), input.getString("mailbox"));
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            this.viewData("message", this.rb.getString("internal_error"));
            log.log(Level.SEVERE, "Account creation failed due to {0} caused by {1}", new Object[]{ex.getMessage(), ex.getCause().toString()});
            return this.getFailureView("created");
        }
        log.log(Level.INFO, "Account succesfully created for username: {0}", username);
        this.viewData("message", this.rb.getString("account_created"));
        if (!DMX_ACCOUNTS_ENABLED) {
            log.log(Level.INFO, "> Account activation by an administrator remains PENDING ");
            return this.getAccountCreationPendingView();
        }
        return this.getAccountCreationOKView(username);
    }

    @Override
    @POST
    @Path(value="/confirm/membership/custom")
    @Transactional
    public String createAPIWorkspaceMembershipRequest() {
        Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
        if (apiMembershipRequestNote != null && this.acService.getUsername() != null) {
            Topic usernameTopic = this.acService.getUsernameTopic(this.acService.getUsername());
            this.createApiWorkspaceMembership(usernameTopic);
            Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
            if (requestRelation == null) {
                this.createApiMembershipRequestNoteAssociation(usernameTopic, apiMembershipRequestNote);
            } else {
                log.info("Revoke Request for API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                this.sendSystemMailboxNotification("API Usage Revoked", "<br/>Hi admin,<br/><br/>" + usernameTopic.getSimpleValue().toString() + " just revoked his/her acceptance to your Terms of Service for API-Usage.<br/><br/>Just wanted to let you know.<br/>Cheers!");
            }
            return "{ \"membership_created\" : true}";
        }
        return "{ \"membership_created\" : false}";
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.signup.configuration")) {
            this.reloadAssociatedSignupConfiguration();
        } else if (topic.getTypeUri().equals("dmx.accesscontrol.login_enabled")) {
            boolean status = Boolean.parseBoolean(topic.getSimpleValue().toString());
            RelatedTopic username = topic.getRelatedTopic("dmx.config.configuration", null, null, "dmx.accesscontrol.username");
            if (status && !DMX_ACCOUNTS_ENABLED) {
                log.info("Sign-up Notification: User Account \"" + username.getSimpleValue() + "\" is now ENABLED!");
                String webAppTitle = this.activeModuleConfiguration.getChildTopics().getTopic("dmx.signup.config_webapp_title").getSimpleValue().toString();
                RelatedTopic mailbox = username.getRelatedTopic("dmx.base.user_mailbox", null, null, MAILBOX_TYPE_URI);
                if (mailbox != null) {
                    String mailboxValue = mailbox.getSimpleValue().toString();
                    this.sendSystemMail("Your account on " + webAppTitle + " is now active", this.rb.getString("mail_hello") + " " + username.getSimpleValue() + ",<br/><br/>your account on <a href=\"" + DMX_HOST_URL + "\">" + webAppTitle + "</a> is now active.<br/><br/>" + this.rb.getString("mail_ciao"), mailboxValue);
                    log.info("Send system notification mail to " + mailboxValue + " - The account is now active!");
                }
            }
        }
    }

    @GET
    @Produces(value={"text/html"})
    public Viewable getSignupFormView() throws URISyntaxException {
        if (!Constants.CONFIG_SELF_REGISTRATION && !this.isAdministrationWorkspaceMember()) {
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/systems.dmx.webclient/")).build());
        }
        if (this.acService.getUsername() != null && !this.isAdministrationWorkspaceMember()) {
            this.prepareSignupPage("logout");
            return this.view("logout");
        }
        this.prepareSignupPage("sign-up");
        return this.view("sign-up");
    }

    @GET
    @Path(value="/login")
    @Produces(value={"text/html"})
    public Viewable getLoginView() {
        if (this.acService.getUsername() != null) {
            this.prepareSignupPage("logout");
            return this.view("logout");
        }
        this.prepareSignupPage("login");
        return this.view("login");
    }

    @GET
    @Path(value="/request-password")
    @Produces(value={"text/html"})
    public Viewable getPasswordResetView() {
        this.prepareSignupPage("request-password");
        return this.view("request-password");
    }

    @GET
    @Path(value="/{username}/ok")
    @Produces(value={"text/html"})
    public Viewable getAccountCreationOKView(@PathParam(value="username") String username) {
        this.prepareSignupPage("ok");
        this.viewData("requested_username", username);
        return this.view("ok");
    }

    @GET
    @Path(value="/pending")
    @Produces(value={"text/html"})
    public Viewable getAccountCreationPendingView() {
        this.prepareSignupPage("pending");
        return this.view("pending");
    }

    @GET
    @Path(value="/error")
    @Produces(value={"text/html"})
    public Viewable getFailureView() {
        return this.getFailureView(null);
    }

    private Viewable getFailureView(String status) {
        if (status != null && status.equals("created")) {
            this.viewData("status_label", this.rb.getString("status_label_created"));
        } else {
            this.viewData("status_label", this.rb.getString("status_label_updated"));
        }
        this.viewData("account_failure_message", this.rb.getString("account_failure_message"));
        this.viewData("please_try_1", this.rb.getString("please_try_1"));
        this.viewData("please_try_2", this.rb.getString("please_try_2"));
        this.viewData("please_try_3", this.rb.getString("please_try_3"));
        this.prepareSignupPage("failure");
        return this.view("failure");
    }

    @GET
    @Path(value="/token-info")
    @Produces(value={"text/html"})
    public Viewable getConfirmationInfoView() {
        this.prepareSignupPage("account-confirmation");
        return this.view("account-confirmation");
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"text/html"})
    public Viewable getAccountDetailsView() {
        this.prepareSignupPage("account-edit");
        this.prepareAccountEditPage();
        return this.view("account-edit");
    }

    @Override
    public void sendSystemMailboxNotification(String subject, String message) {
        if (!Constants.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            String recipient = Constants.CONFIG_ADMIN_MAILBOX;
            try {
                this.sendSystemMail(subject, message, recipient);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup,we FAILED sending out a notification mail to the \"System Mailbox\", caused by: " + ex.getMessage());
            }
        } else {
            log.info("Did not send notification mail to System Mailbox - Admin Mailbox Empty");
        }
    }

    @Override
    public void sendUserMailboxNotification(String mailbox, String subject, String message) {
        try {
            this.sendSystemMail(subject, message, mailbox);
        }
        catch (Exception ex) {
            log.severe("There seems to be an issue with your mail (SMTP) setup,we FAILED sending out a notification mail to User \"" + mailbox + "\", caused by: " + ex.getMessage());
        }
    }

    @Override
    public String createSimpleUserAccount(String username, String password, String mailbox) {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            if (this.isUsernameTaken(username)) {
                throw new RuntimeException("Username was already registered and confirmed!");
            }
            Credentials creds = new Credentials(new JSONObject().put("username", (Object)username.trim()).put("password", (Object)password.trim()));
            final Topic usernameTopic = this.acService._createUserAccount(creds);
            final String eMailAddressValue = mailbox;
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(-1L, (Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    long systemWorkspaceId = SignupPlugin.this.dmx.getPrivilegedAccess().getSystemWorkspaceId();
                    Topic eMailAddress = SignupPlugin.this.dmx.createTopic(SignupPlugin.this.mf.newTopicModel(SignupPlugin.MAILBOX_TYPE_URI, new SimpleValue(eMailAddressValue)));
                    SignupPlugin.this.dmx.fireEvent(USER_ACCOUNT_CREATE_LISTENER, new Object[]{usernameTopic});
                    SignupPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)eMailAddress, systemWorkspaceId);
                    Assoc assoc = SignupPlugin.this.dmx.createAssoc(SignupPlugin.this.mf.newAssocModel("dmx.base.user_mailbox", (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(eMailAddress.getId(), "dmx.core.child"), (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.parent")));
                    SignupPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)assoc, systemWorkspaceId);
                    if (SignupPlugin.this.customWorkspaceAssignmentTopic != null) {
                        SignupPlugin.this.acService.createMembership(usernameTopic.getSimpleValue().toString(), SignupPlugin.this.customWorkspaceAssignmentTopic.getId());
                        log.info("Created new Membership for " + usernameTopic.getSimpleValue().toString() + " in workspace=" + SignupPlugin.this.customWorkspaceAssignmentTopic.getSimpleValue().toString());
                    }
                    return eMailAddress;
                }
            });
            log.info("Created new user account for user \"" + username + "\" and " + eMailAddressValue);
            this.sendNotificationMail(username, mailbox.trim());
            tx.success();
            String string = username;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating simple user account FAILED!", e);
        }
        finally {
            tx.finish();
        }
    }

    @Override
    public boolean isMailboxTaken(String email) {
        String value = email.toLowerCase().trim();
        return this.dmx.getPrivilegedAccess().emailAddressExists(value);
    }

    @Override
    public boolean isUsernameTaken(String username) {
        String value = username.trim();
        Topic userNameTopic = this.acService.getUsernameTopic(value);
        return userNameTopic != null;
    }

    @Override
    public boolean isValidEmailAddress(String value) {
        return true;
    }

    private void handleAccountCreatedRedirect(String username) throws URISyntaxException {
        if (DMX_ACCOUNTS_ENABLED) {
            log.info("DMX Config: The new account is now ENABLED, redirecting to OK page.");
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/" + username + "/ok")).build());
        }
        log.info("DMX Config: The new account is now DISABLED, redirecting to PENDING page.");
        throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/pending")).build());
    }

    private boolean isAdministrationWorkspaceMember() {
        long administrationWorkspaceId;
        String username = this.acService.getUsername();
        return username != null && (this.acService.isMember(username, administrationWorkspaceId = this.dmx.getPrivilegedAccess().getAdminWorkspaceId()) || this.acService.getWorkspaceOwner(administrationWorkspaceId).equals(username));
    }

    private boolean isApiWorkspaceMember() {
        String username = this.acService.getUsername();
        if (username != null) {
            String apiWorkspaceUri = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_api_workspace_uri");
            if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
                Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
                if (apiWorkspace != null) {
                    return this.acService.isMember(username, apiWorkspace.getId());
                }
            } else {
                Topic usernameTopic = this.acService.getUsernameTopic();
                Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
                Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
                if (requestRelation != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void sendUserValidationToken(String username, String password, String mailbox) {
        String tokenKey = this.createUserValidationToken(username, password, mailbox);
        this.sendConfirmationMail(tokenKey, username, mailbox.trim());
    }

    private void sendPasswordResetToken(String mailbox) {
        String username = this.dmx.getPrivilegedAccess().getUsername(mailbox);
        String tokenKey = this.createPasswordResetToken(username, mailbox);
        this.sendPasswordResetMail(tokenKey, username, mailbox.trim());
    }

    private String createUserValidationToken(String username, String password, String mailbox) {
        try {
            String tokenKey = UUID.randomUUID().toString();
            long valid = new Date().getTime() + 3600000L;
            JSONObject tokenValue = new JSONObject().put("username", (Object)username.trim()).put("mailbox", (Object)mailbox.trim()).put("password", (Object)password).put("expiration", valid);
            this.token.put(tokenKey, tokenValue);
            log.log(Level.INFO, "Set up key {0} for {1} sending confirmation mail valid till {3}", new Object[]{tokenKey, mailbox, new Date(valid).toString()});
            return tokenKey;
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private String createPasswordResetToken(String username, String mailbox) {
        try {
            String tokenKey = UUID.randomUUID().toString();
            long valid = new Date().getTime() + 3600000L;
            JSONObject tokenValue = new JSONObject().put("username", (Object)username.trim()).put("mailbox", (Object)mailbox.trim()).put("expiration", valid);
            this.pwToken.put(tokenKey, tokenValue);
            log.log(Level.INFO, "Set up pwToken {0} for {1} send passwort reset mail valid till {3}", new Object[]{tokenKey, mailbox, new Date(valid).toString()});
            return tokenKey;
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private void createApiMembershipRequestNoteAssociation(Topic usernameTopic, Topic membershipNote) {
        Assoc apiRequest = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(membershipNote.getId(), "dmx.core.default")));
        this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)apiRequest, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
        log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
        this.sendSystemMailboxNotification("API Usage Requested", "<br/>Hi admin,<br/><br/>" + usernameTopic.getSimpleValue().toString() + " accepted the Terms of Service for API Usage.<br/><br/>Just wanted to let you know.<br/>Cheers!");
    }

    private void createApiWorkspaceMembership(Topic usernameTopic) {
        String apiWorkspaceUri = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_api_workspace_uri");
        if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
            Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
            if (apiWorkspace != null) {
                log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                this.acService.createMembership(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId());
            } else {
                log.info("Revoke Request for API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                if (this.acService.isMember(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId())) {
                    Assoc assoc = this.getMembershipAssociation(usernameTopic.getId(), apiWorkspace.getId());
                    this.dmx.deleteAssoc(assoc.getId());
                } else {
                    log.info("Skipped Revoke Request for non-existent API Workspace Membership for \"" + usernameTopic.getSimpleValue().toString() + "\"");
                }
            }
        } else {
            log.info("No API Workspace Configured: You must enter the URI of a programmatically created workspace topic into your current \"Signup Configuration\".");
        }
    }

    private Topic reloadAssociatedSignupConfiguration() {
        this.activeModuleConfiguration = this.getCurrentSignupConfiguration();
        if (this.activeModuleConfiguration == null) {
            log.warning("Could not load associated Sign-up Plugin Configuration Topic during init/postUpdate");
            return null;
        }
        this.activeModuleConfiguration.loadChildTopics();
        this.customWorkspaceAssignmentTopic = this.getCustomWorkspaceAssignmentTopic();
        if (this.customWorkspaceAssignmentTopic != null) {
            log.info("Configured Custom Sign-up Workspace => \"" + this.customWorkspaceAssignmentTopic.getSimpleValue() + "\"");
        }
        log.log(Level.INFO, "Sign-up Configuration Loaded (URI=\"{0}\"), Name=\"{1}\"", new Object[]{this.activeModuleConfiguration.getUri(), this.activeModuleConfiguration.getSimpleValue()});
        return this.activeModuleConfiguration;
    }

    private void sendConfirmationMail(String key, String username, String mailbox) {
        block5: {
            try {
                String webAppTitle = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_webapp_title");
                URL url = new URL(DMX_HOST_URL);
                log.info("The confirmation mails token request URL should be:\n" + url + "sign-up/confirm/" + key);
                String mailSubject = this.rb.getString("mail_confirmation_subject") + " - " + webAppTitle;
                try {
                    String linkHref = "<a href=\"" + url + "sign-up/confirm/" + key + "\">" + this.rb.getString("mail_confirmation_link_label") + "</a>";
                    if (DMX_ACCOUNTS_ENABLED) {
                        this.sendSystemMail(mailSubject, this.rb.getString("mail_hello") + " " + username + ",<br/><br/>" + this.rb.getString("mail_confirmation_active_body") + "<br/><br/>" + linkHref + "<br/><br/>" + this.rb.getString("mail_ciao"), mailbox);
                        break block5;
                    }
                    this.sendSystemMail(mailSubject, this.rb.getString("mail_hello") + " " + username + ",<br/><br/>" + this.rb.getString("mail_confirmation_proceed_1") + "<br/>" + linkHref + "<br/><br/>" + this.rb.getString("mail_confirmation_proceed_2") + "<br/><br/>" + this.rb.getString("mail_ciao"), mailbox);
                }
                catch (Exception ex) {
                    log.severe("There seems to be an issue with your mail (SMTP) setup,we FAILED sending out the \"Email Confirmation\" mail, caused by: " + ex.getMessage());
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void sendPasswordResetMail(String key, String username, String mailbox) {
        try {
            String webAppTitle = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_webapp_title");
            URL url = new URL(DMX_HOST_URL);
            log.info("The password reset mails token request URL should be:\n" + url + "sign-up/password-reset/" + key);
            String href = url + "sign-up/password-reset/" + key;
            try {
                this.sendSystemMail(this.rb.getString("mail_pw_reset_title") + " " + webAppTitle, this.rb.getString("mail_hello") + " " + username + ",<br/><br/>" + this.rb.getString("mail_pw_reset_body") + "<br/><a href=\"" + href + "\">" + href + "</a><br/><br/>" + this.rb.getString("mail_cheers"), mailbox);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup,we FAILED sending out the \"Password Reset\" mail, caused by: " + ex.getMessage());
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendNotificationMail(String username, String mailbox) {
        String webAppTitle = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_webapp_title");
        if (!Constants.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            String adminMailbox = Constants.CONFIG_ADMIN_MAILBOX;
            try {
                this.sendSystemMail("Account registration on " + webAppTitle, "<br/>A user has registered.<br/><br/>Username: " + username + "<br/>Email: " + mailbox, adminMailbox);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup,we FAILED notifying the \"system mailbox\" about account creation, caused by: " + ex.getMessage());
            }
        } else {
            log.info("ADMIN: No \"Admin Mailbox\" configured: A new user account (" + username + ") was created but no notification could be sent.");
        }
    }

    private void sendSystemMail(String subject, String message, String recipientValues) {
        String projectName = this.activeModuleConfiguration.getChildTopics().getString("dmx.signup.config_project_title");
        String sender = Constants.CONFIG_FROM_MAILBOX;
        String mailBody = message + "\n\n" + DMX_HOST_URL + "\n\n";
        this.sendmail.doEmailRecipientAs(sender, projectName, subject, mailBody, recipientValues);
    }

    private Assoc getDefaultAssociation(long topic1, long topic2) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", topic1, topic2, "dmx.core.default", "dmx.core.default");
    }

    private Assoc getMembershipAssociation(long id, long idTwo) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.accesscontrol.membership", id, idTwo, "dmx.core.default", "dmx.core.default");
    }

    private void loadPluginLanguageProperty() {
        String signupPropertyLanguageValue = null;
        try {
            Properties allProperties = new Properties();
            allProperties.load(this.getStaticResource("/plugin.properties"));
            signupPropertyLanguageValue = allProperties.getProperty("dmx.signup.language");
            if (signupPropertyLanguageValue == null || signupPropertyLanguageValue.toLowerCase().equals("en")) {
                log.info("Sign-up Plugin Language option sets labels to ENGLISH");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.ENGLISH);
            } else if (signupPropertyLanguageValue.toLowerCase().equals("de")) {
                log.info("Sign-up Plugin Language \"" + signupPropertyLanguageValue + "\" sets labels to GERMAN");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.GERMAN);
            } else if (signupPropertyLanguageValue.toLowerCase().equals("fr")) {
                log.info("Sign-up Plugin Language \"" + signupPropertyLanguageValue + "\" sets labels to FRENCH");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.FRENCH);
            }
        }
        catch (IOException ex) {
            log.warning("Could not find Sign-up plugin properties - use default resource bundle for labels");
            this.rb = ResourceBundle.getBundle("SignupMessages", Locale.ENGLISH);
        }
    }

    private Topic getCurrentSignupConfiguration() {
        return this.dmx.getTopicByUri("dmx.signup.default_configuration");
    }

    private Topic getCustomWorkspaceAssignmentTopic() {
        return this.activeModuleConfiguration.getRelatedTopic("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }

    private void prepareSignupPage(String templateName) {
        if (this.activeModuleConfiguration != null) {
            this.dmx.fireEvent(SIGNUP_RESOURCE_REQUESTED, new Object[]{this.context(), templateName});
            ChildTopics configuration = this.activeModuleConfiguration.getChildTopics();
            this.viewData("title", configuration.getTopic("dmx.signup.config_webapp_title").getSimpleValue().toString());
            this.viewData("logo_path", configuration.getTopic("dmx.signup.config_webapp_logo_path").getSimpleValue().toString());
            this.viewData("css_path", configuration.getTopic("dmx.signup.config_custom_css_path").getSimpleValue().toString());
            this.viewData("project_name", configuration.getTopic("dmx.signup.config_project_title").getSimpleValue().toString());
            this.viewData("read_more_url", configuration.getTopic("dmx.signup.config_read_more_url").getSimpleValue().toString());
            this.viewData("tos_label", configuration.getTopic("dmx.signup.config_tos_label").getSimpleValue().toString());
            this.viewData("tos_details", configuration.getTopic("dmx.signup.config_tos_detail").getSimpleValue().toString());
            this.viewData("pd_label", configuration.getTopic("dmx.signup.config_pd_label").getSimpleValue().toString());
            this.viewData("pd_details", configuration.getTopic("dmx.signup.config_pd_detail").getSimpleValue().toString());
            this.viewData("footer", configuration.getTopic("dmx.signup.config_pages_footer").getSimpleValue().toString());
            this.viewData("custom_workspace_enabled", configuration.getBoolean("dmx.signup.config_api_enabled"));
            this.viewData("custom_workspace_description", configuration.getTopic("dmx.signup.config_api_description").getSimpleValue().toString());
            this.viewData("custom_workspace_details", configuration.getTopic("dmx.signup.config_api_details").getSimpleValue().toString());
            this.viewData("custom_workspace_uri", configuration.getTopic("dmx.signup.config_api_workspace_uri").getSimpleValue().toString());
            this.viewData("start_url", configuration.getTopic("dmx.signup.start_page_url").getSimpleValue().toString());
            this.viewData("visit_start_url", this.rb.getString("visit_start_url"));
            this.viewData("home_url", configuration.getTopic("dmx.signup.home_page_url").getSimpleValue().toString());
            this.viewData("visit_home_url", this.rb.getString("visit_home_url"));
            this.viewData("loading_app_hint", configuration.getTopic("dmx.signup.loading_app_hint").getSimpleValue().toString());
            this.viewData("logging_out_hint", configuration.getTopic("dmx.signup.logging_out_hint").getSimpleValue().toString());
            this.viewData("password_length_hint", this.rb.getString("password_length_hint"));
            this.viewData("password_match_hint", this.rb.getString("password_match_hint"));
            this.viewData("check_terms_hint", this.rb.getString("check_terms_hint"));
            this.viewData("username_invalid_hint", this.rb.getString("username_invalid_hint"));
            this.viewData("username_taken_hint", this.rb.getString("username_taken_hint"));
            this.viewData("email_invalid_hint", this.rb.getString("email_invalid_hint"));
            this.viewData("email_taken_hint", this.rb.getString("email_taken_hint"));
            this.viewData("not_authorized_message", this.rb.getString("not_authorized_message"));
            this.viewData("signup_title", this.rb.getString("signup_title"));
            this.viewData("create_account", this.rb.getString("create_account"));
            this.viewData("login_title", this.rb.getString("login_title"));
            this.viewData("log_in_small", this.rb.getString("log_in_small"));
            this.viewData("login", this.rb.getString("login"));
            this.viewData("or_label", this.rb.getString("or_label"));
            this.viewData("logout", this.rb.getString("logout"));
            this.viewData("logged_in_as", this.rb.getString("logged_in_as"));
            this.viewData("label_username", this.rb.getString("label_username"));
            this.viewData("label_email", this.rb.getString("label_email"));
            this.viewData("label_password", this.rb.getString("label_password"));
            this.viewData("label_password_repeat", this.rb.getString("label_password_repeat"));
            this.viewData("read_more", this.rb.getString("read_more"));
            this.viewData("label_forgot_password", this.rb.getString("forgot_password"));
            this.viewData("label_reset_password", this.rb.getString("reset_password"));
            this.viewData("info_reset_password", this.rb.getString("reset_password_hint"));
            this.viewData("password_reset_ok_message", this.rb.getString("password_reset_success_1"));
            this.viewData("your_account_title", this.rb.getString("your_account_title"));
            this.viewData("your_account_heading", this.rb.getString("your_account_heading"));
            this.viewData("your_account_username_label", this.rb.getString("your_account_username_label"));
            this.viewData("your_account_email_label", this.rb.getString("your_account_email_label"));
            this.viewData("api_option_title", this.rb.getString("api_option_title"));
            this.viewData("api_option_descr", this.rb.getString("api_option_descr"));
            this.viewData("api_option_revoke", this.rb.getString("api_option_revoke"));
            this.viewData("api_workspace_member", this.isApiWorkspaceMember());
            this.viewData("api_email_contact", this.systemEmailContact == null ? "" : this.systemEmailContact);
            this.viewData("api_contact_revoke", this.rb.getString("api_contact_revoke"));
            this.viewData("created_page_title", this.rb.getString("page_account_created_title"));
            this.viewData("created_page_body_1", this.rb.getString("page_account_created_body_1"));
            this.viewData("created_page_body_2", this.rb.getString("page_account_created_body_2"));
            this.viewData("created_page_body_3", this.rb.getString("page_account_created_body_3"));
            this.viewData("created_page_body_4", this.rb.getString("page_account_created_body_4"));
            this.viewData("requested_page_title", this.rb.getString("page_account_requested_title"));
            this.viewData("requested_page_1", this.rb.getString("page_account_requested_1"));
            this.viewData("requested_page_2", this.rb.getString("page_account_requested_2"));
            this.viewData("requested_page_3", this.rb.getString("page_account_requested_3"));
            String username = this.acService.getUsername();
            this.viewData("skip_confirmation_mail_label", this.rb.getString("admin_skip_email_confirmation_mail"));
            this.viewData("administration_workspace_member", this.isAdministrationWorkspaceMember());
            this.viewData("authenticated", username != null);
            this.viewData("username", username);
            this.viewData("template", templateName);
            this.viewData("hostUrl", DMX_HOST_URL);
        } else {
            log.severe("Could not load module configuration of sign-up plugin during page preparation!");
        }
    }

    private void prepareAccountEditPage() {
        String username = this.acService.getUsername();
        if (username != null) {
            String eMailAddressValue = "None";
            try {
                eMailAddressValue = this.dmx.getPrivilegedAccess().getEmailAddress(username);
            }
            catch (Exception e) {
                log.warning("Username has no Email Address topic related via \"dmx.base.user_mailbox\"");
            }
            this.viewData("logged_in", true);
            this.viewData("username", username);
            this.viewData("email", eMailAddressValue);
            this.viewData("link", "");
        } else {
            this.viewData("logged_in", false);
            this.viewData("username", "Not logged in");
            this.viewData("email", "Not logged in");
            this.viewData("link", "/sign-up/login");
        }
    }

    @Override
    public void reinitTemplateEngine() {
        super.initTemplateEngine();
    }

    @Override
    public void addTemplateResolverBundle(Bundle bundle) {
        super.addTemplateResourceBundle(bundle);
    }

    @Override
    public void removeTemplateResolverBundle(Bundle bundle) {
        super.removeTemplateResourceBundle(bundle);
    }
}

