/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup;

import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.core.util.Base64;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.thymeleaf.context.AbstractContext;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.facets.FacetsService;
import systems.dmx.ldap.service.LDAPPluginService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.OptionalService;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.UserAccountCreateListener;
import systems.dmx.signup.configuration.ModuleConfiguration;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup.events.SignupResourceRequestedListener;
import systems.dmx.thymeleaf.ThymeleafPlugin;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/sign-up")
public class SignupPlugin
extends ThymeleafPlugin
implements SignupService,
PostUpdateTopic {
    private static Logger log = Logger.getLogger(SignupPlugin.class.getName());
    private ModuleConfiguration activeModuleConfiguration = null;
    private Topic customWorkspaceAssignmentTopic = null;
    private String systemEmailContact = null;
    private ResourceBundle rb = null;
    @Inject
    private AccessControlService accesscontrol;
    @Inject
    private FacetsService facets;
    @Inject
    private SendmailService sendmail;
    @Inject
    private WorkspacesService workspaces;
    private OptionalService<LDAPPluginService> ldapPluginService;
    @Context
    UriInfo uri;
    HashMap<String, JSONObject> token = new HashMap();
    HashMap<String, JSONObject> pwToken = new HashMap();
    static DMXEvent USER_ACCOUNT_CREATE_LISTENER = new DMXEvent(UserAccountCreateListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((UserAccountCreateListener)listener).userAccountCreated((Topic)params[0]);
        }
    };
    static DMXEvent SIGNUP_RESOURCE_REQUESTED = new DMXEvent(SignupResourceRequestedListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((SignupResourceRequestedListener)listener).signupResourceRequested((AbstractContext)params[0], (String)params[1]);
        }
    };

    public void init() {
        this.initOptionalServices();
        this.initTemplateEngine();
        this.loadPluginLanguageProperty();
        this.reloadAssociatedSignupConfiguration();
        log.info("\n  dmx.signup.self_registration: " + SignUpConfigOptions.CONFIG_SELF_REGISTRATION + "\n  dmx.signup.confirm_email_address: " + SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION + "\n  dmx.signup.admin_mailbox: " + SignUpConfigOptions.CONFIG_ADMIN_MAILBOX + "\n  dmx.signup.system_mailbox: " + SignUpConfigOptions.CONFIG_FROM_MAILBOX + "\n  dmx.signup.ldap_account_creation: " + SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS + "\n  dmx.signup.account_creation_auth_ws_uri: " + SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI + "\n  dmx.signup.restrict_auth_methods: " + SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS + "\n");
        log.info("Available auth methods and order:" + this.getAuthorizationMethods() + "\n");
        if (SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS && !this.isLdapPluginAvailable()) {
            log.warning("LDAP Account creation configured but respective plugin not available!");
        }
    }

    private void initOptionalServices() {
        this.ldapPluginService = new OptionalService(this.getBundleContext(), () -> LDAPPluginService.class);
    }

    public void stop(BundleContext context) {
        this.ldapPluginService.release();
        super.stop(context);
    }

    @GET
    @Path(value="/translation/{locale}")
    @Produces(value={"application/json"})
    public String getTranslationTable(@PathParam(value="locale") String language) {
        if (language.isEmpty()) {
            return null;
        }
        Locale le = new Locale(language);
        ResourceBundle newRb = ResourceBundle.getBundle("SignupMessages", le);
        Enumeration<String> bundleKeys = newRb.getKeys();
        JSONObject response = new JSONObject();
        while (bundleKeys.hasMoreElements()) {
            try {
                String key = bundleKeys.nextElement();
                response.put(key, (Object)newRb.getString(key));
            }
            catch (JSONException ex) {
                Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return response.toString();
    }

    @Override
    @GET
    @Path(value="/check/{username}")
    @Produces(value={"application/json"})
    public String getUsernameAvailability(@PathParam(value="username") String username) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", true);
            if (this.isUsernameTaken(username)) {
                response.put("isAvailable", false);
            }
            return response.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GET
    @Path(value="/display-name/{username}")
    public String getDisplayName(@PathParam(value="username") String username) {
        try {
            RelatedTopic displayName;
            Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
            if (usernameTopic != null && (displayName = this.facets.getFacet((DMXObject)usernameTopic, "dmx.signup.display_name_facet")) != null) {
                return displayName.getSimpleValue().toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching display name of user \"" + username + "\" failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/display-name/{username}")
    @Transactional
    public void updateDisplayName(@PathParam(value="username") String username, @QueryParam(value="displayName") String displayName) {
        try {
            long workspaceId = this.getDisplayNamesWorkspaceId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
                if (usernameTopic != null) {
                    this.facets.updateFacet((DMXObject)usernameTopic, "dmx.signup.display_name_facet", this.mf.newFacetValueModel("dmx.signup.display_name").set((Object)displayName));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Updating display name of user \"" + username + "\" failed, displayName=\"" + displayName + "\"", e);
        }
    }

    @GET
    @Path(value="/check/mailbox/{email}")
    @Produces(value={"application/json"})
    public String getMailboxAvailability(@PathParam(value="email") String email) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", true);
            if (this.isMailboxTaken(email)) {
                response.put("isAvailable", false);
            }
            return response.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @GET
    @Path(value="/password-token/{email}")
    @Produces(value={"text/html"})
    public Response initiatePasswordReset(@PathParam(value="email") String email) throws URISyntaxException {
        log.info("Password reset requested for user with Email: \"" + email + "\"");
        return this.initiatePasswordResetWithName(email, null);
    }

    @Override
    @GET
    @Path(value="/password-token/{email}/{name}")
    @Produces(value={"text/html"})
    public Response initiatePasswordResetWithName(@PathParam(value="email") String email, @PathParam(value="name") String name) throws URISyntaxException {
        log.info("Password reset requested for user with Email: \"" + email + "\" and Name: \"" + name + "\"");
        try {
            String emailAddressValue = email.trim();
            boolean emailExists = this.dmx.getPrivilegedAccess().emailAddressExists(emailAddressValue);
            if (emailExists) {
                log.info("Email based password reset workflow do'able, sending out passwort reset mail.");
                this.sendPasswordResetToken(emailAddressValue, name, null);
                return Response.temporaryRedirect((URI)new URI("/sign-up/token-info")).build();
            }
            log.info("Email based password reset workflow not do'able, Email Address does NOT EXIST => " + email.trim());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
        }
        return Response.temporaryRedirect((URI)new URI("/sign-up/error")).build();
    }

    @Override
    @GET
    @Path(value="/password-token/{email}/{redirectUrl}")
    @Produces(value={"application/json"})
    public Response initiateRedirectPasswordReset(@PathParam(value="email") String email, @PathParam(value="redirectUrl") String redirectUrl) throws URISyntaxException {
        log.info("Password reset requested for user with Email: \"" + email + "\" wishing to redirect to: \"" + redirectUrl + "\"");
        String emailAddressValue = email.trim();
        boolean emailExists = this.dmx.getPrivilegedAccess().emailAddressExists(emailAddressValue);
        if (emailExists) {
            log.info("Email based password reset workflow do'able, sending out passwort reset mail.");
            this.sendPasswordResetToken(emailAddressValue, null, redirectUrl);
            return Response.ok().build();
        }
        log.warning("Email based password reset workflow not do'able, Email Address does NOT EXIST => " + email.trim());
        return Response.serverError().build();
    }

    @GET
    @Path(value="/self-registration-active")
    @Produces(value={"application/json"})
    public Response getSelfRegistrationStatus() {
        return Response.ok((Object)("" + SignUpConfigOptions.CONFIG_SELF_REGISTRATION)).build();
    }

    @GET
    @Path(value="/password-reset/{token}")
    @Produces(value={"application/xhtml+xml"})
    public Viewable handlePasswordResetRequest(@PathParam(value="token") String token) {
        try {
            if (!this.pwToken.containsKey(token)) {
                this.viewData("message", this.rb.getString("link_invalid"));
            }
            JSONObject input = this.pwToken.get(token);
            this.viewData("token", token);
            if (input != null && input.getLong("expiration") > new Date().getTime()) {
                String username = input.getString("username");
                String email = input.getString("mailbox");
                log.info("Handling password reset request for Email: \"" + email);
                this.viewData("mailbox", email);
                this.viewData("requested_username", username);
                String displayName = input.has("name") ? input.getString("name") : "";
                this.viewData("requested_display_name", displayName);
                this.viewData("password_requested_title", this.rb.getString("password_requested_title"));
                this.viewData("password_requested_button", this.rb.getString("password_requested_button"));
                if (input.has("redirectUrl")) {
                    String redirectUrl = input.getString("redirectUrl");
                    this.viewData("redirect_url", redirectUrl);
                }
                this.prepareSignupPage("password-reset");
                return this.view("password-reset");
            }
            log.warning("Sorry the link to reset the password for ... has expired.");
            this.viewData("message", this.rb.getString("reset_link_expired"));
            return this.getFailureView("updated");
        }
        catch (JSONException ex) {
            log.severe("Sorry, an error occured during retriving your token. Please try again. " + ex.getMessage());
            this.viewData("message", this.rb.getString("reset_link_error"));
            return this.getFailureView("updated");
        }
    }

    @GET
    @Path(value="/password-reset/{token}/{password}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processPasswordUpdateRequest(@PathParam(value="token") String token, @PathParam(value="password") String password) {
        log.info("Processing Password Update Request Token... ");
        try {
            JSONObject entry = this.pwToken.get(token);
            if (entry != null) {
                Credentials newCreds = new Credentials("dummy", "pass");
                newCreds.username = entry.getString("username").trim();
                if (!this.isLdapAccountCreationEnabled()) {
                    newCreds.password = password;
                    this.dmx.getPrivilegedAccess().changePassword(newCreds);
                    log.info("Credentials for user " + newCreds.username + " were changed succesfully.");
                } else {
                    String plaintextPassword = Base64.base64Decode((String)password);
                    log.info("Change password attempt for \"" + newCreds.username + "\". password-value string provided by client \"" + password + "\", plaintextPassword: \"" + plaintextPassword + "\"");
                    newCreds.plaintextPassword = plaintextPassword;
                    newCreds.password = password;
                    if (this.ldapPluginService.get().changePassword(newCreds) != null) {
                        log.info("If no previous errors are reported here or in the LDAP-service log, the credentials for user " + newCreds.username + " should now have been changed succesfully.");
                    } else {
                        log.severe("Credentials for user " + newCreds.username + " COULD NOT be changed succesfully.");
                        this.viewData("message", this.rb.getString("reset_password_error"));
                        return this.getFailureView("updated");
                    }
                }
                this.pwToken.remove(token);
                this.viewData("message", this.rb.getString("reset_password_ok"));
                this.prepareSignupPage("password-ok");
                return this.view("password-ok");
            }
            this.viewData("message", this.rb.getString("reset_password_error"));
            return this.getFailureView("updated");
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            this.viewData("message", this.rb.getString("reset_password_error"));
            return this.getFailureView("updated");
        }
    }

    @GET
    @Path(value="/password-reset/{token}/{password}")
    @Transactional
    @Produces(value={"application/json"})
    public Response processAjaxPasswordUpdateRequest(@PathParam(value="token") String token, @PathParam(value="password") String password) {
        log.info("Processing Password Update Request Token... ");
        try {
            JSONObject entry = this.pwToken.get(token);
            if (entry != null) {
                Credentials newCreds = new Credentials("dummy", "pass");
                newCreds.username = entry.getString("username").trim();
                if (!this.isLdapAccountCreationEnabled()) {
                    newCreds.password = password;
                    this.dmx.getPrivilegedAccess().changePassword(newCreds);
                    log.info("Credentials for user " + newCreds.username + " were changed succesfully.");
                } else {
                    String plaintextPassword = Base64.base64Decode((String)password);
                    log.info("Change password attempt for \"" + newCreds.username + "\". password-value string provided by client \"" + password + "\", plaintextPassword: \"" + plaintextPassword + "\"");
                    newCreds.plaintextPassword = plaintextPassword;
                    newCreds.password = password;
                    if (this.ldapPluginService.get().changePassword(newCreds) != null) {
                        log.info("If no previous errors are reported here or in the LDAP-service log, the credentials for user " + newCreds.username + " should now have been changed succesfully.");
                    } else {
                        log.severe("Credentials for user " + newCreds.username + " COULD NOT be changed succesfully.");
                        return Response.serverError().build();
                    }
                }
                this.pwToken.remove(token);
                return Response.ok().build();
            }
            return Response.serverError().build();
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            return Response.serverError().build();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @GET
    @Path(value="/handle/{username}/{pass-one}/{mailbox}/{skipConfirmation}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="pass-one") String password, @PathParam(value="mailbox") String mailbox, @PathParam(value="skipConfirmation") boolean skipConfirmation) {
        if (!SignUpConfigOptions.CONFIG_SELF_REGISTRATION && !this.canCreateNewAccount()) {
            throw new WebApplicationException(Response.noContent().build());
        }
        try {
            if (!SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION) {
                this.createSimpleUserAccount(username, password, mailbox);
                this.handleAccountCreatedRedirect(username);
                return this.getFailureView("created");
            }
            if (skipConfirmation && this.canCreateNewAccount()) {
                log.info("Sign-up Configuration: Email based confirmation workflow active, Administrator skipping confirmation mail.");
                this.createSimpleUserAccount(username, password, mailbox);
                this.handleAccountCreatedRedirect(username);
                return this.getFailureView("created");
            }
            log.info("Sign-up Configuration: Email based confirmation workflow active, send out confirmation mail.");
            this.sendUserValidationToken(username, password, mailbox);
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/token-info")).build());
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Could not build response URI while handling sign-up request", e);
        }
        return this.getFailureView("created");
    }

    @Override
    @GET
    @Path(value="/handle/{username}/{pass-one}/{mailbox}")
    @Produces(value={"text/html"})
    public Viewable handleSignupRequest(@PathParam(value="username") String username, @PathParam(value="pass-one") String password, @PathParam(value="mailbox") String mailbox) {
        return this.handleSignupRequest(username, password, mailbox, false);
    }

    @GET
    @Path(value="/custom-handle/{mailbox}/{displayname}/{password}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable handleCustomSignupRequest(@PathParam(value="mailbox") String mailbox, @PathParam(value="displayname") String displayName, @PathParam(value="password") String password) throws URISyntaxException {
        if (this.canCreateNewAccount()) {
            this.createCustomUserAccount(mailbox, displayName, password);
            log.info("Created new user account for user with display \"" + displayName + "\" and mailbox " + mailbox);
            this.handleAccountCreatedRedirect(mailbox);
        }
        return this.getFailureView("created");
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/custom-handle/{mailbox}/{displayname}/{password}")
    @Transactional
    public Topic handleCustomAJAXSignupRequest(@PathParam(value="mailbox") String mailbox, @PathParam(value="displayname") String displayName, @PathParam(value="password") String password) throws URISyntaxException {
        this.checkAccountCreation();
        Topic username = this.createCustomUserAccount(mailbox, displayName, password);
        log.info("Created new user account for user with display \"" + displayName + "\" and mailbox " + mailbox);
        return username;
    }

    private Topic createCustomUserAccount(String mailbox, String displayName, String password) {
        try {
            final String username = this.createSimpleUserAccount(mailbox.trim(), password, mailbox.trim());
            final String displayNameValue = displayName.trim();
            Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
            final long usernameTopicId = usernameTopic.getId();
            final long displayNamesWorkspaceId = this.getDisplayNamesWorkspaceId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(displayNamesWorkspaceId, (Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    SignupPlugin.this.facets.addFacetTypeToTopic(usernameTopicId, "dmx.signup.display_name_facet");
                    SignupPlugin.this.facets.updateFacet(usernameTopicId, "dmx.signup.display_name_facet", SignupPlugin.this.mf.newFacetValueModel("dmx.signup.display_name").set((Object)displayNameValue));
                    SignupPlugin.this.accesscontrol.createMembership(username, displayNamesWorkspaceId);
                    log.info("Created membership for new user account in \"Display Names\" workspace (SharingMode.Collaborative)");
                    return SignupPlugin.this.facets.getFacet(usernameTopicId, "dmx.signup.display_name_facet");
                }
            });
            return usernameTopic;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating custom user account failed, mailbox=\"" + mailbox + "\", displayName=\"" + displayName + "\"", e);
        }
    }

    public long getDisplayNamesWorkspaceId() {
        Topic ws = this.workspaces.getWorkspace("dmx.signup.display_names_ws");
        return ws != null ? ws.getId() : -1L;
    }

    @GET
    @Path(value="/confirm/{token}")
    @Produces(value={"application/xhtml+xml"})
    @Transactional
    public Viewable processSignupRequest(@PathParam(value="token") String key) {
        String username;
        if (!this.token.containsKey(key)) {
            this.viewData("username", null);
            this.viewData("message", this.rb.getString("link_invalid"));
            return this.getFailureView("created");
        }
        JSONObject input = this.token.get(key);
        this.token.remove(key);
        try {
            username = input.getString("username");
            if (input.getLong("expiration") <= new Date().getTime()) {
                this.viewData("username", null);
                this.viewData("message", this.rb.getString("link_expired"));
                return this.getFailureView("created");
            }
            log.log(Level.INFO, "Trying to create user account for {0}", input.getString("mailbox"));
            this.createSimpleUserAccount(username, input.getString("password"), input.getString("mailbox"));
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            this.viewData("message", this.rb.getString("internal_error"));
            log.log(Level.SEVERE, "Account creation failed due to {0} caused by {1}", new Object[]{ex.getMessage(), ex.getCause().toString()});
            return this.getFailureView("created");
        }
        log.log(Level.INFO, "Account succesfully created for username: {0}", username);
        this.viewData("message", this.rb.getString("account_created"));
        if (!SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
            log.log(Level.INFO, "> Account activation by an administrator remains PENDING ");
            return this.getAccountCreationPendingView();
        }
        return this.getAccountCreationOKView(username);
    }

    @Override
    @POST
    @Path(value="/confirm/membership/custom")
    @Transactional
    public String createAPIWorkspaceMembershipRequest() {
        Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
        if (apiMembershipRequestNote != null && this.accesscontrol.getUsername() != null) {
            Topic usernameTopic = this.accesscontrol.getUsernameTopic();
            this.createApiWorkspaceMembership(usernameTopic);
            Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
            if (requestRelation == null) {
                this.createApiMembershipRequestNoteAssociation(usernameTopic, apiMembershipRequestNote);
            } else {
                log.info("Revoke Request for API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                this.sendSystemMailboxNotification("API Usage Revoked", "<br>Hi admin,<br><br>" + usernameTopic.getSimpleValue().toString() + " just revoked his/her acceptance to your Terms of Service for API-Usage.<br><br>Just wanted to let you know.<br>Cheers!");
            }
            return "{ \"membership_created\" : true}";
        }
        return "{ \"membership_created\" : false}";
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.signup.configuration")) {
            this.reloadAssociatedSignupConfiguration();
        } else if (topic.getTypeUri().equals("dmx.accesscontrol.login_enabled")) {
            boolean status = Boolean.parseBoolean(topic.getSimpleValue().toString());
            RelatedTopic username = topic.getRelatedTopic("dmx.config.configuration", null, null, "dmx.accesscontrol.username");
            if (status && !SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
                log.info("Sign-up Notification: User Account \"" + username.getSimpleValue() + "\" is now ENABLED!");
                String webAppTitle = this.activeModuleConfiguration.getWebAppTitle();
                RelatedTopic mailbox = username.getRelatedTopic("dmx.base.user_mailbox", null, null, "dmx.contacts.email_address");
                if (mailbox != null) {
                    String mailboxValue = mailbox.getSimpleValue().toString();
                    this.sendSystemMail("Your account on " + webAppTitle + " is now active", this.rb.getString("mail_hello") + " " + username.getSimpleValue() + ",<br><br>your account on <a href=\"" + SignUpConfigOptions.DMX_HOST_URL + "\">" + webAppTitle + "</a> is now active.<br><br>" + this.rb.getString("mail_ciao"), mailboxValue);
                    log.info("Send system notification mail to " + mailboxValue + " - The account is now active!");
                }
            }
        }
    }

    @GET
    @Produces(value={"application/xhtml+xml"})
    public Viewable getSignupFormView() throws URISyntaxException {
        if (!SignUpConfigOptions.CONFIG_SELF_REGISTRATION && !this.canCreateNewAccount()) {
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/systems.dmx.webclient/")).build());
        }
        if (this.accesscontrol.getUsername() != null && !this.canCreateNewAccount()) {
            this.prepareSignupPage("logout");
            return this.view("logout");
        }
        this.prepareSignupPage("sign-up");
        return this.view("sign-up");
    }

    @GET
    @Path(value="/login")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getLoginView() {
        if (this.accesscontrol.getUsername() != null) {
            this.prepareSignupPage("logout");
            return this.view("logout");
        }
        this.prepareSignupPage("login");
        return this.view("login");
    }

    @GET
    @Path(value="/request-password")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getPasswordResetView() {
        this.prepareSignupPage("request-password");
        return this.view("request-password");
    }

    @GET
    @Path(value="/{username}/ok")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationOKView(@PathParam(value="username") String username) {
        this.prepareSignupPage("ok");
        this.viewData("requested_username", username);
        return this.view("ok");
    }

    @GET
    @Path(value="/pending")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountCreationPendingView() {
        this.prepareSignupPage("pending");
        return this.view("pending");
    }

    @GET
    @Path(value="/error")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getFailureView() {
        return this.getFailureView(null);
    }

    private Viewable getFailureView(String status) {
        if (status != null && status.equals("created")) {
            this.viewData("status_label", this.rb.getString("status_label_created"));
        } else {
            this.viewData("status_label", this.rb.getString("status_label_updated"));
        }
        this.viewData("account_failure_message", this.rb.getString("account_failure_message"));
        this.viewData("please_try_1", this.rb.getString("please_try_1"));
        this.viewData("please_try_2", this.rb.getString("please_try_2"));
        this.viewData("please_try_3", this.rb.getString("please_try_3"));
        this.prepareSignupPage("failure");
        return this.view("failure");
    }

    @GET
    @Path(value="/token-info")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getConfirmationInfoView() {
        this.prepareSignupPage("account-confirmation");
        return this.view("account-confirmation");
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"application/xhtml+xml"})
    public Viewable getAccountDetailsView() {
        this.prepareSignupPage("account-edit");
        this.prepareAccountEditPage();
        return this.view("account-edit");
    }

    @Override
    public void sendSystemMailboxNotification(String subject, String message) {
        if (!SignUpConfigOptions.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            String recipient = SignUpConfigOptions.CONFIG_ADMIN_MAILBOX;
            try {
                this.sendSystemMail(subject, message, recipient);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out a notification mail to the \"System Mailbox\", caused by: " + ex.getMessage());
            }
        } else {
            log.info("Did not send notification mail to System Mailbox - Admin Mailbox Empty");
        }
    }

    @Override
    public void sendUserMailboxNotification(String mailbox, String subject, String message) {
        try {
            this.sendSystemMail(subject, message, mailbox);
        }
        catch (Exception ex) {
            log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out a notification mail to User \"" + mailbox + "\", caused by: " + ex.getMessage());
        }
    }

    private boolean isLdapPluginAvailable() {
        try {
            return this.ldapPluginService.get() != null;
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    private boolean isLdapAccountCreationEnabled() {
        return SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS && this.isLdapPluginAvailable();
    }

    private Topic createUsername(Credentials credentials) throws Exception {
        if (this.isLdapAccountCreationEnabled()) {
            return this.ldapPluginService.get().createUser(credentials);
        }
        return this.accesscontrol._createUserAccount(credentials);
    }

    @Override
    public String createSimpleUserAccount(String username, String password, String mailbox) {
        try {
            Credentials creds;
            if (this.isUsernameTaken(username)) {
                throw new RuntimeException("Username was already registered and confirmed!");
            }
            if (!this.isLdapAccountCreationEnabled()) {
                creds = new Credentials(new JSONObject().put("username", (Object)username.trim()).put("password", (Object)password.trim()));
            } else {
                String plaintextPassword = Base64.base64Decode((String)password);
                creds = new Credentials(username.trim(), plaintextPassword);
                creds.plaintextPassword = plaintextPassword;
            }
            final Topic usernameTopic = this.createUsername(creds);
            final String eMailAddressValue = mailbox;
            long systemWorkspaceId = this.dmx.getPrivilegedAccess().getSystemWorkspaceId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(systemWorkspaceId, (Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    Topic eMailAddress = SignupPlugin.this.dmx.createTopic(SignupPlugin.this.mf.newTopicModel("dmx.contacts.email_address", new SimpleValue(eMailAddressValue)));
                    SignupPlugin.this.dmx.fireEvent(USER_ACCOUNT_CREATE_LISTENER, new Object[]{usernameTopic});
                    SignupPlugin.this.dmx.createAssoc(SignupPlugin.this.mf.newAssocModel("dmx.base.user_mailbox", (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(eMailAddress.getId(), "dmx.core.child"), (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.parent")));
                    if (SignupPlugin.this.customWorkspaceAssignmentTopic != null) {
                        SignupPlugin.this.accesscontrol.createMembership(usernameTopic.getSimpleValue().toString(), SignupPlugin.this.customWorkspaceAssignmentTopic.getId());
                        log.info("Created new Membership for " + usernameTopic.getSimpleValue().toString() + " in workspace=" + SignupPlugin.this.customWorkspaceAssignmentTopic.getSimpleValue().toString());
                    }
                    return eMailAddress;
                }
            });
            log.info("Created new user account for user \"" + username + "\" and " + eMailAddressValue);
            this.sendNotificationMail(username, mailbox.trim());
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException("Creating simple user account failed, username=\"" + username + "\", mailbox=\"" + mailbox + "\"", e);
        }
    }

    @Override
    public boolean isMailboxTaken(String email) {
        String value = email.toLowerCase().trim();
        return this.dmx.getPrivilegedAccess().emailAddressExists(value);
    }

    @Override
    public boolean isUsernameTaken(String username) {
        String value = username.trim();
        Topic userNameTopic = this.accesscontrol.getUsernameTopic(value);
        return userNameTopic != null;
    }

    @Override
    public boolean isValidEmailAddress(String value) {
        return true;
    }

    private void handleAccountCreatedRedirect(String username) throws URISyntaxException {
        if (SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
            log.info("DMX Config: The new account is now ENABLED, redirecting to OK page.");
            throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/" + username + "/ok")).build());
        }
        log.info("DMX Config: The new account is now DISABLED, redirecting to PENDING page.");
        throw new WebApplicationException(Response.temporaryRedirect((URI)new URI("/sign-up/pending")).build());
    }

    private boolean canCreateNewAccount() {
        try {
            this.checkAccountCreation();
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    private void checkAccountCreation() {
        if (this.isAccountCreationWorkspaceUriConfigured()) {
            try {
                this.checkAccountCreationWorkspaceWriteAccess();
            }
            catch (AccessControlException ace) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
            catch (RuntimeException re) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
        } else {
            this.checkAdministrationWorkspaceWriteAccess();
        }
    }

    private void checkAdministrationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.dmx.getPrivilegedAccess().getAdminWorkspaceId()).checkWriteAccess();
    }

    private boolean isAccountCreationWorkspaceUriConfigured() {
        return !SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI.isEmpty();
    }

    private void checkAccountCreationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.workspaces.getWorkspace(SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI).getId()).checkWriteAccess();
    }

    private boolean isApiWorkspaceMember() {
        String username = this.accesscontrol.getUsername();
        if (username != null) {
            String apiWorkspaceUri = this.activeModuleConfiguration.getApiWorkspaceUri();
            if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
                Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
                if (apiWorkspace != null) {
                    return this.accesscontrol.isMember(username, apiWorkspace.getId());
                }
            } else {
                Topic usernameTopic = this.accesscontrol.getUsernameTopic();
                Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
                Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
                if (requestRelation != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void sendUserValidationToken(String username, String password, String mailbox) {
        String tokenKey = this.createUserValidationToken(username, password, mailbox);
        this.sendConfirmationMail(tokenKey, username, mailbox.trim());
    }

    private void sendPasswordResetToken(String mailbox, String displayName, String redirectUrl) {
        String username = this.dmx.getPrivilegedAccess().getUsername(mailbox);
        String tokenKey = this.createPasswordResetToken(username, mailbox, displayName, redirectUrl);
        this.sendPasswordResetMail(tokenKey, username, mailbox.trim(), displayName);
    }

    private String createUserValidationToken(String username, String password, String mailbox) {
        try {
            String tokenKey = UUID.randomUUID().toString();
            long valid = new Date().getTime() + 86400000L;
            JSONObject tokenValue = new JSONObject().put("username", (Object)username.trim()).put("mailbox", (Object)mailbox.trim()).put("password", (Object)password).put("expiration", valid);
            this.token.put(tokenKey, tokenValue);
            log.log(Level.INFO, "Set up key {0} for {1} sending confirmation mail valid till {3}", new Object[]{tokenKey, mailbox, new Date(valid).toString()});
            return tokenKey;
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private String createPasswordResetToken(String username, String mailbox, String name, String redirectUrl) {
        try {
            String tokenKey = UUID.randomUUID().toString();
            long valid = new Date().getTime() + 86400000L;
            JSONObject tokenValue = new JSONObject().put("username", (Object)username.trim()).put("mailbox", (Object)mailbox.trim()).put("name", (Object)(name != null ? name.trim() : "")).put("expiration", valid).put("redirectUrl", (Object)redirectUrl);
            this.pwToken.put(tokenKey, tokenValue);
            log.log(Level.INFO, "Set up pwToken {0} for {1} send passwort reset mail valid till {3}", new Object[]{tokenKey, mailbox, new Date(valid).toString()});
            return tokenKey;
        }
        catch (JSONException ex) {
            Logger.getLogger(SignupPlugin.class.getName()).log(Level.SEVERE, null, ex);
            throw new RuntimeException(ex);
        }
    }

    private void createApiMembershipRequestNoteAssociation(Topic usernameTopic, Topic membershipNote) {
        Assoc apiRequest = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(membershipNote.getId(), "dmx.core.default")));
        this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)apiRequest, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
        log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
        this.sendSystemMailboxNotification("API Usage Requested", "<br>Hi admin,<br><br>" + usernameTopic.getSimpleValue().toString() + " accepted the Terms of Service for API Usage.<br><br>Just wanted to let you know.<br>Cheers!");
    }

    private void createApiWorkspaceMembership(Topic usernameTopic) {
        String apiWorkspaceUri = this.activeModuleConfiguration.getApiWorkspaceUri();
        if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
            Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
            if (apiWorkspace != null) {
                log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                this.accesscontrol.createMembership(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId());
            } else {
                log.info("Revoke Request for API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                if (this.accesscontrol.isMember(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId())) {
                    Assoc assoc = this.getMembershipAssociation(usernameTopic.getId(), apiWorkspace.getId());
                    this.dmx.deleteAssoc(assoc.getId());
                } else {
                    log.info("Skipped Revoke Request for non-existent API Workspace Membership for \"" + usernameTopic.getSimpleValue().toString() + "\"");
                }
            }
        } else {
            log.info("No API Workspace Configured: You must enter the URI of a programmatically created workspace topic into your current \"Signup Configuration\".");
        }
    }

    private void reloadAssociatedSignupConfiguration() {
        this.activeModuleConfiguration = this.getCurrentSignupConfiguration();
        if (!this.activeModuleConfiguration.isValid()) {
            log.warning("Could not load associated Sign-up Plugin Configuration Topic during init/postUpdate");
            return;
        }
        this.activeModuleConfiguration.reload();
        this.customWorkspaceAssignmentTopic = this.activeModuleConfiguration.getCustomWorkspaceAssignmentTopic();
        if (this.customWorkspaceAssignmentTopic != null) {
            log.info("Configured Custom Sign-up Workspace => \"" + this.customWorkspaceAssignmentTopic.getSimpleValue() + "\"");
        }
        log.log(Level.INFO, "Sign-up Configuration Loaded (URI=\"{0}\"), Name=\"{1}\"", new Object[]{this.activeModuleConfiguration.getConfigurationUri(), this.activeModuleConfiguration.getConfigurationName()});
    }

    private void sendConfirmationMail(String key, String username, String mailbox) {
        block5: {
            try {
                String webAppTitle = this.activeModuleConfiguration.getWebAppTitle();
                URL url = new URL(SignUpConfigOptions.DMX_HOST_URL);
                log.info("The confirmation mails token request URL should be:\n" + url + "sign-up/confirm/" + key);
                String mailSubject = this.rb.getString("mail_confirmation_subject") + " - " + webAppTitle;
                try {
                    String linkHref = "<a href=\"" + url + "sign-up/confirm/" + key + "\">" + this.rb.getString("mail_confirmation_link_label") + "</a>";
                    if (SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
                        this.sendSystemMail(mailSubject, this.rb.getString("mail_hello") + " " + username + ",<br><br>" + this.rb.getString("mail_confirmation_active_body") + "<br><br>" + linkHref + "<br><br>" + this.rb.getString("mail_ciao"), mailbox);
                        break block5;
                    }
                    this.sendSystemMail(mailSubject, this.rb.getString("mail_hello") + " " + username + ",<br><br>" + this.rb.getString("mail_confirmation_proceed_1") + "<br>" + linkHref + "<br><br>" + this.rb.getString("mail_confirmation_proceed_2") + "<br><br>" + this.rb.getString("mail_ciao"), mailbox);
                }
                catch (Exception ex) {
                    log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out the \"Email Confirmation\" mail, caused by: " + ex.getMessage());
                }
            }
            catch (MalformedURLException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private void sendPasswordResetMail(String key, String username, String mailbox, String displayName) {
        try {
            String webAppTitle = this.activeModuleConfiguration.getWebAppTitle();
            URL url = new URL(SignUpConfigOptions.DMX_HOST_URL);
            log.info("The password reset mails token request URL should be:\n" + url + "sign-up/password-reset/" + key);
            String href = url + "sign-up/password-reset/" + key;
            try {
                String addressee = username;
                if (displayName != null && !displayName.isEmpty()) {
                    addressee = displayName;
                }
                this.sendSystemMail(this.rb.getString("mail_pw_reset_title") + " " + webAppTitle, this.rb.getString("mail_hello") + "!<br><br>" + this.rb.getString("mail_pw_reset_body") + "<br><a href=\"" + href + "\">" + href + "</a><br><br>" + this.rb.getString("mail_cheers") + "<br>" + this.rb.getString("mail_signature"), mailbox);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out the \"Password Reset\" mail, caused by: " + ex.getMessage());
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendNotificationMail(String username, String mailbox) {
        String webAppTitle = this.activeModuleConfiguration.getWebAppTitle();
        if (SignUpConfigOptions.CONFIG_ADMIN_MAILBOX != null && !SignUpConfigOptions.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            String adminMailbox = SignUpConfigOptions.CONFIG_ADMIN_MAILBOX;
            try {
                this.sendSystemMail("Account registration on " + webAppTitle, "<br>A user has registered.<br><br>Username: " + username + "<br>Email: " + mailbox, adminMailbox);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED notifying the \"system mailbox\" about account creation, caused by: " + ex.getMessage());
            }
        } else {
            log.info("ADMIN: No \"Admin Mailbox\" configured: A new user account (" + username + ") was created but no notification could be sent.");
        }
    }

    private void sendSystemMail(String subject, String message, String recipientValues) {
        String projectName = this.activeModuleConfiguration.getProjectTitle();
        String sender = SignUpConfigOptions.CONFIG_FROM_MAILBOX;
        String mailBody = message;
        this.sendmail.doEmailRecipientAs(sender, projectName, subject, mailBody, recipientValues);
    }

    private Assoc getDefaultAssociation(long topic1, long topic2) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", topic1, topic2, "dmx.core.default", "dmx.core.default");
    }

    private Assoc getMembershipAssociation(long id, long idTwo) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.accesscontrol.membership", id, idTwo, "dmx.core.default", "dmx.core.default");
    }

    private void loadPluginLanguageProperty() {
        String signupPropertyLanguageValue = null;
        try {
            Properties allProperties = new Properties();
            allProperties.load(this.getStaticResource("/plugin.properties"));
            signupPropertyLanguageValue = allProperties.getProperty("dmx.signup.language");
            if (signupPropertyLanguageValue == null || signupPropertyLanguageValue.toLowerCase().equals("en")) {
                log.info("Sign-up Plugin Language option sets labels to ENGLISH");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.ENGLISH);
            } else if (signupPropertyLanguageValue.toLowerCase().equals("de")) {
                log.info("Sign-up Plugin Language \"" + signupPropertyLanguageValue + "\" sets labels to GERMAN");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.GERMAN);
            } else if (signupPropertyLanguageValue.toLowerCase().equals("fr")) {
                log.info("Sign-up Plugin Language \"" + signupPropertyLanguageValue + "\" sets labels to FRENCH");
                this.rb = ResourceBundle.getBundle("SignupMessages", Locale.FRENCH);
            }
        }
        catch (IOException ex) {
            log.warning("Could not find Sign-up plugin properties - use default resource bundle for labels");
            this.rb = ResourceBundle.getBundle("SignupMessages", Locale.ENGLISH);
        }
    }

    private ModuleConfiguration getCurrentSignupConfiguration() {
        return new ModuleConfiguration(this.dmx.getTopicByUri("dmx.signup.default_configuration"));
    }

    private List<String> getAuthorizationMethods() {
        HashMap<String, String> knownAms = new HashMap<String, String>();
        HashSet<String> originalAms = new HashSet<String>(this.accesscontrol.getAuthorizationMethods());
        originalAms.add("Basic");
        for (String s : originalAms) {
            knownAms.put(s.toLowerCase(), s);
        }
        ArrayList<String> filteredRestrictedAms = new ArrayList<String>();
        if (SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS.trim().length() > 0) {
            for (String s : SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS.split(",")) {
                String trimmedLowercase = s.trim().toLowerCase();
                String value = (String)knownAms.get(trimmedLowercase);
                if (value == null) continue;
                filteredRestrictedAms.add(value);
            }
        } else {
            filteredRestrictedAms.addAll(originalAms);
        }
        return filteredRestrictedAms;
    }

    private void prepareSignupPage(String templateName) {
        if (this.activeModuleConfiguration.isValid()) {
            this.dmx.fireEvent(SIGNUP_RESOURCE_REQUESTED, new Object[]{this.context(), templateName});
            this.viewData("authorization_methods", this.getAuthorizationMethods());
            this.viewData("authorization_method_is_ldap", this.isLdapAccountCreationEnabled());
            this.viewData("self_registration_enabled", SignUpConfigOptions.CONFIG_SELF_REGISTRATION);
            this.viewData("title", this.activeModuleConfiguration.getWebAppTitle());
            this.viewData("logo_path", this.activeModuleConfiguration.getLogoPath());
            this.viewData("css_path", this.activeModuleConfiguration.getCssPath());
            this.viewData("project_name", this.activeModuleConfiguration.getProjectTitle());
            this.viewData("read_more_url", this.activeModuleConfiguration.getReadMoreUrl());
            this.viewData("tos_label", this.activeModuleConfiguration.getTosLabel());
            this.viewData("tos_details", this.activeModuleConfiguration.getTosDetails());
            this.viewData("pd_label", this.activeModuleConfiguration.getPdLabel());
            this.viewData("pd_details", this.activeModuleConfiguration.getPdDetails());
            this.viewData("footer", this.activeModuleConfiguration.getPagesFooter());
            this.viewData("custom_workspace_enabled", this.activeModuleConfiguration.getApiEnabled());
            this.viewData("custom_workspace_description", this.activeModuleConfiguration.getApiDescription());
            this.viewData("custom_workspace_details", this.activeModuleConfiguration.getApiDetails());
            this.viewData("custom_workspace_uri", this.activeModuleConfiguration.getApiWorkspaceUri());
            this.viewData("start_url", this.activeModuleConfiguration.getStartUrl());
            this.viewData("visit_start_url", this.rb.getString("visit_start_url"));
            this.viewData("home_url", this.activeModuleConfiguration.getHomeUrl());
            this.viewData("visit_home_url", this.rb.getString("visit_home_url"));
            this.viewData("loading_app_hint", this.activeModuleConfiguration.getLoadingAppHint());
            this.viewData("logging_out_hint", this.activeModuleConfiguration.getLoggingOutHint());
            this.viewData("password_length_hint", this.rb.getString("password_length_hint"));
            this.viewData("password_match_hint", this.rb.getString("password_match_hint"));
            this.viewData("check_terms_hint", this.rb.getString("check_terms_hint"));
            this.viewData("username_invalid_hint", this.rb.getString("username_invalid_hint"));
            this.viewData("username_taken_hint", this.rb.getString("username_taken_hint"));
            this.viewData("email_invalid_hint", this.rb.getString("email_invalid_hint"));
            this.viewData("email_taken_hint", this.rb.getString("email_taken_hint"));
            this.viewData("not_authorized_message", this.rb.getString("not_authorized_message"));
            this.viewData("signup_title", this.rb.getString("signup_title"));
            this.viewData("create_account", this.rb.getString("create_account"));
            this.viewData("login_title", this.rb.getString("login_title"));
            this.viewData("log_in_small", this.rb.getString("log_in_small"));
            this.viewData("login", this.rb.getString("login"));
            this.viewData("or_label", this.rb.getString("or_label"));
            this.viewData("logout", this.rb.getString("logout"));
            this.viewData("logged_in_as", this.rb.getString("logged_in_as"));
            this.viewData("label_username", this.rb.getString("label_username"));
            this.viewData("label_name", this.rb.getString("label_name"));
            this.viewData("label_email", this.rb.getString("label_email"));
            this.viewData("label_password", this.rb.getString("label_password"));
            this.viewData("label_password_repeat", this.rb.getString("label_password_repeat"));
            this.viewData("read_more", this.rb.getString("read_more"));
            this.viewData("label_forgot_password", this.rb.getString("forgot_password"));
            this.viewData("label_reset_password", this.rb.getString("reset_password"));
            this.viewData("label_reset_password_submit", this.rb.getString("reset_password_submit"));
            this.viewData("info_reset_password", this.rb.getString("reset_password_hint"));
            this.viewData("password_reset_ok_message", this.rb.getString("password_reset_success_1"));
            this.viewData("your_account_title", this.rb.getString("your_account_title"));
            this.viewData("your_account_heading", this.rb.getString("your_account_heading"));
            this.viewData("your_account_username_label", this.rb.getString("your_account_username_label"));
            this.viewData("your_account_email_label", this.rb.getString("your_account_email_label"));
            this.viewData("api_option_title", this.rb.getString("api_option_title"));
            this.viewData("api_option_descr", this.rb.getString("api_option_descr"));
            this.viewData("api_option_revoke", this.rb.getString("api_option_revoke"));
            this.viewData("api_workspace_member", this.isApiWorkspaceMember());
            this.viewData("api_email_contact", this.systemEmailContact == null ? "" : this.systemEmailContact);
            this.viewData("api_contact_revoke", this.rb.getString("api_contact_revoke"));
            this.viewData("created_page_title", this.rb.getString("page_account_created_title"));
            this.viewData("created_page_body_1", this.rb.getString("page_account_created_body_1"));
            this.viewData("created_page_body_2", this.rb.getString("page_account_created_body_2"));
            this.viewData("created_page_body_3", this.rb.getString("page_account_created_body_3"));
            this.viewData("created_page_body_4", this.rb.getString("page_account_created_body_4"));
            this.viewData("requested_page_title", this.rb.getString("page_account_requested_title"));
            this.viewData("requested_page_1", this.rb.getString("page_account_requested_1"));
            this.viewData("requested_page_2", this.rb.getString("page_account_requested_2"));
            this.viewData("requested_page_3", this.rb.getString("page_account_requested_3"));
            String username = this.accesscontrol.getUsername();
            this.viewData("email_confirmation_active", SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION);
            this.viewData("skip_confirmation_mail_label", this.rb.getString("admin_skip_email_confirmation_mail"));
            this.viewData("can_create_new_account", this.canCreateNewAccount());
            this.viewData("authenticated", username != null);
            this.viewData("username", username);
            this.viewData("template", templateName);
            this.viewData("hostUrl", SignUpConfigOptions.DMX_HOST_URL);
        } else {
            log.severe("Could not load module configuration of sign-up plugin during page preparation!");
        }
    }

    private void prepareAccountEditPage() {
        String username = this.accesscontrol.getUsername();
        if (username != null) {
            String eMailAddressValue = "None";
            try {
                eMailAddressValue = this.dmx.getPrivilegedAccess().getEmailAddress(username);
            }
            catch (Exception e) {
                log.warning("Username has no Email Address topic related via \"dmx.base.user_mailbox\"");
            }
            this.viewData("logged_in", true);
            this.viewData("username", username);
            this.viewData("display_name", this.getDisplayName(username));
            this.viewData("email", eMailAddressValue);
            this.viewData("link", "");
        } else {
            this.viewData("logged_in", false);
            this.viewData("username", "Not logged in");
            this.viewData("email", "Not logged in");
            this.viewData("link", "/sign-up/login");
        }
    }

    @Override
    public void reinitTemplateEngine() {
        super.initTemplateEngine();
    }

    @Override
    public void addTemplateResolverBundle(Bundle bundle) {
        super.addTemplateResourceBundle(bundle);
    }

    @Override
    public void removeTemplateResolverBundle(Bundle bundle) {
        super.removeTemplateResourceBundle(bundle);
    }
}

