/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.configuration;

import systems.dmx.core.Topic;

public class ModuleConfiguration {
    private final Topic topic;

    public ModuleConfiguration(Topic topic) {
        this.topic = topic;
    }

    public String getConfigurationUri() {
        return this.topic.getUri();
    }

    public String getConfigurationName() {
        return this.topic.getSimpleValue().toString();
    }

    public boolean isValid() {
        return this.topic != null;
    }

    public void reload() {
        this.topic.loadChildTopics();
    }

    private String getString(String key) {
        return this.topic.getChildTopics().getString(key);
    }

    private boolean getBoolean(String key) {
        return this.topic.getChildTopics().getBoolean(key);
    }

    public String getProjectTitle() {
        return this.getString("dmx.signup.config_project_title");
    }

    public String getWebAppTitle() {
        return this.getString("dmx.signup.config_webapp_title");
    }

    public String getLogoPath() {
        return this.getString("dmx.signup.config_webapp_logo_path");
    }

    public String getCssPath() {
        return this.getString("dmx.signup.config_custom_css_path");
    }

    public String getReadMoreUrl() {
        return this.getString("dmx.signup.config_read_more_url");
    }

    public String getTosLabel() {
        return this.getString("dmx.signup.config_tos_label");
    }

    public String getTosDetails() {
        return this.getString("dmx.signup.config_tos_detail");
    }

    public String getPdLabel() {
        return this.getString("dmx.signup.config_pd_label");
    }

    public String getPdDetails() {
        return this.getString("dmx.signup.config_pd_detail");
    }

    public String getPagesFooter() {
        return this.getString("dmx.signup.config_pages_footer");
    }

    public Boolean getApiEnabled() {
        return this.getBoolean("dmx.signup.config_api_enabled");
    }

    public String getApiDescription() {
        return this.getString("dmx.signup.config_api_description");
    }

    public String getApiDetails() {
        return this.getString("dmx.signup.config_api_details");
    }

    public String getApiWorkspaceUri() {
        return this.getString("dmx.signup.config_api_workspace_uri");
    }

    public String getStartUrl() {
        return this.getString("dmx.signup.start_page_url");
    }

    public String getHomeUrl() {
        return this.getString("dmx.signup.home_page_url");
    }

    public String getLoadingAppHint() {
        return this.getString("dmx.signup.loading_app_hint");
    }

    public String getLoggingOutHint() {
        return this.getString("dmx.signup.logging_out_hint");
    }

    public Topic getCustomWorkspaceAssignmentTopic() {
        return this.topic.getRelatedTopic("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }
}

