/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup;

import com.sun.jersey.core.util.Base64;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.codehaus.jettison.json.JSONObject;
import org.osgi.framework.BundleContext;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.ChangeReport;
import systems.dmx.core.service.DMXEvent;
import systems.dmx.core.service.EventListener;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.core.service.accesscontrol.Credentials;
import systems.dmx.core.service.event.PostUpdateTopic;
import systems.dmx.core.storage.spi.DMXTransaction;
import systems.dmx.facets.FacetsService;
import systems.dmx.ldap.service.LDAPPluginService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.EmailTextProducer;
import systems.dmx.signup.InitiatePasswordResetRequestResult;
import systems.dmx.signup.InternalEmailTextProducer;
import systems.dmx.signup.OptionalService;
import systems.dmx.signup.PasswordChangeRequestResult;
import systems.dmx.signup.PasswordResetRequestResult;
import systems.dmx.signup.ProcessSignUpRequestResult;
import systems.dmx.signup.SignUpRequestResult;
import systems.dmx.signup.SignupService;
import systems.dmx.signup.UserAccountCreateListener;
import systems.dmx.signup.configuration.AccountCreation;
import systems.dmx.signup.configuration.ModuleConfiguration;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup.mapper.IsValidEmailAdressMapper;
import systems.dmx.signup.mapper.NewAccountDataMapper;
import systems.dmx.signup.model.NewAccountData;
import systems.dmx.signup.model.NewAccountToken;
import systems.dmx.signup.model.PasswordResetToken;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/sign-up")
@Produces(value={"application/json"})
public class SignupPlugin
extends PluginActivator
implements SignupService,
PostUpdateTopic {
    private static final Logger log = Logger.getLogger(SignupPlugin.class.getName());
    private ModuleConfiguration activeModuleConfiguration = null;
    private Topic customWorkspaceAssignmentTopic = null;
    private String systemEmailContact = null;
    @Inject
    private AccessControlService accesscontrol;
    @Inject
    private FacetsService facets;
    @Inject
    private SendmailService sendmail;
    @Inject
    private WorkspacesService workspaces;
    private OptionalService<LDAPPluginService> ldapPluginService;
    @Context
    UriInfo uri;
    HashMap<String, NewAccountToken> newAccountTokens = new HashMap();
    HashMap<String, PasswordResetToken> passwordResetTokens = new HashMap();
    EmailTextProducer emailTextProducer = new InternalEmailTextProducer();
    private NewAccountDataMapper newAccountDataMapper = new NewAccountDataMapper();
    private IsValidEmailAdressMapper isValidEmailAdressMapper = new IsValidEmailAdressMapper();
    static DMXEvent USER_ACCOUNT_CREATE_LISTENER = new DMXEvent(UserAccountCreateListener.class){

        public void dispatch(EventListener listener, Object ... params) {
            ((UserAccountCreateListener)listener).userAccountCreated((Topic)params[0]);
        }
    };

    public void init() {
        this.initOptionalServices();
        this.reloadAssociatedSignupConfiguration();
        log.info("\n  dmx.signup.account_creation: " + (Object)((Object)SignUpConfigOptions.CONFIG_ACCOUNT_CREATION) + "\n  dmx.signup.account_creation_password_handling: " + (Object)((Object)SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_PASSWORD_HANDLING) + "\n  dmx.signup.username_policy: " + (Object)((Object)SignUpConfigOptions.CONFIG_USERNAME_POLICY) + "\n  dmx.signup.confirm_email_address: " + SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION + "\n  dmx.signup.admin_mailbox: " + SignUpConfigOptions.CONFIG_ADMIN_MAILBOX + "\n  dmx.signup.system_mailbox: " + SignUpConfigOptions.CONFIG_FROM_MAILBOX + "\n  dmx.signup.ldap_account_creation: " + SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS + "\n  dmx.signup.account_creation_auth_ws_uri: " + SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI + "\n  dmx.signup.restrict_auth_methods: " + SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS + "\n  dmx.signup.token_expiration_time: " + SignUpConfigOptions.CONFIG_TOKEN_EXPIRATION_DURATION.toHours() + "\n");
        log.info("Available auth methods and order:" + this.getAuthorizationMethods() + "\n");
        if (SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS && !this.isLdapPluginAvailable()) {
            log.warning("LDAP Account creation configured but respective plugin not available!");
        }
    }

    public void stop(BundleContext context) {
        this.ldapPluginService.release();
        super.stop(context);
    }

    @Override
    public void setEmailTextProducer(EmailTextProducer emailTextProducer) {
        if (emailTextProducer == null) {
            throw new IllegalArgumentException("New instance cannot be null");
        }
        this.emailTextProducer = emailTextProducer;
    }

    @Override
    public String getSystemEmailContactOrEmpty() {
        return this.systemEmailContact == null ? "" : this.systemEmailContact;
    }

    private void initOptionalServices() {
        this.ldapPluginService = new OptionalService(this.getBundleContext(), () -> LDAPPluginService.class);
    }

    @Override
    @GET
    @Path(value="/display-name/{username}")
    public String getDisplayName(@PathParam(value="username") String username) {
        try {
            RelatedTopic displayName;
            Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
            if (usernameTopic != null && (displayName = this.facets.getFacet((DMXObject)usernameTopic, "dmx.signup.display_name_facet")) != null) {
                return displayName.getSimpleValue().toString();
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Fetching display name of user \"" + username + "\" failed", e);
        }
    }

    @Override
    @PUT
    @Path(value="/display-name/{username}")
    @Transactional
    public void updateDisplayName(@PathParam(value="username") String username, @QueryParam(value="displayName") String displayName) {
        try {
            long workspaceId = this.getDisplayNamesWorkspaceId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(workspaceId, () -> {
                Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
                if (usernameTopic != null) {
                    this.facets.updateFacet((DMXObject)usernameTopic, "dmx.signup.display_name_facet", this.mf.newFacetValueModel("dmx.signup.display_name").set((Object)displayName));
                }
                return null;
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Updating display name of user \"" + username + "\" failed, displayName=\"" + displayName + "\"", e);
        }
    }

    @GET
    @Path(value="/check/mailbox/{email}")
    public String getMailboxAvailability(@PathParam(value="email") String email) {
        JSONObject response = new JSONObject();
        try {
            response.put("isAvailable", true);
            if (this.isEmailAddressTaken(email)) {
                response.put("isAvailable", false);
            }
            return response.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private NewAccountData mapToNewAccountData(String username, String mailbox, String displayName) {
        return this.newAccountDataMapper.map(SignUpConfigOptions.CONFIG_USERNAME_POLICY, username, mailbox, displayName);
    }

    @Override
    public SignUpRequestResult requestSignUp(String username, String mailbox, String displayName, String password, boolean skipConfirmation) {
        if (!this.isSelfRegistrationEnabled() && !this.hasAccountCreationPrivilege()) {
            return new SignUpRequestResult(SignUpRequestResult.Code.ACCOUNT_CREATION_DENIED);
        }
        if (!this.isValidEmailAdressMapper.map(mailbox)) {
            return new SignUpRequestResult(SignUpRequestResult.Code.ERROR_INVALID_EMAIL);
        }
        NewAccountData newAccountData = this.mapToNewAccountData(username, mailbox, displayName);
        try {
            if (SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION) {
                return this.handleSignUpWithEmailConfirmation(newAccountData, password, skipConfirmation);
            }
            return this.handleSignUpWithDirectAccountCreation(newAccountData, password);
        }
        catch (URISyntaxException e) {
            log.log(Level.SEVERE, "Could not build response URI while handling sign-up request", e);
            return new SignUpRequestResult(SignUpRequestResult.Code.UNEXPECTED_ERROR);
        }
    }

    private SignUpRequestResult handleSignUpWithDirectAccountCreation(NewAccountData newAccountData, String password) throws URISyntaxException {
        if (this.isSelfRegistrationEnabled() || this.hasAccountCreationPrivilege()) {
            try {
                this.transactional(() -> this.createCustomUserAccount(newAccountData, password));
            }
            catch (Exception e) {
                return new SignUpRequestResult(SignUpRequestResult.Code.UNEXPECTED_ERROR);
            }
            return this.handleAccountCreatedRedirect(newAccountData.username);
        }
        return new SignUpRequestResult(SignUpRequestResult.Code.ACCOUNT_CREATION_DENIED);
    }

    private SignUpRequestResult handleSignUpWithEmailConfirmation(NewAccountData newAccountData, String password, boolean skipConfirmation) {
        if (skipConfirmation && this.hasAccountCreationPrivilege()) {
            if (SignUpConfigOptions.CONFIG_ACCOUNT_CREATION == AccountCreation.ADMIN) {
                log.info("Sign-up Configuration: Email based confirmation workflow active, Administrator skipping confirmation mail.");
                try {
                    this.transactional(() -> this.createCustomUserAccount(newAccountData, password));
                }
                catch (Exception e) {
                    return new SignUpRequestResult(SignUpRequestResult.Code.UNEXPECTED_ERROR);
                }
                return this.handleAccountCreatedRedirect(newAccountData.username);
            }
            return new SignUpRequestResult(SignUpRequestResult.Code.ADMIN_PRIVILEGE_MISSING);
        }
        log.info("Sign-up Configuration: Email based confirmation workflow active, send out confirmation mail.");
        String tokenKey = this.createUserValidationToken(newAccountData, password);
        this.sendConfirmationMail(tokenKey, newAccountData.displayName, newAccountData.email);
        return new SignUpRequestResult(SignUpRequestResult.Code.SUCCESS_EMAIL_CONFIRMATION_NEEDED);
    }

    private SignUpRequestResult handleAccountCreatedRedirect(String username) {
        if (SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
            log.info("DMX Config: The new account is now ENABLED, redirecting to OK page.");
            return new SignUpRequestResult(SignUpRequestResult.Code.SUCCESS_ACCOUNT_CREATED, username);
        }
        log.info("DMX Config: The new account is now DISABLED, redirecting to PENDING page.");
        return new SignUpRequestResult(SignUpRequestResult.Code.SUCCESS_ACCOUNT_PENDING, username);
    }

    @Override
    public ProcessSignUpRequestResult requestProcessSignUp(String key) {
        NewAccountToken token;
        block7: {
            if (!this.newAccountTokens.containsKey(key)) {
                return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.INVALID_TOKEN);
            }
            token = this.newAccountTokens.remove(key);
            try {
                if (token.expiration.isAfter(Instant.now())) {
                    log.log(Level.INFO, "Trying to create user account for {0}", token.accountData.email);
                    try {
                        this.transactional(() -> this.createCustomUserAccount(token.accountData, token.password));
                        break block7;
                    }
                    catch (Exception e) {
                        return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.UNEXPECTED_ERROR);
                    }
                }
                return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.LINK_EXPIRED);
            }
            catch (RuntimeException ex) {
                log.log(Level.SEVERE, null, ex);
                log.log(Level.SEVERE, "Account creation failed due to {0} caused by {1}", new Object[]{ex.getMessage(), ex.getCause().toString()});
                return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.UNEXPECTED_ERROR);
            }
        }
        log.log(Level.INFO, "Account succesfully created for username: {0}", token.accountData.username);
        if (!SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
            log.log(Level.INFO, "> Account activation by an administrator remains PENDING ");
            return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.SUCCESS_ACCOUNT_PENDING);
        }
        return new ProcessSignUpRequestResult(ProcessSignUpRequestResult.Code.SUCCESS, token.accountData.username);
    }

    @Override
    public InitiatePasswordResetRequestResult requestInitiateRedirectPasswordReset(String email, String redirectUrl) {
        log.info("Password reset requested for user with Email: \"" + email + "\" wishing to redirect to: \"" + redirectUrl + "\"");
        String emailAddressValue = email.trim();
        boolean emailExists = this.dmx.getPrivilegedAccess().emailAddressExists(emailAddressValue);
        if (emailExists) {
            log.info("Email based password reset workflow do'able, sending out passwort reset mail.");
            this.sendPasswordResetToken(emailAddressValue, null, redirectUrl);
            return InitiatePasswordResetRequestResult.SUCCESS;
        }
        log.warning("Email based password reset workflow not do'able, Email Address does NOT EXIST => " + email.trim());
        return InitiatePasswordResetRequestResult.EMAIL_UNKNOWN;
    }

    @Override
    @GET
    @Path(value="/password-reset/{email}")
    public InitiatePasswordResetRequestResult requestInitiatePasswordReset(@PathParam(value="email") String email, @QueryParam(value="name") String displayName) {
        log.info("Password reset requested for user with Email: \"" + email + "\" and Name: \"" + displayName + "\"");
        try {
            String emailAddressValue = email.trim();
            if (!this.isValidEmailAdressMapper.map(emailAddressValue)) {
                return InitiatePasswordResetRequestResult.UNEXPECTED_ERROR;
            }
            boolean emailExists = this.dmx.getPrivilegedAccess().emailAddressExists(emailAddressValue);
            if (emailExists) {
                log.info("Email based password reset workflow do'able, sending out passwort reset mail.");
                this.sendPasswordResetToken(emailAddressValue, displayName, null);
                return InitiatePasswordResetRequestResult.SUCCESS;
            }
            log.info("Email based password reset workflow not do'able, Email Address does NOT EXIST => " + emailAddressValue.trim());
            return InitiatePasswordResetRequestResult.EMAIL_UNKNOWN;
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, null, ex);
            return InitiatePasswordResetRequestResult.UNEXPECTED_ERROR;
        }
    }

    @Override
    @GET
    @Path(value="/token/{key}")
    public PasswordResetRequestResult requestPasswordReset(@PathParam(value="key") String key) {
        if (!this.passwordResetTokens.containsKey(key)) {
            return new PasswordResetRequestResult(PasswordResetRequestResult.Code.INVALID_TOKEN);
        }
        PasswordResetToken token = this.passwordResetTokens.get(key);
        if (token != null && token.expiration.isAfter(Instant.now())) {
            return new PasswordResetRequestResult(PasswordResetRequestResult.Code.SUCCESS, token.accountData.username, token.accountData.email, token.accountData.displayName, token.redirectUrl);
        }
        log.warning("The link to reset the password for " + token.accountData.username + " has expired.");
        this.passwordResetTokens.remove(key);
        return new PasswordResetRequestResult(PasswordResetRequestResult.Code.LINK_EXPIRED);
    }

    @GET
    @Path(value="/self-registration-active")
    public Response getSelfRegistrationStatus() {
        return Response.ok((Object)("" + this.isSelfRegistrationEnabled())).build();
    }

    @Override
    @GET
    @Path(value="/password-reset/{key}/{password}")
    @Transactional
    public PasswordChangeRequestResult requestPasswordChange(@PathParam(value="key") String key, @PathParam(value="password") String password) {
        log.info("Processing Password Update Request Token... ");
        PasswordResetToken token = this.passwordResetTokens.get(key);
        if (token != null) {
            Credentials newCreds = new Credentials("dummy", "pass");
            newCreds.username = token.accountData.username;
            if (!this.isLdapAccountCreationEnabled()) {
                newCreds.password = password;
                this.dmx.getPrivilegedAccess().changePassword(newCreds);
                log.info("Credentials for user " + newCreds.username + " were changed succesfully.");
            } else {
                String plaintextPassword = Base64.base64Decode((String)password);
                log.info("Change password attempt for \"" + newCreds.username + "\".");
                newCreds.plaintextPassword = plaintextPassword;
                newCreds.password = password;
                if (this.ldapPluginService.get().changePassword(newCreds) != null) {
                    log.info("If no previous errors are reported here or in the LDAP-service log, the credentials for user " + newCreds.username + " should now have been changed succesfully.");
                } else {
                    log.severe("Credentials for user " + newCreds.username + " COULD NOT be changed succesfully.");
                    return PasswordChangeRequestResult.PASSWORD_CHANGE_FAILED;
                }
            }
            this.passwordResetTokens.remove(key);
            return PasswordChangeRequestResult.SUCCESS;
        }
        return PasswordChangeRequestResult.NO_TOKEN;
    }

    @Override
    @POST
    @Path(value="/user-account/{username}/{mailbox}/{displayname}/{password}")
    @Transactional
    public Topic createUserAccount(@PathParam(value="username") String username, @PathParam(value="mailbox") String mailbox, @PathParam(value="displayname") String displayName, @PathParam(value="password") String password) {
        log.info("Creating user account with display name \"" + displayName + "\" and email address \"" + mailbox + "\"");
        this.checkAccountCreation();
        Topic usernameTopic = this.createCustomUserAccount(this.mapToNewAccountData(username, mailbox, displayName), password);
        return usernameTopic;
    }

    private Topic createCustomUserAccount(NewAccountData newAccountData, String password) {
        try {
            final String username = this.createSimpleUserAccount(newAccountData.username.trim(), password, newAccountData.email.trim());
            final String displayNameValue = newAccountData.displayName.trim();
            Topic usernameTopic = this.accesscontrol.getUsernameTopic(username);
            final long usernameTopicId = usernameTopic.getId();
            final long displayNamesWorkspaceId = this.getDisplayNamesWorkspaceId();
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(-1L, (Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    SignupPlugin.this.facets.addFacetTypeToTopic(usernameTopicId, "dmx.signup.display_name_facet");
                    SignupPlugin.this.facets.updateFacet(usernameTopicId, "dmx.signup.display_name_facet", SignupPlugin.this.mf.newFacetValueModel("dmx.signup.display_name").set((Object)displayNameValue));
                    SignupPlugin.this.dmx.getPrivilegedAccess().createMembership(username, displayNamesWorkspaceId);
                    log.info("Created membership for new user account in \"Display Names\" workspace (SharingMode.Collaborative)");
                    RelatedTopic result = SignupPlugin.this.facets.getFacet(usernameTopicId, "dmx.signup.display_name_facet");
                    SignupPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)result, displayNamesWorkspaceId);
                    return result;
                }
            });
            return usernameTopic;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Unable to create custom account", e);
            throw new RuntimeException("Creating custom user account failed, mailbox=\"" + newAccountData.email + "\", displayName=\"" + newAccountData.displayName + "\"", e);
        }
    }

    public long getDisplayNamesWorkspaceId() {
        Topic ws = this.workspaces.getWorkspace("dmx.signup.display_names_ws");
        return ws != null ? ws.getId() : -1L;
    }

    @Override
    @POST
    @Path(value="/confirm/membership/custom")
    @Transactional
    public String createAPIWorkspaceMembershipRequest() {
        Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
        if (apiMembershipRequestNote != null && this.accesscontrol.getUsername() != null) {
            Topic usernameTopic = this.accesscontrol.getUsernameTopic();
            this.createApiWorkspaceMembership(usernameTopic);
            Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
            if (requestRelation == null) {
                this.createApiMembershipRequestNoteAssociation(usernameTopic, apiMembershipRequestNote);
            } else {
                String username = usernameTopic.getSimpleValue().toString();
                log.info("Revoke Request for API Workspace Membership by user \"" + username + "\"");
                String api_usage_revoked = this.emailTextProducer.getApiUsageRevokedMailSubject();
                String message = this.emailTextProducer.getApiUsageRevokedMailText(username);
                this.sendSystemMailboxNotification(api_usage_revoked, message);
            }
            return "{ \"membership_created\" : true}";
        }
        return "{ \"membership_created\" : false}";
    }

    public void postUpdateTopic(Topic topic, ChangeReport report, TopicModel updateModel) {
        if (topic.getTypeUri().equals("dmx.signup.configuration")) {
            this.reloadAssociatedSignupConfiguration();
        } else if (topic.getTypeUri().equals("dmx.accesscontrol.login_enabled")) {
            boolean status = Boolean.parseBoolean(topic.getSimpleValue().toString());
            RelatedTopic username = topic.getRelatedTopic("dmx.config.configuration", null, null, "dmx.accesscontrol.username");
            if (status && !SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
                log.info("Sign-up Notification: User Account \"" + username.getSimpleValue() + "\" is now ENABLED!");
                RelatedTopic mailbox = username.getRelatedTopic("dmx.base.user_mailbox", null, null, "dmx.contacts.email_address");
                if (mailbox != null) {
                    String mailboxValue = mailbox.getSimpleValue().toString();
                    String subject = this.emailTextProducer.getAccountActiveEmailSubject();
                    String message = this.emailTextProducer.getAccountActiveEmailMessage(username.toString());
                    this.sendMail(subject, message, mailboxValue);
                    log.info("Send system notification mail to " + mailboxValue + " - The account is now active!");
                }
            }
        }
    }

    @Override
    public Boolean isLoggedIn() {
        return this.accesscontrol.getUsername() != null;
    }

    private void sendSystemMailboxNotification(String subject, String message) {
        if (!SignUpConfigOptions.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            String recipient = SignUpConfigOptions.CONFIG_ADMIN_MAILBOX;
            try {
                this.sendMail(subject, message, recipient);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out a notification mail to the \"System Mailbox\", caused by: " + ex.getMessage());
            }
        } else {
            log.info("Did not send notification mail to System Mailbox - Admin Mailbox Empty");
        }
    }

    private void sendUserMailboxNotification(String mailbox, String subject, String message) {
        try {
            this.sendMail(subject, message, mailbox);
        }
        catch (Exception ex) {
            log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out a notification mail to User \"" + mailbox + "\", caused by: " + ex.getMessage());
        }
    }

    private boolean isLdapPluginAvailable() {
        try {
            return this.ldapPluginService.get() != null;
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
    }

    @Override
    public boolean isLdapAccountCreationEnabled() {
        return SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS && this.isLdapPluginAvailable();
    }

    private boolean isAccountCreationPasswordEditable() {
        return SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_PASSWORD_HANDLING == AccountCreation.PasswordHandling.EDITABLE;
    }

    private Topic createUsername(Credentials credentials) throws Exception {
        if (this.isLdapAccountCreationEnabled()) {
            return this.ldapPluginService.get().createUser(credentials);
        }
        return this.accesscontrol._createUserAccount(credentials);
    }

    private String createSimpleUserAccount(String username, String password, String mailbox) {
        try {
            Credentials creds;
            if (this.isUsernameTaken(username)) {
                throw new RuntimeException("Username \"" + username + "\" was already registered and confirmed");
            }
            if (!this.isLdapAccountCreationEnabled()) {
                creds = new Credentials(new JSONObject().put("username", (Object)username.trim()).put("password", (Object)password.trim()));
            } else {
                String plaintextPassword = Base64.base64Decode((String)password);
                creds = new Credentials(username.trim(), plaintextPassword);
                creds.plaintextPassword = plaintextPassword;
            }
            final Topic usernameTopic = this.createUsername(creds);
            final String eMailAddressValue = mailbox;
            this.dmx.getPrivilegedAccess().runInWorkspaceContext(-1L, (Callable)new Callable<Topic>(){

                @Override
                public Topic call() {
                    long systemWorkspaceId = SignupPlugin.this.dmx.getPrivilegedAccess().getSystemWorkspaceId();
                    Topic eMailAddress = SignupPlugin.this.dmx.createTopic(SignupPlugin.this.mf.newTopicModel("dmx.contacts.email_address", new SimpleValue(eMailAddressValue)));
                    SignupPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)eMailAddress, systemWorkspaceId);
                    SignupPlugin.this.dmx.fireEvent(USER_ACCOUNT_CREATE_LISTENER, new Object[]{usernameTopic});
                    Assoc assoc = SignupPlugin.this.dmx.createAssoc(SignupPlugin.this.mf.newAssocModel("dmx.base.user_mailbox", (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(eMailAddress.getId(), "dmx.core.child"), (PlayerModel)SignupPlugin.this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.parent")));
                    SignupPlugin.this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)assoc, systemWorkspaceId);
                    if (SignupPlugin.this.customWorkspaceAssignmentTopic != null) {
                        SignupPlugin.this.accesscontrol.createMembership(usernameTopic.getSimpleValue().toString(), SignupPlugin.this.customWorkspaceAssignmentTopic.getId());
                        log.info("Created new Membership for " + usernameTopic.getSimpleValue().toString() + " in workspace=" + SignupPlugin.this.customWorkspaceAssignmentTopic.getSimpleValue().toString());
                    }
                    return eMailAddress;
                }
            });
            log.info("Created new user account for user \"" + username + "\" and " + eMailAddressValue);
            this.sendNotificationMail(username, mailbox.trim());
            return username;
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Creating simple user account failed", e);
            throw new RuntimeException("Creating simple user account failed, username=\"" + username + "\", mailbox=\"" + mailbox + "\"", e);
        }
    }

    @Override
    public boolean isEmailAddressTaken(String email) {
        String value = email.toLowerCase().trim();
        return this.dmx.getPrivilegedAccess().emailAddressExists(value);
    }

    @Override
    @GET
    @Path(value="/username/{username}/taken")
    public boolean isUsernameTaken(@PathParam(value="username") String username) {
        return this.accesscontrol.getUsernameTopic(username.trim()) != null;
    }

    @Override
    public boolean isSelfRegistrationEnabled() {
        return SignUpConfigOptions.CONFIG_ACCOUNT_CREATION == AccountCreation.PUBLIC;
    }

    @Override
    public boolean hasAccountCreationPrivilege() {
        try {
            this.checkAccountCreation();
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    private void checkAccountCreation() {
        if (this.isAccountCreationWorkspaceUriConfigured()) {
            try {
                this.checkAccountCreationWorkspaceWriteAccess();
            }
            catch (AccessControlException ace) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
            catch (RuntimeException re) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
        } else {
            this.checkAdministrationWorkspaceWriteAccess();
        }
    }

    private void checkAdministrationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.dmx.getPrivilegedAccess().getAdminWorkspaceId()).checkWriteAccess();
    }

    private boolean isAccountCreationWorkspaceUriConfigured() {
        return !SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI.isEmpty();
    }

    private void checkAccountCreationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.workspaces.getWorkspace(SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI).getId()).checkWriteAccess();
    }

    @Override
    public boolean isApiWorkspaceMember() {
        String username = this.accesscontrol.getUsername();
        if (username != null) {
            String apiWorkspaceUri = this.activeModuleConfiguration.getApiWorkspaceUri();
            if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
                Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
                if (apiWorkspace != null) {
                    return this.accesscontrol.isMember(username, apiWorkspace.getId());
                }
            } else {
                Topic usernameTopic = this.accesscontrol.getUsernameTopic();
                Topic apiMembershipRequestNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
                Assoc requestRelation = this.getDefaultAssociation(usernameTopic.getId(), apiMembershipRequestNote.getId());
                if (requestRelation != null) {
                    return true;
                }
            }
        }
        return false;
    }

    private void sendPasswordResetToken(String mailbox, String displayName, String redirectUrl) {
        String username = this.dmx.getPrivilegedAccess().getUsername(mailbox);
        String tokenKey = this.createPasswordResetToken(username, mailbox, displayName, redirectUrl);
        this.sendPasswordResetMail(tokenKey, username, mailbox.trim(), displayName);
    }

    private String createUserValidationToken(NewAccountData newAccountData, String password) {
        String tokenKey = UUID.randomUUID().toString();
        Instant expiration = this.calculateTokenExpiration();
        NewAccountToken token = new NewAccountToken(newAccountData, password, expiration);
        this.newAccountTokens.put(tokenKey, token);
        log.log(Level.INFO, "Set up key {0} for {1} sending confirmation mail valid till {3}", new Object[]{tokenKey, newAccountData.email, expiration});
        return tokenKey;
    }

    private Instant calculateTokenExpiration() {
        return Instant.now().plus(SignUpConfigOptions.CONFIG_TOKEN_EXPIRATION_DURATION);
    }

    private String createPasswordResetToken(String username, String mailbox, String name, String redirectUrl) {
        String tokenKey = UUID.randomUUID().toString();
        Instant expiration = this.calculateTokenExpiration();
        PasswordResetToken token = new PasswordResetToken(new NewAccountData(username, mailbox, name), expiration, redirectUrl);
        this.passwordResetTokens.put(tokenKey, token);
        log.log(Level.INFO, "Set up pwToken {0} for {1} send passwort reset mail valid till {3}", new Object[]{tokenKey, mailbox, expiration});
        return tokenKey;
    }

    private void createApiMembershipRequestNoteAssociation(Topic usernameTopic, Topic membershipNote) {
        Assoc apiRequest = this.dmx.createAssoc(this.mf.newAssocModel("dmx.core.association", (PlayerModel)this.mf.newTopicPlayerModel(usernameTopic.getId(), "dmx.core.default"), (PlayerModel)this.mf.newTopicPlayerModel(membershipNote.getId(), "dmx.core.default")));
        this.dmx.getPrivilegedAccess().assignToWorkspace((DMXObject)apiRequest, this.dmx.getPrivilegedAccess().getSystemWorkspaceId());
        log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
        String subject = this.emailTextProducer.getApiUsageRequestedSubject();
        String message = this.emailTextProducer.getApiUsageRequestedMessage(usernameTopic.getSimpleValue().toString());
        this.sendSystemMailboxNotification(subject, message);
    }

    private void createApiWorkspaceMembership(Topic usernameTopic) {
        String apiWorkspaceUri = this.activeModuleConfiguration.getApiWorkspaceUri();
        if (!apiWorkspaceUri.isEmpty() && !apiWorkspaceUri.equals("undefined")) {
            Topic apiWorkspace = this.dmx.getPrivilegedAccess().getWorkspace(apiWorkspaceUri);
            if (apiWorkspace != null) {
                log.info("Request for new custom API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                this.accesscontrol.createMembership(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId());
            } else {
                log.info("Revoke Request for API Workspace Membership by user \"" + usernameTopic.getSimpleValue().toString() + "\"");
                if (this.accesscontrol.isMember(usernameTopic.getSimpleValue().toString(), apiWorkspace.getId())) {
                    Assoc assoc = this.getMembershipAssociation(usernameTopic.getId(), apiWorkspace.getId());
                    this.dmx.deleteAssoc(assoc.getId());
                } else {
                    log.info("Skipped Revoke Request for non-existent API Workspace Membership for \"" + usernameTopic.getSimpleValue().toString() + "\"");
                }
            }
        } else {
            log.info("No API Workspace Configured: You must enter the URI of a programmatically created workspace topic into your current \"Signup Configuration\".");
        }
    }

    private void reloadAssociatedSignupConfiguration() {
        this.activeModuleConfiguration = this.loadConfiguration();
        if (!this.activeModuleConfiguration.isValid()) {
            log.warning("Could not load associated Sign-up Plugin Configuration Topic during init/postUpdate");
            return;
        }
        this.activeModuleConfiguration.reload();
        this.customWorkspaceAssignmentTopic = this.activeModuleConfiguration.getCustomWorkspaceAssignmentTopic();
        if (this.customWorkspaceAssignmentTopic != null) {
            log.info("Configured Custom Sign-up Workspace => \"" + this.customWorkspaceAssignmentTopic.getSimpleValue() + "\"");
        }
        log.log(Level.INFO, "Sign-up Configuration Loaded (URI=\"{0}\"), Name=\"{1}\"", new Object[]{this.activeModuleConfiguration.getConfigurationUri(), this.activeModuleConfiguration.getConfigurationName()});
    }

    private void sendConfirmationMail(String key, String username, String mailbox) {
        try {
            if (SignUpConfigOptions.DMX_ACCOUNTS_ENABLED) {
                String mailSubject = this.emailTextProducer.getConfirmationActiveMailSubject();
                String message = this.emailTextProducer.getConfirmationActiveMailMessage(username, key);
                this.sendMail(mailSubject, message, mailbox);
            } else {
                String mailSubject = this.emailTextProducer.getConfirmationProceedMailSubject();
                String message = this.emailTextProducer.getUserConfirmationProceedMailMessage(username, key);
                this.sendMail(mailSubject, message, mailbox);
            }
        }
        catch (RuntimeException ex) {
            log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out the \"Email Confirmation\" mail, caused by: " + ex.getMessage());
            throw ex;
        }
    }

    private void sendPasswordResetMail(String key, String username, String mailbox, String displayName) {
        try {
            String addressee = displayName != null && !displayName.isEmpty() ? displayName : username;
            String subject = this.emailTextProducer.getPasswordResetMailSubject();
            String message = this.emailTextProducer.getPasswordResetMailMessage(addressee, key);
            this.sendMail(subject, message, mailbox);
        }
        catch (RuntimeException ex) {
            log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED sending out the \"Password Reset\" mail, caused by: " + ex.getMessage());
            throw ex;
        }
    }

    private void sendNotificationMail(String username, String mailbox) {
        if (SignUpConfigOptions.CONFIG_ADMIN_MAILBOX != null && !SignUpConfigOptions.CONFIG_ADMIN_MAILBOX.isEmpty()) {
            try {
                String subject = this.emailTextProducer.getAccountCreationSystemEmailSubject();
                String message = this.emailTextProducer.getAccountCreationSystemEmailMessage(username, mailbox);
                this.sendMail(subject, message, SignUpConfigOptions.CONFIG_ADMIN_MAILBOX);
            }
            catch (Exception ex) {
                log.severe("There seems to be an issue with your mail (SMTP) setup, we FAILED notifying the \"system mailbox\" about account creation, caused by: " + ex.getMessage());
            }
        } else {
            log.warning("\"dmx.signup.admin_mailbox\" is not configured; welcome mail could not be sent to " + mailbox);
        }
    }

    private void sendMail(String subject, String message, String recipientValues) {
        String projectName = "TODO";
        String sender = SignUpConfigOptions.CONFIG_FROM_MAILBOX;
        boolean isHtml = this.emailTextProducer.isHtml();
        String textMessage = isHtml ? null : message;
        String htmlMessage = isHtml ? message : null;
        this.sendmail.doEmailRecipientAs(sender, projectName, subject, textMessage, htmlMessage, recipientValues);
    }

    private Assoc getDefaultAssociation(long topic1, long topic2) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.core.association", topic1, topic2, "dmx.core.default", "dmx.core.default");
    }

    private Assoc getMembershipAssociation(long id, long idTwo) {
        return this.dmx.getAssocBetweenTopicAndTopic("dmx.accesscontrol.membership", id, idTwo, "dmx.core.default", "dmx.core.default");
    }

    private ModuleConfiguration loadConfiguration() {
        return new ModuleConfiguration(this.dmx.getTopicByUri("dmx.signup.default_configuration"));
    }

    @Override
    public ModuleConfiguration getConfiguration() {
        return this.activeModuleConfiguration;
    }

    @Override
    public List<String> getAuthorizationMethods() {
        HashMap<String, String> knownAms = new HashMap<String, String>();
        HashSet<String> originalAms = new HashSet<String>(this.accesscontrol.getAuthorizationMethods());
        originalAms.add("Basic");
        for (String s : originalAms) {
            knownAms.put(s.toLowerCase(), s);
        }
        ArrayList<String> filteredRestrictedAms = new ArrayList<String>();
        if (SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS.trim().length() > 0) {
            for (String s : SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS.split(",")) {
                String trimmedLowercase = s.trim().toLowerCase();
                String value = (String)knownAms.get(trimmedLowercase);
                if (value == null) continue;
                filteredRestrictedAms.add(value);
            }
        } else {
            filteredRestrictedAms.addAll(originalAms);
        }
        return filteredRestrictedAms;
    }

    private void transactional(Runnable r) {
        DMXTransaction tx = this.dmx.beginTx();
        try {
            r.run();
            tx.success();
        }
        catch (Throwable t) {
            log.warning("A custom transaction failed: " + t.getLocalizedMessage());
            tx.failure();
            throw t;
        }
        finally {
            tx.finish();
        }
    }
}

