/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.migrations;

import java.util.logging.Logger;
import systems.dmx.core.ChildTopics;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.ChildTopicsModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration17
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    WorkspacesService wsService;
    private static final String MIGRATION17_SIGNUP_CONFIGURATION_TYPE_URI = "dmx.signup.configuration";
    private static final String MIGRATION17_SIGNUP_DEFAULT_CONFIGURATION_URI = "dmx.signup.default_configuration";
    private static final String MIGRATION17_CONFIG_PROJECT_TITLE = "dmx.signup.config_project_title";
    private static final String MIGRATION17_CONFIG_WEBAPP_TITLE = "dmx.signup.config_webapp_title";
    private static final String MIGRATION17_CONFIG_LOGO_PATH = "dmx.signup.config_webapp_logo_path";
    private static final String MIGRATION17_CONFIG_CUSTOM_CSS_PATH = "dmx.signup.config_custom_css_path";
    private static final String MIGRATION17_CONFIG_READ_MORE_URL = "dmx.signup.config_read_more_url";
    private static final String MIGRATION17_CONFIG_PAGES_FOOTER = "dmx.signup.config_pages_footer";
    private static final String MIGRATION17_CONFIG_TOS_LABEL = "dmx.signup.config_tos_label";
    private static final String MIGRATION17_CONFIG_TOS_DETAILS = "dmx.signup.config_tos_detail";
    private static final String MIGRATION17_CONFIG_PD_LABEL = "dmx.signup.config_pd_label";
    private static final String MIGRATION17_CONFIG_PD_DETAILS = "dmx.signup.config_pd_detail";
    private static final String MIGRATION17_CONFIG_START_PAGE_URL = "dmx.signup.start_page_url";
    private static final String MIGRATION17_CONFIG_HOME_PAGE_URL = "dmx.signup.home_page_url";
    private static final String MIGRATION17_CONFIG_LOADING_APP_HINT = "dmx.signup.loading_app_hint";
    private static final String MIGRATION17_CONFIG_LOGGING_OUT_HINT = "dmx.signup.logging_out_hint";
    private static final String MIGRATION17_SIGNUP_LEGACY_CONFIGURATION_URI = "dmx.signup.legacy.configuration";
    private static final String MIGRATION17_LEGACY_SIGNUP_CONFIGURATION_TYPE_URI = "dmx.signup.legacy_configuration";
    private static final String MIGRATION17_LEGACY_CONFIG_PROJECT_TITLE = "dmx.signup.legacy_config_project_title";
    private static final String MIGRATION17_LEGACY_CONFIG_WEBAPP_TITLE = "dmx.signup.legacy_config_webapp_title";
    private static final String MIGRATION17_LEGACY_CONFIG_LOGO_PATH = "dmx.signup.legacy_config_webapp_logo_path";
    private static final String MIGRATION17_LEGACY_CONFIG_CUSTOM_CSS_PATH = "dmx.signup.legacy_config_custom_css_path";
    private static final String MIGRATION17_LEGACY_CONFIG_READ_MORE_URL = "dmx.signup.legacy_config_read_more_url";
    private static final String MIGRATION17_LEGACY_CONFIG_PAGES_FOOTER = "dmx.signup.legacy_config_pages_footer";
    private static final String MIGRATION17_LEGACY_CONFIG_TOS_LABEL = "dmx.signup.legacy_config_tos_label";
    private static final String MIGRATION17_LEGACY_CONFIG_TOS_DETAILS = "dmx.signup.legacy_config_tos_detail";
    private static final String MIGRATION17_LEGACY_CONFIG_PD_LABEL = "dmx.signup.legacy_config_pd_label";
    private static final String MIGRATION17_LEGACY_CONFIG_PD_DETAILS = "dmx.signup.legacy_config_pd_detail";
    private static final String MIGRATION17_LEGACY_CONFIG_START_PAGE_URL = "dmx.signup.legacy_config_start_page_url";
    private static final String MIGRATION17_LEGACY_CONFIG_HOME_PAGE_URL = "dmx.signup.legacy_config_home_page_url";
    private static final String MIGRATION17_LEGACY_CONFIG_LOADING_APP_HINT = "dmx.signup.legacy_config_loading_app_hint";
    private static final String MIGRATION17_LEGACY_CONFIG_LOGGING_OUT_HINT = "dmx.signup.legacy_config_logging_out_hint";

    public void run() {
        this.createLegacyConfigTopicWithValuesFromDefaultConfiguration();
        this.assignToAdminworkspace();
        this.deleteDefaultCompDefsAndValues();
    }

    private void createLegacyConfigTopicWithValuesFromDefaultConfiguration() {
        Topic defaultConfiguration = this.dmx.getTopicByUri(MIGRATION17_SIGNUP_DEFAULT_CONFIGURATION_URI);
        ChildTopics defaultChilds = defaultConfiguration.getChildTopics();
        this.logger.info("###### Create legacy configuration with values coming from previous default configuration");
        ChildTopicsModel ctm = this.mf.newChildTopicsModel();
        ctm.set(MIGRATION17_LEGACY_CONFIG_PROJECT_TITLE, (Object)defaultChilds.getString(MIGRATION17_CONFIG_PROJECT_TITLE));
        ctm.set(MIGRATION17_LEGACY_CONFIG_WEBAPP_TITLE, (Object)defaultChilds.getString(MIGRATION17_CONFIG_WEBAPP_TITLE));
        ctm.set(MIGRATION17_LEGACY_CONFIG_LOGO_PATH, (Object)defaultChilds.getString(MIGRATION17_CONFIG_LOGO_PATH));
        ctm.set(MIGRATION17_LEGACY_CONFIG_CUSTOM_CSS_PATH, (Object)defaultChilds.getString(MIGRATION17_CONFIG_CUSTOM_CSS_PATH));
        ctm.set(MIGRATION17_LEGACY_CONFIG_READ_MORE_URL, (Object)defaultChilds.getString(MIGRATION17_CONFIG_READ_MORE_URL));
        ctm.set(MIGRATION17_LEGACY_CONFIG_PAGES_FOOTER, (Object)defaultChilds.getString(MIGRATION17_CONFIG_PAGES_FOOTER));
        ctm.set(MIGRATION17_LEGACY_CONFIG_TOS_LABEL, (Object)defaultChilds.getString(MIGRATION17_CONFIG_TOS_LABEL));
        ctm.set(MIGRATION17_LEGACY_CONFIG_TOS_DETAILS, (Object)defaultChilds.getString(MIGRATION17_CONFIG_TOS_DETAILS));
        ctm.set(MIGRATION17_LEGACY_CONFIG_PD_LABEL, (Object)defaultChilds.getString(MIGRATION17_CONFIG_PD_LABEL));
        ctm.set(MIGRATION17_LEGACY_CONFIG_PD_DETAILS, (Object)defaultChilds.getString(MIGRATION17_CONFIG_PD_DETAILS));
        ctm.set(MIGRATION17_LEGACY_CONFIG_START_PAGE_URL, (Object)defaultChilds.getString(MIGRATION17_CONFIG_START_PAGE_URL));
        ctm.set(MIGRATION17_LEGACY_CONFIG_HOME_PAGE_URL, (Object)defaultChilds.getString(MIGRATION17_CONFIG_HOME_PAGE_URL));
        ctm.set(MIGRATION17_LEGACY_CONFIG_LOADING_APP_HINT, (Object)defaultChilds.getString(MIGRATION17_CONFIG_LOADING_APP_HINT));
        ctm.set(MIGRATION17_LEGACY_CONFIG_LOGGING_OUT_HINT, (Object)defaultChilds.getString(MIGRATION17_CONFIG_LOGGING_OUT_HINT));
        this.dmx.createTopic(this.mf.newTopicModel(MIGRATION17_SIGNUP_LEGACY_CONFIGURATION_URI, MIGRATION17_LEGACY_SIGNUP_CONFIGURATION_TYPE_URI, ctm));
    }

    private void assignToAdminworkspace() {
        long administrationWsId = this.dmx.getPrivilegedAccess().getAdminWorkspaceId();
        this.logger.info("###### Migrate allSign-up legacy Configuration Topics to \"Administration\" Workspace");
        Topic standardConfiguration = this.dmx.getTopicByUri(MIGRATION17_SIGNUP_LEGACY_CONFIGURATION_URI);
        this.wsService.assignToWorkspace((DMXObject)standardConfiguration, administrationWsId);
        standardConfiguration.loadChildTopics();
        RelatedTopic webAppTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_WEBAPP_TITLE);
        RelatedTopic logoPath = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_LOGO_PATH);
        RelatedTopic cssPath = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_CUSTOM_CSS_PATH);
        RelatedTopic projectTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_PROJECT_TITLE);
        RelatedTopic tosLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_TOS_LABEL);
        RelatedTopic tosDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_TOS_DETAILS);
        RelatedTopic pdLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_PD_LABEL);
        RelatedTopic pdDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_PD_DETAILS);
        RelatedTopic readMoreUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_READ_MORE_URL);
        RelatedTopic pagesFooter = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_PAGES_FOOTER);
        RelatedTopic startPageUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_START_PAGE_URL);
        RelatedTopic homePageUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_HOME_PAGE_URL);
        RelatedTopic loadingAppHint = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_LOADING_APP_HINT);
        RelatedTopic loggingOutHint = standardConfiguration.getChildTopics().getTopic(MIGRATION17_LEGACY_CONFIG_LOGGING_OUT_HINT);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)logoPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)logoPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)startPageUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)startPageUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)homePageUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)homePageUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loadingAppHint, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loadingAppHint.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loggingOutHint, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)loggingOutHint.getRelatingAssoc(), administrationWsId);
    }

    private void deleteDefaultCompDefsAndValues() {
        TopicType signupConfigType = this.dmx.getTopicType(MIGRATION17_SIGNUP_CONFIGURATION_TYPE_URI);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_PROJECT_TITLE);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_WEBAPP_TITLE);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_LOGO_PATH);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_CUSTOM_CSS_PATH);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_READ_MORE_URL);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_PAGES_FOOTER);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_TOS_LABEL);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_TOS_DETAILS);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_PD_LABEL);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_PD_DETAILS);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_START_PAGE_URL);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_HOME_PAGE_URL);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_LOADING_APP_HINT);
        signupConfigType.removeCompDef(MIGRATION17_CONFIG_LOGGING_OUT_HINT);
        TopicModel defaultConfiguration = this.dmx.getTopicByUri(MIGRATION17_SIGNUP_DEFAULT_CONFIGURATION_URI).getModel();
        ChildTopicsModel defaultChilds = defaultConfiguration.getChildTopics();
        defaultChilds.remove(MIGRATION17_CONFIG_PROJECT_TITLE);
        defaultChilds.remove(MIGRATION17_CONFIG_WEBAPP_TITLE);
        defaultChilds.remove(MIGRATION17_CONFIG_LOGO_PATH);
        defaultChilds.remove(MIGRATION17_CONFIG_CUSTOM_CSS_PATH);
        defaultChilds.remove(MIGRATION17_CONFIG_READ_MORE_URL);
        defaultChilds.remove(MIGRATION17_CONFIG_PAGES_FOOTER);
        defaultChilds.remove(MIGRATION17_CONFIG_TOS_LABEL);
        defaultChilds.remove(MIGRATION17_CONFIG_TOS_DETAILS);
        defaultChilds.remove(MIGRATION17_CONFIG_PD_LABEL);
        defaultChilds.remove(MIGRATION17_CONFIG_PD_DETAILS);
        defaultChilds.remove(MIGRATION17_CONFIG_START_PAGE_URL);
        defaultChilds.remove(MIGRATION17_CONFIG_HOME_PAGE_URL);
        defaultChilds.remove(MIGRATION17_CONFIG_LOADING_APP_HINT);
        defaultChilds.remove(MIGRATION17_CONFIG_LOGGING_OUT_HINT);
        this.dmx.updateTopic(defaultConfiguration);
        this.purgeTopicType(MIGRATION17_CONFIG_PROJECT_TITLE);
        this.purgeTopicType(MIGRATION17_CONFIG_WEBAPP_TITLE);
        this.purgeTopicType(MIGRATION17_CONFIG_LOGO_PATH);
        this.purgeTopicType(MIGRATION17_CONFIG_CUSTOM_CSS_PATH);
        this.purgeTopicType(MIGRATION17_CONFIG_READ_MORE_URL);
        this.purgeTopicType(MIGRATION17_CONFIG_PAGES_FOOTER);
        this.purgeTopicType(MIGRATION17_CONFIG_TOS_LABEL);
        this.purgeTopicType(MIGRATION17_CONFIG_TOS_DETAILS);
        this.purgeTopicType(MIGRATION17_CONFIG_PD_LABEL);
        this.purgeTopicType(MIGRATION17_CONFIG_PD_DETAILS);
        this.purgeTopicType(MIGRATION17_CONFIG_START_PAGE_URL);
        this.purgeTopicType(MIGRATION17_CONFIG_HOME_PAGE_URL);
        this.purgeTopicType(MIGRATION17_CONFIG_LOADING_APP_HINT);
        this.purgeTopicType(MIGRATION17_CONFIG_LOGGING_OUT_HINT);
    }

    private void purgeTopicType(String s) {
        this.dmx.getTopicsByType(s).forEach(it -> this.dmx.deleteTopic(it.getId()));
        this.dmx.deleteTopicType(s);
    }
}

