/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.migrations;

import java.util.logging.Logger;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.service.Migration;

public class Migration5
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String MIGRATION5_SIGNUP_DEFAULT_CONFIGURATION_URI = "dmx.signup.default_configuration";
    private static final String MIGRATION5_SIGN_UP_CONFIG_TYPE_URI = "dmx.signup.configuration";
    private static final String MIGRATION5_CONFIG_START_PAGE_URL = "dmx.signup.start_page_url";
    private static final String MIGRATION5_CONFIG_HOME_PAGE_URL = "dmx.signup.home_page_url";
    private static final String MIGRATION5_CONFIG_LOADING_APP_HINT = "dmx.signup.loading_app_hint";
    private static final String MIGRATION5_CONFIG_LOGGING_OUT_HINT = "dmx.signup.logging_out_hint";
    private static final String DEFAULT_START_PAGE_URL = System.getProperty("dmx.signup.start_page_url", "/systems.dmx.webclient/");
    private static final String DEFAULT_HOME_PAGE_URL = System.getProperty("dmx.signup.home_page_url", "/systems.dmx.webclient/");
    private static final String DEFAULT_LOADING_APP_HINT = System.getProperty("dmx.signup.loading_app_hint", "Loading DMX Webclient");
    private static final String DEFAULT_LOGGING_OUT_HINT = System.getProperty("dmx.signup.logging_out_hint", "Logging out..");

    public void run() {
        this.logger.info("### Extending Sign-up Configuration about \"Start Page URL\" option ###");
        this.dmx.createTopicType(this.mf.newTopicTypeModel(MIGRATION5_CONFIG_START_PAGE_URL, "Sign-up: Start Page URL", "dmx.core.text"));
        this.logger.info("### Extending Sign-up Configuration about \"Home Page URL\" option ###");
        this.dmx.createTopicType(this.mf.newTopicTypeModel(MIGRATION5_CONFIG_HOME_PAGE_URL, "Sign-up: Home Page URL", "dmx.core.text"));
        this.logger.info("### Extending Sign-up Configuration about \"Loading App Hint\" option ###");
        this.dmx.createTopicType(this.mf.newTopicTypeModel(MIGRATION5_CONFIG_LOADING_APP_HINT, "Sign-up: Loading App Hint", "dmx.core.text"));
        this.logger.info("### Extending Sign-up Configuration about \"Logging Out Hint\" option ###");
        this.dmx.createTopicType(this.mf.newTopicTypeModel(MIGRATION5_CONFIG_LOGGING_OUT_HINT, "Sign-up: Logging Out Hint", "dmx.core.text"));
        TopicType signupConfigType = this.dmx.getTopicType(MIGRATION5_SIGN_UP_CONFIG_TYPE_URI);
        signupConfigType.addCompDef(this.mf.newCompDefModel(MIGRATION5_SIGN_UP_CONFIG_TYPE_URI, MIGRATION5_CONFIG_START_PAGE_URL, "dmx.core.one"));
        signupConfigType.addCompDef(this.mf.newCompDefModel(MIGRATION5_SIGN_UP_CONFIG_TYPE_URI, MIGRATION5_CONFIG_HOME_PAGE_URL, "dmx.core.one"));
        signupConfigType.addCompDef(this.mf.newCompDefModel(MIGRATION5_SIGN_UP_CONFIG_TYPE_URI, MIGRATION5_CONFIG_LOADING_APP_HINT, "dmx.core.one"));
        signupConfigType.addCompDef(this.mf.newCompDefModel(MIGRATION5_SIGN_UP_CONFIG_TYPE_URI, MIGRATION5_CONFIG_LOGGING_OUT_HINT, "dmx.core.one"));
        Topic defaultConfiguration = this.dmx.getTopicByUri(MIGRATION5_SIGNUP_DEFAULT_CONFIGURATION_URI);
        this.dmx.updateTopic(this.mf.newTopicModel(defaultConfiguration.getId(), this.mf.newChildTopicsModel().set(MIGRATION5_CONFIG_START_PAGE_URL, (Object)DEFAULT_START_PAGE_URL)));
        this.dmx.updateTopic(this.mf.newTopicModel(defaultConfiguration.getId(), this.mf.newChildTopicsModel().set(MIGRATION5_CONFIG_HOME_PAGE_URL, (Object)DEFAULT_HOME_PAGE_URL)));
        this.dmx.updateTopic(this.mf.newTopicModel(defaultConfiguration.getId(), this.mf.newChildTopicsModel().set(MIGRATION5_CONFIG_LOADING_APP_HINT, (Object)DEFAULT_LOADING_APP_HINT)));
        this.dmx.updateTopic(this.mf.newTopicModel(defaultConfiguration.getId(), this.mf.newChildTopicsModel().set(MIGRATION5_CONFIG_LOGGING_OUT_HINT, (Object)DEFAULT_LOGGING_OUT_HINT)));
    }
}

