/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.model.SimpleValue;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.workspaces.WorkspacesService;

public class Migration10
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    private static final String MIGRATION10_CONFIG_PROJECT_TITLE = "dmx.signup.config_project_title";
    private static final String MIGRATION10_CONFIG_WEBAPP_TITLE = "dmx.signup.config_webapp_title";
    private static final String MIGRATION10_CONFIG_LOGO_PATH = "dmx.signup.config_webapp_logo_path";
    private static final String MIGRATION10_CONFIG_CUSTOM_CSS_PATH = "dmx.signup.config_custom_css_path";
    private static final String MIGRATION10_CONFIG_READ_MORE_URL = "dmx.signup.config_read_more_url";
    private static final String MIGRATION10_CONFIG_PAGES_FOOTER = "dmx.signup.config_pages_footer";
    private static final String MIGRATION10_CONFIG_TOS_LABEL = "dmx.signup.config_tos_label";
    private static final String MIGRATION10_CONFIG_TOS_DETAILS = "dmx.signup.config_tos_detail";
    private static final String MIGRATION10_CONFIG_PD_LABEL = "dmx.signup.config_pd_label";
    private static final String MIGRATION10_CONFIG_PD_DETAILS = "dmx.signup.config_pd_detail";
    @Inject
    private WorkspacesService wsService;

    public void run() {
        long administrationWsId = this.dmx.getPrivilegedAccess().getAdminWorkspaceId();
        this.logger.info("###### Migrate all relevant Sign-up Configration Topics to \"Administration\" Workspace");
        Topic standardConfiguration = this.dmx.getTopicByUri("dmx.signup.default_configuration");
        this.wsService.assignToWorkspace((DMXObject)standardConfiguration, administrationWsId);
        standardConfiguration.loadChildTopics();
        RelatedTopic webAppTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_WEBAPP_TITLE);
        RelatedTopic logoPath = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_LOGO_PATH);
        RelatedTopic cssPath = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_CUSTOM_CSS_PATH);
        RelatedTopic projectTitle = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_PROJECT_TITLE);
        RelatedTopic tosLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_TOS_LABEL);
        RelatedTopic tosDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_TOS_DETAILS);
        RelatedTopic pdLabel = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_PD_LABEL);
        RelatedTopic pdDetail = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_PD_DETAILS);
        RelatedTopic readMoreUrl = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_READ_MORE_URL);
        RelatedTopic pagesFooter = standardConfiguration.getChildTopics().getTopic(MIGRATION10_CONFIG_PAGES_FOOTER);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)webAppTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)cssPath.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)projectTitle.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)tosDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdLabel.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pdDetail.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)readMoreUrl.getRelatingAssoc(), administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter, administrationWsId);
        this.wsService.assignToWorkspace((DMXObject)pagesFooter.getRelatingAssoc(), administrationWsId);
        Topic pluginTopic = this.dmx.getTopicByUri("systems.dmx.sign-up");
        if (pluginTopic != null) {
            List configs = pluginTopic.getAssocs();
            for (Assoc assoc : configs) {
                if (!assoc.getPlayer1().getDMXObject().getTypeUri().equals("dmx.signup.configuration") && !assoc.getPlayer2().getDMXObject().getTypeUri().equals("dmx.signup.configuration")) continue;
                this.wsService.assignToWorkspace((DMXObject)assoc, administrationWsId);
                assoc.setSimpleValue(new SimpleValue("Active Configuration"));
            }
        }
        Topic apiMembershipNote = this.dmx.getTopicByUri("dmx.signup.api_membership_requests");
        this.wsService.assignToWorkspace((DMXObject)apiMembershipNote, administrationWsId);
        this.logger.info("###### Migrate all users Email Addresses to \"Administration\" Workspace");
        List emails = this.dmx.getTopicsByType("dmx.contacts.email_address");
        for (Topic email : emails) {
            RelatedTopic username = email.getRelatedTopic("dmx.base.user_mailbox", "dmx.core.child", "dmx.core.parent", "dmx.accesscontrol.username");
            if (username == null) continue;
            this.wsService.assignToWorkspace((DMXObject)email, administrationWsId);
        }
        this.logger.info("###### Email Address topic migration to \"Administration\" Workspace complete");
    }
}

