/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.configuration;

import systems.dmx.core.Topic;

public class ModuleConfiguration {
    private final Topic topic;

    public ModuleConfiguration(Topic topic) {
        this.topic = topic;
    }

    public String getConfigurationUri() {
        return this.topic.getUri();
    }

    public String getConfigurationName() {
        return this.topic.getSimpleValue().toString();
    }

    public boolean isValid() {
        return this.topic != null;
    }

    public void reload() {
        this.topic.loadChildTopics();
    }

    private String getString(String key) {
        return this.topic.getChildTopics().getString(key);
    }

    private boolean getBoolean(String key) {
        return this.topic.getChildTopics().getBoolean(key);
    }

    public Boolean getApiEnabled() {
        return this.getBoolean("dmx.signup.config_api_enabled");
    }

    public String getApiDescription() {
        return this.getString("dmx.signup.config_api_description");
    }

    public String getApiDetails() {
        return this.getString("dmx.signup.config_api_details");
    }

    public String getApiWorkspaceUri() {
        return this.getString("dmx.signup.config_api_workspace_uri");
    }

    public Topic getCustomWorkspaceAssignmentTopic() {
        return this.topic.getRelatedTopic("dmx.core.association", "dmx.core.default", "dmx.core.default", "dmx.workspaces.workspace");
    }
}

