/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.usecase;

import javax.inject.Inject;
import javax.inject.Singleton;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.accesscontrol.AccessControlException;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.workspaces.WorkspacesService;

@Singleton
public class HasAccountCreationPrivilegeUseCase {
    private final CoreService dmx;
    private final WorkspacesService workspacesService;

    @Inject
    HasAccountCreationPrivilegeUseCase(CoreService dmx, WorkspacesService workspacesService) {
        this.dmx = dmx;
        this.workspacesService = workspacesService;
    }

    public boolean invoke() {
        try {
            this.checkAccountCreation();
            return true;
        }
        catch (AccessControlException ace) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public void checkAccountCreation() {
        if (this.isAccountCreationWorkspaceUriConfigured()) {
            try {
                this.checkAccountCreationWorkspaceWriteAccess();
            }
            catch (AccessControlException ace) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
            catch (RuntimeException re) {
                this.checkAdministrationWorkspaceWriteAccess();
            }
        } else {
            this.checkAdministrationWorkspaceWriteAccess();
        }
    }

    private void checkAdministrationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.dmx.getPrivilegedAccess().getAdminWorkspaceId()).checkWriteAccess();
    }

    private boolean isAccountCreationWorkspaceUriConfigured() {
        return !SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI.isEmpty();
    }

    private void checkAccountCreationWorkspaceWriteAccess() {
        this.dmx.getTopic(this.workspacesService.getWorkspace(SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI).getId()).checkWriteAccess();
    }
}

