/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.usecase;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.Rule;
import org.passay.SequenceData;
import org.passay.WhitespaceRule;
import systems.dmx.signup.configuration.ExpectedPasswordComplexity;

@Singleton
public class IsPasswordComplexEnoughUseCase {
    public static final int MINIMUM_PASSWORD_LENGTH = 8;
    public static final int MAXIMUM_PASSWORD_LENGTH = 16;
    private final PasswordValidator validator = new PasswordValidator(new Rule[]{new LengthRule(8, 16), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1), new CharacterRule((CharacterData)EnglishCharacterData.Special, 1), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Alphabetical, 5, false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Numerical, 5, false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.USQwerty, 5, false), new WhitespaceRule()});

    @Inject
    IsPasswordComplexEnoughUseCase() {
    }

    public boolean invoke(ExpectedPasswordComplexity expectedPasswordComplexity, String password) {
        switch (expectedPasswordComplexity) {
            case NONE: {
                return true;
            }
            case COMPLEX: {
                return this.validator.validate(new PasswordData(password)).isValid();
            }
        }
        throw new IllegalStateException("Unexpected password complexity: " + (Object)((Object)expectedPasswordComplexity));
    }
}

