/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.usecase;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.passay.CharacterData;
import org.passay.CharacterRule;
import org.passay.EnglishCharacterData;
import org.passay.EnglishSequenceData;
import org.passay.IllegalSequenceRule;
import org.passay.LengthRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.Rule;
import org.passay.SequenceData;
import org.passay.WhitespaceRule;
import systems.dmx.signup.configuration.ExpectedPasswordComplexity;
import systems.dmx.signup.configuration.SignUpConfigOptions;

@Singleton
public class IsPasswordComplexEnoughUseCase {
    private final PasswordValidator validator;

    IsPasswordComplexEnoughUseCase(int minPasswordLength, int maxPasswordLength) {
        this.validator = new PasswordValidator(new Rule[]{new LengthRule(minPasswordLength, maxPasswordLength), new CharacterRule((CharacterData)EnglishCharacterData.UpperCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.LowerCase, 1), new CharacterRule((CharacterData)EnglishCharacterData.Digit, 1), new CharacterRule((CharacterData)EnglishCharacterData.Special, 1), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Alphabetical, 5, false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.Numerical, 5, false), new IllegalSequenceRule((SequenceData)EnglishSequenceData.USQwerty, 5, false), new WhitespaceRule()});
    }

    @Inject
    IsPasswordComplexEnoughUseCase() {
        this(SignUpConfigOptions.CONFIG_EXPECTED_MIN_PASSWORD_LENGTH, SignUpConfigOptions.CONFIG_EXPECTED_MAX_PASSWORD_LENGTH);
    }

    public boolean invoke(ExpectedPasswordComplexity expectedPasswordComplexity, String password) {
        switch (expectedPasswordComplexity) {
            case NONE: {
                return true;
            }
            case COMPLEX: {
                return this.validator.validate(new PasswordData(password)).isValid();
            }
        }
        throw new IllegalStateException("Unexpected password complexity: " + (Object)((Object)expectedPasswordComplexity));
    }
}

