/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.di;

import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import javax.inject.Provider;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.service.CoreService;
import systems.dmx.sendmail.SendmailService;
import systems.dmx.signup.di.SignupComponent;
import systems.dmx.signup.mapper.IsValidEmailAdressMapper;
import systems.dmx.signup.mapper.NewAccountDataMapper;
import systems.dmx.signup.repository.ConfigurationDatasource;
import systems.dmx.signup.repository.ConfigurationDatasource_Factory;
import systems.dmx.signup.repository.ConfigurationRepository;
import systems.dmx.signup.repository.ConfigurationRepository_Factory;
import systems.dmx.signup.usecase.GetAccountCreationPasswordUseCase;
import systems.dmx.signup.usecase.GetAccountCreationPasswordUseCase_Factory;
import systems.dmx.signup.usecase.GetLdapServiceUseCase;
import systems.dmx.signup.usecase.GetLdapServiceUseCase_Factory;
import systems.dmx.signup.usecase.HasAccountCreationPrivilegeUseCase;
import systems.dmx.signup.usecase.HasAccountCreationPrivilegeUseCase_Factory;
import systems.dmx.signup.usecase.IsPasswordComplexEnoughUseCase;
import systems.dmx.signup.usecase.IsPasswordComplexEnoughUseCase_Factory;
import systems.dmx.signup.usecase.LogAndVerifyConfigurationUseCase;
import systems.dmx.signup.usecase.LogAndVerifyConfigurationUseCase_Factory;
import systems.dmx.signup.usecase.SendMailUseCase;
import systems.dmx.signup.usecase.SendMailUseCase_Factory;
import systems.dmx.workspaces.WorkspacesService;

@DaggerGenerated
public final class DaggerSignupComponent {
    private DaggerSignupComponent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class SignupComponentImpl
    implements SignupComponent {
        private final SignupComponentImpl signupComponentImpl = this;
        private Provider<GetLdapServiceUseCase> getLdapServiceUseCaseProvider;
        private Provider<GetAccountCreationPasswordUseCase> getAccountCreationPasswordUseCaseProvider;
        private Provider<CoreService> coreServiceProvider;
        private Provider<WorkspacesService> workspacesServiceProvider;
        private Provider<HasAccountCreationPrivilegeUseCase> hasAccountCreationPrivilegeUseCaseProvider;
        private Provider<IsPasswordComplexEnoughUseCase> isPasswordComplexEnoughUseCaseProvider;
        private Provider<ConfigurationDatasource> configurationDatasourceProvider;
        private Provider<ConfigurationRepository> configurationRepositoryProvider;
        private Provider<LogAndVerifyConfigurationUseCase> logAndVerifyConfigurationUseCaseProvider;
        private Provider<SendmailService> sendmailServiceProvider;
        private Provider<SendMailUseCase> sendMailUseCaseProvider;

        private SignupComponentImpl(CoreService coreServiceParam, AccessControlService accessControlServiceParam, WorkspacesService workspacesServiceParam, SendmailService sendmailServiceParam) {
            this.initialize(coreServiceParam, accessControlServiceParam, workspacesServiceParam, sendmailServiceParam);
        }

        private void initialize(CoreService coreServiceParam, AccessControlService accessControlServiceParam, WorkspacesService workspacesServiceParam, SendmailService sendmailServiceParam) {
            this.getLdapServiceUseCaseProvider = DoubleCheck.provider((Provider)GetLdapServiceUseCase_Factory.create());
            this.getAccountCreationPasswordUseCaseProvider = DoubleCheck.provider((Provider)GetAccountCreationPasswordUseCase_Factory.create());
            this.coreServiceProvider = InstanceFactory.create((Object)coreServiceParam);
            this.workspacesServiceProvider = InstanceFactory.create((Object)workspacesServiceParam);
            this.hasAccountCreationPrivilegeUseCaseProvider = DoubleCheck.provider((Provider)HasAccountCreationPrivilegeUseCase_Factory.create(this.coreServiceProvider, this.workspacesServiceProvider));
            this.isPasswordComplexEnoughUseCaseProvider = DoubleCheck.provider((Provider)IsPasswordComplexEnoughUseCase_Factory.create());
            this.configurationDatasourceProvider = DoubleCheck.provider((Provider)ConfigurationDatasource_Factory.create());
            this.configurationRepositoryProvider = DoubleCheck.provider((Provider)ConfigurationRepository_Factory.create(this.configurationDatasourceProvider));
            this.logAndVerifyConfigurationUseCaseProvider = DoubleCheck.provider((Provider)LogAndVerifyConfigurationUseCase_Factory.create(this.configurationRepositoryProvider));
            this.sendmailServiceProvider = InstanceFactory.create((Object)sendmailServiceParam);
            this.sendMailUseCaseProvider = DoubleCheck.provider((Provider)SendMailUseCase_Factory.create(this.sendmailServiceProvider));
        }

        @Override
        public NewAccountDataMapper newAccountDataMapper() {
            return new NewAccountDataMapper();
        }

        @Override
        public IsValidEmailAdressMapper isValidEmailAdressMapper() {
            return new IsValidEmailAdressMapper();
        }

        @Override
        public GetLdapServiceUseCase getLdapServiceUseCase() {
            return (GetLdapServiceUseCase)this.getLdapServiceUseCaseProvider.get();
        }

        @Override
        public GetAccountCreationPasswordUseCase getAccountCreationPasswordUseCase() {
            return (GetAccountCreationPasswordUseCase)this.getAccountCreationPasswordUseCaseProvider.get();
        }

        @Override
        public HasAccountCreationPrivilegeUseCase hasAccountCreationPrivilegeUseCase() {
            return (HasAccountCreationPrivilegeUseCase)this.hasAccountCreationPrivilegeUseCaseProvider.get();
        }

        @Override
        public IsPasswordComplexEnoughUseCase isPasswordComplexEnoughUseCase() {
            return (IsPasswordComplexEnoughUseCase)this.isPasswordComplexEnoughUseCaseProvider.get();
        }

        @Override
        public LogAndVerifyConfigurationUseCase logAndVerifyConfigurationUseCase() {
            return (LogAndVerifyConfigurationUseCase)this.logAndVerifyConfigurationUseCaseProvider.get();
        }

        @Override
        public SendMailUseCase sendMailUseCase() {
            return (SendMailUseCase)this.sendMailUseCaseProvider.get();
        }
    }

    public static final class Builder {
        private CoreService coreService;
        private AccessControlService accessControlService;
        private WorkspacesService workspacesService;
        private SendmailService sendmailService;

        private Builder() {
        }

        public Builder coreService(CoreService coreService) {
            this.coreService = (CoreService)Preconditions.checkNotNull((Object)coreService);
            return this;
        }

        public Builder accessControlService(AccessControlService accessControlService) {
            this.accessControlService = (AccessControlService)Preconditions.checkNotNull((Object)accessControlService);
            return this;
        }

        public Builder workspacesService(WorkspacesService workspacesService) {
            this.workspacesService = (WorkspacesService)Preconditions.checkNotNull((Object)workspacesService);
            return this;
        }

        public Builder sendmailService(SendmailService sendmailService) {
            this.sendmailService = (SendmailService)Preconditions.checkNotNull((Object)sendmailService);
            return this;
        }

        public SignupComponent build() {
            Preconditions.checkBuilderRequirement((Object)this.coreService, CoreService.class);
            Preconditions.checkBuilderRequirement((Object)this.accessControlService, AccessControlService.class);
            Preconditions.checkBuilderRequirement((Object)this.workspacesService, WorkspacesService.class);
            Preconditions.checkBuilderRequirement((Object)this.sendmailService, SendmailService.class);
            return new SignupComponentImpl(this.coreService, this.accessControlService, this.workspacesService, this.sendmailService);
        }
    }
}

