/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.signup.usecase;

import java.util.List;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import systems.dmx.signup.configuration.Configuration;
import systems.dmx.signup.configuration.SignUpConfigOptions;
import systems.dmx.signup.repository.ConfigurationRepository;

@Singleton
public class LogAndVerifyConfigurationUseCase {
    static final Logger logger = Logger.getLogger(LogAndVerifyConfigurationUseCase.class.getName());
    private final ConfigurationRepository configurationRepository;

    @Inject
    LogAndVerifyConfigurationUseCase(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    private String getDeprecatedPropertyWarning(String deprecatedPropertyKey, String propertyKey) {
        return String.format("A configuration value from the deprecated property '%s' was used. Please migrate the value to the property '%s'.", deprecatedPropertyKey, propertyKey);
    }

    public Configuration invoke(systems.dmx.ldap.Configuration ldapConfiguration, List<String> authorizationMethods) {
        ConfigurationRepository.Value adminEmailAddress = this.configurationRepository.getString("dmx.signup.system_admin_mailbox", "dmx.signup.admin_mailbox");
        ConfigurationRepository.Value fromEmailAddress = this.configurationRepository.getString("dmx.signup.system_from_mailbox", "dmx.signup.system_mailbox");
        ConfigurationRepository.Value fromName = this.configurationRepository.getStringWithDefault("dmx.signup.system_from_name", "");
        logger.info("\n  dmx.signup.account_creation: " + (Object)((Object)SignUpConfigOptions.CONFIG_ACCOUNT_CREATION) + "\n  dmx.signup.account_creation_password_handling: " + (Object)((Object)SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_PASSWORD_HANDLING) + "\n  dmx.signup.username_policy: " + (Object)((Object)SignUpConfigOptions.CONFIG_USERNAME_POLICY) + "\n  dmx.signup.confirm_email_address: " + SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION + "\n  dmx.signup.system_admin_mailbox: " + adminEmailAddress.value + "\n  dmx.signup.system_from_mailbox: " + fromEmailAddress.value + "\n  dmx.signup.system_from_name: " + fromName.value + "\n  dmx.signup.ldap_account_creation: " + SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS + "\n  dmx.signup.account_creation_auth_ws_uri: " + SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI + "\n  dmx.signup.restrict_auth_methods: " + SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS + "\n  dmx.signup.token_expiration_time: " + SignUpConfigOptions.CONFIG_TOKEN_EXPIRATION_DURATION.toHours() + "\n  dmx.signup.expected_password_complexity: " + (Object)((Object)SignUpConfigOptions.CONFIG_EXPECTED_PASSWORD_COMPLEXITY) + "\n");
        logger.info("Available auth methods and order:" + authorizationMethods + "\n");
        if (ldapConfiguration == null) {
            if (SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS) {
                logger.warning("LDAP Account creation configured but respective plugin not available!");
            }
        } else if (!ldapConfiguration.useBindAccount) {
            logger.info("LDAP is configured to not use bind account. Only log-in operation will work.");
            if (SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS) {
                logger.warning("LDAP Account creation configured but no bind account should be used. Enable and provide a bind account otherwise account creation cannot work.");
            }
        }
        if (StringUtils.isBlank((CharSequence)adminEmailAddress.value)) {
            logger.warning("'dmx.signup.system_admin_mailbox' is not configured. Please correct this otherwise various notification emails cannot be send.");
        }
        if (adminEmailAddress.isFromDeprecatedProperty) {
            logger.warning(this.getDeprecatedPropertyWarning("dmx.signup.admin_mailbox", "dmx.signup.system_admin_mailbox"));
        }
        if (fromEmailAddress.isFromDeprecatedProperty) {
            logger.warning(this.getDeprecatedPropertyWarning("dmx.signup.system_mailbox", "dmx.signup.system_from_mailbox"));
        }
        return new Configuration(SignUpConfigOptions.CONFIG_ACCOUNT_CREATION, SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_PASSWORD_HANDLING, SignUpConfigOptions.CONFIG_EXPECTED_PASSWORD_COMPLEXITY, SignUpConfigOptions.CONFIG_EXPECTED_MIN_PASSWORD_LENGTH, SignUpConfigOptions.CONFIG_EXPECTED_MAX_PASSWORD_LENGTH, SignUpConfigOptions.CONFIG_USERNAME_POLICY, SignUpConfigOptions.CONFIG_EMAIL_CONFIRMATION, adminEmailAddress.value, fromEmailAddress.value, fromName.value, SignUpConfigOptions.CONFIG_CREATE_LDAP_ACCOUNTS, SignUpConfigOptions.CONFIG_ACCOUNT_CREATION_AUTH_WS_URI, SignUpConfigOptions.CONFIG_RESTRICT_AUTH_METHODS, SignUpConfigOptions.CONFIG_TOKEN_EXPIRATION_DURATION);
    }
}

