/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssociationDefinitionModel;
import systems.dmx.core.model.RelatedTopicModel;
import systems.dmx.core.model.TopicModel;
import systems.dmx.core.service.CoreService;
import systems.dmx.tableview.AssociationCountColumn;
import systems.dmx.tableview.Column;
import systems.dmx.tableview.TopicmapsColumn;
import systems.dmx.topicmaps.TopicmapsService;

public class Row
implements JSONEnabled {
    private Topic topic;
    private List<String> visibleTopicTypes;
    private List<String> visibleAssocTypes;
    private TopicmapsService topicmapsService;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Row(Topic topic, List<String> visibleTopicTypes, List<String> visibleAssocTypes, TopicmapsService topicmapsService, CoreService dmx) {
        topic.loadChildTopics();
        this.topic = topic;
        this.visibleTopicTypes = visibleTopicTypes;
        this.visibleAssocTypes = visibleAssocTypes;
        this.topicmapsService = topicmapsService;
        this.dmx = dmx;
    }

    private List<Column> getTopicTypes() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String visibleColumn : this.visibleTopicTypes) {
            List<TopicModel> childTopics = this.findChildTopics(this.topic.getModel(), visibleColumn, 0, null);
            Column column = new Column(this.topic, visibleColumn, childTopics);
            columns.add(column);
        }
        return columns;
    }

    private List<AssociationCountColumn> getAssocTypes() {
        ArrayList<AssociationCountColumn> columns = new ArrayList<AssociationCountColumn>();
        for (String visibleColumn : this.visibleAssocTypes) {
            columns.add(new AssociationCountColumn(this.topic, visibleColumn));
        }
        return columns;
    }

    public JSONObject toJSON() {
        HashMap<String, Serializable> out = new HashMap<String, Serializable>();
        HashMap<String, JSONObject> columns = new HashMap<String, JSONObject>();
        columns.put("topicmaps", new TopicmapsColumn(this.topic, this.topicmapsService).toJSON());
        for (Column column : this.getTopicTypes()) {
            columns.put(column.uri, column.toJSON());
        }
        for (AssociationCountColumn associationCountColumn : this.getAssocTypes()) {
            columns.put(associationCountColumn.typeUri, associationCountColumn.toJSON());
        }
        out.put("columns", columns);
        out.put("topicId", Long.valueOf(this.topic.getId()));
        return new JSONObject(out);
    }

    List<TopicModel> findChildTopics(TopicModel parent, String topicTypeUri, int level, List<TopicModel> results) {
        try {
            if (parent.getTypeUri().equals(topicTypeUri)) {
                return results;
            }
            TopicType type = this.dmx.getTopicType(parent.getTypeUri());
            for (AssociationDefinitionModel assocDef : type.getModel().getAssocDefs()) {
                String assocDefUri = assocDef.getAssocDefUri();
                String cardinalityUri = assocDef.getChildCardinalityUri();
                RelatedTopicModel childTopic = null;
                if (cardinalityUri.equals("dmx.core.one")) {
                    childTopic = parent.getChildTopicsModel().getTopicOrNull(assocDefUri);
                    if (childTopic != null) {
                        results = new ArrayList<TopicModel>();
                        results.add((TopicModel)childTopic);
                    }
                } else if (cardinalityUri.equals("dmx.core.many")) {
                    List _childTopics = parent.getChildTopicsModel().getTopicsOrNull(assocDefUri);
                    if (_childTopics != null && !_childTopics.isEmpty()) {
                        results = new ArrayList<TopicModel>();
                        childTopic = (TopicModel)_childTopics.get(0);
                        for (RelatedTopicModel cm : _childTopics) {
                            results.add((TopicModel)cm);
                        }
                    }
                } else {
                    throw new RuntimeException("\"" + cardinalityUri + "\" is an unexpected cardinality URI");
                }
                if (childTopic == null || (results = this.findChildTopics((TopicModel)childTopic, topicTypeUri, level++, results)) == null) continue;
                return results;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Searching topic " + parent.getId() + " for \"" + topicTypeUri + "\" failed", e);
        }
    }
}

