/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Association;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.tableview.ColumnConfig;

public class TableviewConfig
implements JSONEnabled {
    JSONObject json = null;
    public Topic tableView = null;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TableviewConfig(Topic topic, CoreService dmx) {
        if (!topic.getTypeUri().equals("dmx.tableview")) {
            throw new RuntimeException("Creating TableViewConfiguration failed - Unsupported topic type");
        }
        this.tableView = topic;
        this.dmx = dmx;
    }

    TopicType getConfiguredType() {
        RelatedTopic topic = this.tableView.getRelatedTopic("dmx.tableview.table_topic_type", null, null, null);
        if (topic != null && topic.getTypeUri().equals("dmx.core.topic_type")) {
            return this.dmx.getTopicType(topic.getUri());
        }
        return null;
    }

    public List<RelatedTopic> getVisibleColumnsForTopicTypes() {
        return this.tableView.getRelatedTopics("dmx.tableview.table_column", null, null, "dmx.core.topic_type");
    }

    public List<RelatedTopic> getVisibleColumnsForAssocTypes() {
        return this.tableView.getRelatedTopics("dmx.tableview.table_column", null, null, "dmx.core.assoc_type");
    }

    private List<ColumnConfig> replaceWithColumnConfigs(List<RelatedTopic> relatedTopics) {
        ArrayList<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
        for (RelatedTopic relatedTopic : relatedTopics) {
            columnConfigs.add(new ColumnConfig(relatedTopic));
        }
        return columnConfigs;
    }

    public JSONObject toJSON() {
        this.json = new JSONObject();
        List<RelatedTopic> visibleColumns = this.getVisibleColumnsForTopicTypes();
        visibleColumns.addAll(this.getVisibleColumnsForAssocTypes());
        this.sortColumnsByVisiblePositionAscending(visibleColumns);
        String title = this.tableView.getChildTopics().getStringOrNull("dmx.tableview.name");
        try {
            this.json.put("title", (Object)(title == null ? "" : title)).put("id", this.tableView.getId()).put("type", (Object)this.getConfiguredType().toJSON()).put("columns", (Object)DMXUtils.toJSONArray(this.replaceWithColumnConfigs(visibleColumns)));
        }
        catch (JSONException ex) {
            throw new RuntimeException("Building TableViewConfiguration failed", ex);
        }
        return this.json;
    }

    private void sortColumnsByVisiblePositionAscending(List<? extends RelatedTopic> topics) {
        Collections.sort(topics, new Comparator<RelatedTopic>(){

            @Override
            public int compare(RelatedTopic t1, RelatedTopic t2) {
                int val2;
                Association one = t1.getRelatingAssociation();
                Association two = t2.getRelatingAssociation();
                String obj1 = one.getChildTopics().getStringOrNull("dmx.tableview.position");
                String obj2 = two.getChildTopics().getStringOrNull("dmx.tableview.position");
                if (obj1 == null) {
                    return -1;
                }
                if (obj2 == null) {
                    return -1;
                }
                int val1 = Integer.parseInt(obj1);
                return val1 >= (val2 = Integer.parseInt(obj2)) ? 1 : -1;
            }
        });
    }
}

