/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.CompDef;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PreCreateAssoc;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.tableview.Row;
import systems.dmx.tableview.TableviewConfig;
import systems.dmx.tableview.Topicmap;
import systems.dmx.topicmaps.TopicmapsConstants;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/tableview")
public class TableviewPlugin
extends PluginActivator
implements TopicmapsConstants,
PreCreateAssoc {
    public static final String TABLE_VIEW = "dmx.tableview";
    public static final String TABLE_VIEW_NAME = "dmx.tableview.name";
    public static final String TABLE_COLUMN = "dmx.tableview.table_column";
    public static final String TABLE_TOPIC_TYPE = "dmx.tableview.table_topic_type";
    public static final String COLUMN_POSITION = "dmx.tableview.position";
    public static final String ROLE_DEFAULT = "dmx.core.default";
    public static final String TOPIC_TYPE = "dmx.core.topic_type";
    public static final String ASSOC_TYPE = "dmx.core.assoc_type";
    public static final String TOPICMAP = "dmx.topicmaps.topicmap";
    public static final String ASSOCIATION = "dmx.core.association";
    public static final String WEBCLIENT_SLUG = "/systems.dmx.webclient/#";
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    TopicmapsService topicmaps;
    @Inject
    AccessControlService accesscontrol;
    @Inject
    WorkspacesService workspaces;

    @POST
    @Produces(value={"application/json"})
    @Transactional
    public Topic createTableview(String data) throws JSONException {
        JSONObject params = new JSONObject(data);
        String tvName = params.getString("name");
        String typeUri = params.getString("tableTopicType");
        Topic tv = this.dmx.createTopic(this.mf.newTopicModel(TABLE_VIEW, this.mf.newChildTopicsModel().put(TABLE_VIEW_NAME, (Object)tvName)));
        this.logger.info("Created new Tableview \"" + tvName + "\" with topic type \"" + typeUri + "\"");
        TopicType tableTopicType = this.dmx.getTopicType(typeUri);
        this.dmx.createAssoc(this.mf.newAssocModel(TABLE_TOPIC_TYPE, (PlayerModel)this.mf.newTopicPlayerModel(tv.getId(), ROLE_DEFAULT), (PlayerModel)this.mf.newTopicPlayerModel(tableTopicType.getId(), ROLE_DEFAULT)));
        this.logger.info("Configured topic type \"" + tableTopicType.getSimpleValue() + "\" as Table Topic Type");
        this.logger.info("Configuring default Table Columns for " + tv.getSimpleValue() + " ...");
        this.setupDefaultTableColumns(tv, tableTopicType, 0);
        return tv;
    }

    @GET
    @Path(value="/config/{topicId}")
    @Produces(value={"application/json"})
    public TableviewConfig getTableviewConfig(@PathParam(value="topicId") long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        return new TableviewConfig(tableView, this.dmx);
    }

    @GET
    @Path(value="/{topicId}")
    @Produces(value={"application/json"})
    public List<Row> getTableviewEntries(@PathParam(value="topicId") long topicId) {
        TableviewConfig tableView = this.getTableviewConfig(topicId);
        TopicType configuredTopicType = tableView.getConfiguredType();
        ArrayList<String> visibleTopicTypeUris = new ArrayList<String>();
        for (RelatedTopic relatedTopic : tableView.getVisibleColumnsForTopicTypes()) {
            visibleTopicTypeUris.add(relatedTopic.getUri());
        }
        ArrayList<String> visibleAssocTypeUris = new ArrayList<String>();
        for (RelatedTopic visibleAssocTypeTopic : tableView.getVisibleColumnsForAssocTypes()) {
            visibleAssocTypeUris.add(visibleAssocTypeTopic.getUri());
        }
        List list = this.dmx.getTopicsByType(configuredTopicType.getUri());
        ArrayList<Row> visibleDataForTopic = new ArrayList<Row>();
        for (Topic temp : list) {
            visibleDataForTopic.add(new Row(temp, visibleTopicTypeUris, visibleAssocTypeUris, this.topicmaps, this.dmx));
        }
        return visibleDataForTopic;
    }

    @GET
    @Path(value="/topictypes")
    @Produces(value={"application/json"})
    public List<Topic> getAllTopicTypes() {
        return this.dmx.getTopicsByType(TOPIC_TYPE);
    }

    @GET
    @Path(value="/open-in-map/{topicmapId}/{topicId}")
    @Produces(value={"text/html"})
    @Transactional
    public Response showTopicInTopicmap(@PathParam(value="topicmapId") long topicmapId, @PathParam(value="topicId") long topicId) throws URISyntaxException {
        Topic map;
        if (topicmapId != -1L && (map = this.dmx.getTopic(topicmapId)).getTypeUri().equals(TOPICMAP)) {
            this.setTopicPositionInBrowserViewport(topicmapId, topicId);
            return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId + "/topic/" + topicId)).build();
        }
        return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId)).build();
    }

    private void setupDefaultTableColumns(Topic table, TopicType type, int ordinalNr) {
        int pos = ordinalNr;
        type.loadChildTopics();
        for (CompDef cDef : type.getCompDefs()) {
            TopicType childType = this.dmx.getTopicType(cDef.getChildTypeUri());
            if (!childType.getDataTypeUri().equals("dmx.core.identity")) {
                this.dmx.createAssoc(this.mf.newAssocModel(TABLE_COLUMN, (PlayerModel)this.mf.newTopicPlayerModel(table.getId(), ROLE_DEFAULT), (PlayerModel)this.mf.newTopicPlayerModel(childType.getId(), ROLE_DEFAULT), this.mf.newChildTopicsModel().put(COLUMN_POSITION, (Object)(pos += 10))));
                this.logger.info("Added \"" + childType.getSimpleValue() + "\" (dataTypeUri=" + childType.getDataTypeUri() + ") as Table Column in position " + pos);
            }
            this.setupDefaultTableColumns(table, childType, pos);
        }
    }

    @Transactional
    private void setTopicPositionInBrowserViewport(@PathParam(value="topicmapId") long topicmapId, @PathParam(value="topicId") long topicId) {
        Topic topicmap = this.dmx.getTopic(topicmapId);
        double zoom = (Double)topicmap.getProperty("dmx.topicmaps.zoom");
        Assoc tc = this.topicmaps.getTopicMapcontext(topicmapId, topicId);
        if (tc == null) {
            int mapX = (Integer)topicmap.getProperty("dmx.topicmaps.pan_x");
            int mapY = (Integer)topicmap.getProperty("dmx.topicmaps.pan_y");
            this.topicmaps.addTopicToTopicmap(topicmap.getId(), topicId, mapX + 300, mapY + 300, true);
        } else {
            int x = (Integer)tc.getProperty("dmx.topicmaps.x");
            int y = (Integer)tc.getProperty("dmx.topicmaps.y");
            boolean visibility = (Boolean)tc.getProperty("dmx.topicmaps.visibility");
            if (!visibility) {
                tc.setProperty("dmx.topicmaps.visibility", (Object)true, false);
            }
            if (this.accesscontrol.getUsername() != null) {
                this.topicmaps.setTopicmapViewport(topicmapId, 300 - x, 200 - y, zoom);
            }
        }
    }

    @GET
    @Path(value="/topicmaps/{topicId}")
    @Produces(value={"application/json"})
    @Transactional
    public List<Topicmap> getTopicmaps(@PathParam(value="topicId") long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        Topic ws = this.workspaces.getAssignedWorkspace(tableView.getId());
        List topics = this.workspaces.getAssignedTopics(ws.getId(), TOPICMAP);
        ArrayList<Topicmap> result = new ArrayList<Topicmap>();
        for (Topic topic : topics) {
            Topicmap topicmap = new Topicmap(topic);
            result.add(topicmap);
        }
        return result;
    }

    public void preCreateAssoc(AssocModel am) {
        if (am.getTypeUri().equals(ASSOCIATION)) {
            PlayerModel player1 = am.getPlayer1();
            PlayerModel player2 = am.getPlayer2();
            DMXObject object1 = this.dmx.getObject(player1.getId());
            DMXObject object2 = this.dmx.getObject(player2.getId());
            if (object1.getTypeUri().equals(TABLE_VIEW)) {
                if (object2.getTypeUri().equals(TOPIC_TYPE)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)TABLE_VIEW, (String)TOPIC_TYPE, (String)TABLE_TOPIC_TYPE, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                } else if (object2.getTypeUri().equals(ASSOC_TYPE)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)TABLE_VIEW, (String)ASSOC_TYPE, (String)TABLE_TOPIC_TYPE, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                }
            } else if (object1.getTypeUri().equals(ASSOC_TYPE)) {
                if (object2.getTypeUri().equals(TABLE_VIEW)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)ASSOC_TYPE, (String)TABLE_VIEW, (String)TABLE_COLUMN, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                }
            } else if (object1.getTypeUri().equals(TOPIC_TYPE) && object2.getTypeUri().equals(TABLE_VIEW)) {
                DMXUtils.associationAutoTyping((AssocModel)am, (String)TOPIC_TYPE, (String)TABLE_VIEW, (String)TABLE_COLUMN, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
            }
        }
    }
}

