/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.Collection;
import java.util.HashMap;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.CompDef;
import systems.dmx.core.DMXType;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.SimpleValue;

public class ColumnConfig
implements JSONEnabled {
    public Long id;
    public String uri;
    public SimpleValue value;
    public DMXType columnType;
    public DMXType parentType;

    public ColumnConfig(TopicType parentType, DMXType columnType) {
        this.id = columnType.getId();
        this.uri = columnType.getUri();
        this.value = columnType.getSimpleValue();
        this.columnType = columnType;
        this.parentType = parentType;
    }

    public String getColumnURI(String childTypeUri) {
        Collection compDefs = this.parentType.getCompDefs();
        for (CompDef compDef : compDefs) {
            if (!compDef.getChildTypeUri().equals(childTypeUri)) continue;
            return compDef.getCompDefUri();
        }
        return childTypeUri;
    }

    private String getDataTypeUri() {
        return this.columnType.getRelatedTopic(null, null, null, "dmx.core.data_type").getUri();
    }

    public JSONObject toJSON() {
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("id", this.id);
        out.put("uri", this.getColumnURI(this.uri));
        out.put("value", this.value);
        out.put("dataTypeUri", this.getDataTypeUri());
        return new JSONObject(out);
    }
}

