/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import systems.dmx.accesscontrol.AccessControlService;
import systems.dmx.core.Assoc;
import systems.dmx.core.DMXObject;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.AssocModel;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Transactional;
import systems.dmx.core.service.event.PreCreateAssoc;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.tableview.Row;
import systems.dmx.tableview.TableviewConfig;
import systems.dmx.tableview.TableviewMapType;
import systems.dmx.tableview.TableviewModel;
import systems.dmx.tableview.Topicmap;
import systems.dmx.topicmaps.TopicmapType;
import systems.dmx.topicmaps.TopicmapsConstants;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

@Path(value="/tableview")
public class TableviewPlugin
extends PluginActivator
implements TopicmapsConstants,
PreCreateAssoc {
    public static final String MAPTYPE_TABLE_VIEW = "dmx.tableview";
    public static final String TABLE_COLUMN = "dmx.tableview.table_column";
    public static final String TABLE_TOPIC_TYPE = "dmx.tableview.table_topic_type";
    public static final String COLUMN_POSITION = "dmx.tableview.position";
    public static final String ROLE_DEFAULT = "dmx.core.default";
    public static final String TOPIC_TYPE = "dmx.core.topic_type";
    public static final String ASSOC_TYPE = "dmx.core.assoc_type";
    public static final String TOPICMAP = "dmx.topicmaps.topicmap";
    public static final String ASSOCIATION = "dmx.core.association";
    public static final String WEBCLIENT_SLUG = "/systems.dmx.webclient/#";
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    TopicmapsService topicmaps;
    @Inject
    AccessControlService accesscontrol;
    @Inject
    WorkspacesService workspaces;

    @GET
    @Path(value="/{topicId}")
    @Produces(value={"application/json"})
    public TableviewModel getTableviewTopicmap(@PathParam(value="topicId") long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        return new TableviewModel(new TableviewConfig(tableView, this.dmx), this.getTableviewEntries(topicId), this.getTopicmaps(topicId));
    }

    @GET
    @Path(value="/config/{topicId}")
    @Produces(value={"application/json"})
    public TableviewConfig getTableviewConfig(@PathParam(value="topicId") long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        return new TableviewConfig(tableView, this.dmx);
    }

    @GET
    @Path(value="/entries/{topicId}")
    @Produces(value={"application/json"})
    public List<Row> getTableviewEntries(@PathParam(value="topicId") long topicId) {
        this.logger.info("Loading tableview config ...");
        TableviewConfig tableView = this.getTableviewConfig(topicId);
        TopicType configuredTopicType = tableView.getConfiguredType();
        List<String> compDefURIs = tableView.getVisibleColumnsCompDefURIs();
        ArrayList<String> visibleAssocTypeUris = new ArrayList<String>();
        for (RelatedTopic visibleAssocTypeTopic : tableView.getVisibleColumnsForAssocTypes()) {
            visibleAssocTypeUris.add(visibleAssocTypeTopic.getUri());
        }
        this.logger.info("Loading tableview data ... configuredType=" + configuredTopicType.getSimpleValue());
        List topics = this.dmx.getTopicsByType(configuredTopicType.getUri());
        this.logger.info("> Loaded " + topics.size() + " topics of type " + configuredTopicType.getUri());
        ArrayList<Row> visibleDataForTopic = new ArrayList<Row>();
        for (Topic temp : topics) {
            visibleDataForTopic.add(new Row(temp, compDefURIs, visibleAssocTypeUris, this.topicmaps, this.dmx));
        }
        this.logger.info("Assembled data rows for tableview \"" + tableView.getName() + "\"");
        return visibleDataForTopic;
    }

    @GET
    @Path(value="/topictypes")
    @Produces(value={"application/json"})
    public List<Topic> getAllTopicTypes() {
        return this.dmx.getTopicsByType(TOPIC_TYPE);
    }

    @GET
    @Path(value="/open-in-map/{topicmapId}/{topicId}")
    @Produces(value={"text/html"})
    @Transactional
    public Response showTopicInTopicmap(@PathParam(value="topicmapId") long topicmapId, @PathParam(value="topicId") long topicId) throws URISyntaxException {
        Topic map;
        if (topicmapId != -1L && (map = this.dmx.getTopic(topicmapId)).getTypeUri().equals(TOPICMAP)) {
            this.setTopicPositionInBrowserViewport(topicmapId, topicId);
            return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId + "/topic/" + topicId)).build();
        }
        return Response.seeOther((URI)new URI("/systems.dmx.webclient/#/topicmap/" + topicmapId)).build();
    }

    @Transactional
    private void setTopicPositionInBrowserViewport(@PathParam(value="topicmapId") long topicmapId, @PathParam(value="topicId") long topicId) {
        Topic topicmap = this.dmx.getTopic(topicmapId);
        double zoom = (Double)topicmap.getProperty("dmx.topicmaps.zoom");
        Assoc tc = this.topicmaps.getTopicMapcontext(topicmapId, topicId);
        if (tc == null) {
            int mapX = (Integer)topicmap.getProperty("dmx.topicmaps.pan_x");
            int mapY = (Integer)topicmap.getProperty("dmx.topicmaps.pan_y");
            this.topicmaps.addTopicToTopicmap(topicmap.getId(), topicId, mapX + 300, mapY + 300, true);
        } else {
            int x = (Integer)tc.getProperty("dmx.topicmaps.x");
            int y = (Integer)tc.getProperty("dmx.topicmaps.y");
            boolean visibility = (Boolean)tc.getProperty("dmx.topicmaps.visibility");
            if (!visibility) {
                tc.setProperty("dmx.topicmaps.visibility", (Object)true, false);
            }
            if (this.accesscontrol.getUsername() != null) {
                this.topicmaps.setTopicmapViewport(topicmapId, 300 - x, 200 - y, zoom);
            }
        }
    }

    @GET
    @Path(value="/topicmaps/{topicId}")
    @Produces(value={"application/json"})
    @Transactional
    public List<Topicmap> getTopicmaps(@PathParam(value="topicId") long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        Topic ws = this.workspaces.getAssignedWorkspace(tableView.getId());
        List topics = this.workspaces.getAssignedTopics(ws.getId(), TOPICMAP);
        ArrayList<Topicmap> result = new ArrayList<Topicmap>();
        for (Topic topic : topics) {
            Topicmap topicmap = new Topicmap(topic);
            result.add(topicmap);
        }
        return result;
    }

    public void init() {
        this.topicmaps.registerTopicmapType((TopicmapType)new TableviewMapType());
    }

    public void preCreateAssoc(AssocModel am) {
        if (am.getTypeUri().equals(ASSOCIATION)) {
            PlayerModel player1 = am.getPlayer1();
            PlayerModel player2 = am.getPlayer2();
            DMXObject object1 = this.dmx.getObject(player1.getId());
            DMXObject object2 = this.dmx.getObject(player2.getId());
            if (object1.getTypeUri().equals(MAPTYPE_TABLE_VIEW)) {
                if (object2.getTypeUri().equals(TOPIC_TYPE)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)MAPTYPE_TABLE_VIEW, (String)TOPIC_TYPE, (String)TABLE_TOPIC_TYPE, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                } else if (object2.getTypeUri().equals(ASSOC_TYPE)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)MAPTYPE_TABLE_VIEW, (String)ASSOC_TYPE, (String)TABLE_TOPIC_TYPE, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                }
            } else if (object1.getTypeUri().equals(ASSOC_TYPE)) {
                if (object2.getTypeUri().equals(MAPTYPE_TABLE_VIEW)) {
                    DMXUtils.associationAutoTyping((AssocModel)am, (String)ASSOC_TYPE, (String)MAPTYPE_TABLE_VIEW, (String)TABLE_COLUMN, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
                }
            } else if (object1.getTypeUri().equals(TOPIC_TYPE) && object2.getTypeUri().equals(MAPTYPE_TABLE_VIEW)) {
                DMXUtils.associationAutoTyping((AssocModel)am, (String)TOPIC_TYPE, (String)MAPTYPE_TABLE_VIEW, (String)TABLE_COLUMN, (String)ROLE_DEFAULT, (String)ROLE_DEFAULT);
            }
        }
    }
}

