/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.logging.Logger;
import systems.dmx.core.CompDef;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.model.PlayerModel;
import systems.dmx.core.model.topicmaps.ViewProps;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.service.ModelFactory;
import systems.dmx.topicmaps.TopicmapType;

public class TableviewMapType
implements TopicmapType {
    private Logger log = Logger.getLogger(this.getClass().getName());

    public String getUri() {
        return "dmx.tableview";
    }

    public void initTopicmapState(Topic topicmapTopic, ViewProps viewProps, CoreService dmx) {
        String topicTypeUri = (String)viewProps.get("tableTopicType");
        this.log.info("Tableview TopicType Option " + topicTypeUri);
        TopicType tableTopicType = dmx.getTopicType(topicTypeUri);
        ModelFactory mf = dmx.getModelFactory();
        this.log.info("Created new Tableview \"" + topicmapTopic.getSimpleValue() + "\" with topic type \"" + topicTypeUri + "\"");
        dmx.createAssoc(mf.newAssocModel("dmx.tableview.table_topic_type", (PlayerModel)mf.newTopicPlayerModel(topicmapTopic.getId(), "dmx.core.default"), (PlayerModel)mf.newTopicPlayerModel(tableTopicType.getId(), "dmx.core.default")));
        this.log.info("Configured topic type \"" + tableTopicType.getSimpleValue() + "\" as Table Topic Type");
        this.log.info("Configuring default Table Columns for " + topicmapTopic.getSimpleValue() + " ...");
        this.setupDefaultTableColumns(topicmapTopic, tableTopicType, 0, dmx, mf);
    }

    private void setupDefaultTableColumns(Topic table, TopicType type, int ordinalNr, CoreService dmx, ModelFactory mf) {
        int pos = ordinalNr;
        type.loadChildTopics();
        if (type.getDataTypeUri().equals("dmx.core.identity")) {
            for (CompDef cDef : type.getCompDefs()) {
                TopicType childType = dmx.getTopicType(cDef.getChildTypeUri());
                dmx.createAssoc(mf.newAssocModel("dmx.tableview.table_column", (PlayerModel)mf.newTopicPlayerModel(table.getId(), "dmx.core.default"), (PlayerModel)mf.newTopicPlayerModel(childType.getId(), "dmx.core.default"), mf.newChildTopicsModel().put("dmx.tableview.position", (Object)(pos += 10))));
                this.log.info("Added \"" + childType.getSimpleValue() + "\" (dataTypeUri=" + childType.getDataTypeUri() + ") as Table Column in position " + pos);
            }
        } else {
            dmx.createAssoc(mf.newAssocModel("dmx.tableview.table_column", (PlayerModel)mf.newTopicPlayerModel(table.getId(), "dmx.core.default"), (PlayerModel)mf.newTopicPlayerModel(type.getId(), "dmx.core.default"), mf.newChildTopicsModel().put("dmx.tableview.position", (Object)pos)));
        }
    }
}

