/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.tableview.Topicmap;
import systems.dmx.topicmaps.TopicmapsService;

class TopicmapsColumn
implements JSONEnabled {
    private Topic topic;
    private List<RelatedTopic> relatedTopics = new ArrayList<RelatedTopic>();

    public TopicmapsColumn(Topic topic, TopicmapsService topicmapsService) {
        this.topic = topic;
        this.relatedTopics = topicmapsService.getTopicmapTopics(topic.getId());
    }

    public JSONObject toJSON() {
        HashMap<String, Object> outer = new HashMap<String, Object>();
        outer.put("type", "topicmaps");
        outer.put("topicId", this.topic.getId());
        if (this.relatedTopics == null || this.relatedTopics.size() <= 0) {
            outer.put("value", "");
            return new JSONObject(outer);
        }
        ArrayList<JSONObject> topicmaps = new ArrayList<JSONObject>();
        StringBuilder sbName = new StringBuilder();
        for (RelatedTopic relatedTopic : this.relatedTopics) {
            Topicmap topicmap = new Topicmap((Topic)relatedTopic);
            topicmaps.add(topicmap.toJSON());
            sbName.append(topicmap.getValue());
        }
        outer.put("data", topicmaps);
        outer.put("value", sbName.toString());
        return new JSONObject(outer);
    }
}

