/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview.migrations;

import java.util.List;
import java.util.logging.Logger;
import systems.dmx.core.DMXObject;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.service.Inject;
import systems.dmx.core.service.Migration;
import systems.dmx.tableview.TableviewConfig;
import systems.dmx.topicmaps.TopicmapsService;
import systems.dmx.workspaces.WorkspacesService;

public class Migration5
extends Migration {
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    @Inject
    TopicmapsService topicmaps;
    @Inject
    WorkspacesService workspaces;

    public void run() {
        List tableViews = null;
        try {
            tableViews = this.dmx.getTopicsByType("dmx.tableview");
            for (Topic tableView : tableViews) {
                TableviewConfig viewTopic = this.getTableviewConfig(tableView.getId());
                TopicType configuredTopicType = viewTopic.getConfiguredType();
                this.logger.info("Migrating Tableview => " + tableView.getSimpleValue());
                Topic tableViewMap = this.topicmaps.createTopicmap(tableView.getSimpleValue().toString(), "dmx.tableview.maptype", this.mf.newViewProps().put("tableTopicType", (Object)configuredTopicType.getUri()));
                Topic oldWs = this.workspaces.getAssignedWorkspace(tableView.getId());
                this.workspaces.assignToWorkspace((DMXObject)tableViewMap, oldWs.getId());
                tableView.delete();
            }
            List tableViewNames = this.dmx.getTopicsByType("dmx.tableview.name");
            tableViewNames.forEach(tableviewName -> tableviewName.delete());
            TopicType tableViewNameType = this.dmx.getTopicType("dmx.tableview.name");
            tableViewNameType.delete();
            TopicType tableViewType = this.dmx.getTopicType("dmx.tableview");
            tableViewType.delete();
        }
        catch (RuntimeException re) {
            this.logger.info("Skip Migration3: Topic Type `dmx.tableview` (<=0.3.1) was not installed (fresh install of >=0.4.0)");
        }
    }

    private TableviewConfig getTableviewConfig(long topicId) {
        Topic tableView = this.dmx.getTopic(topicId);
        return new TableviewConfig(tableView, this.dmx);
    }
}

