/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.Assoc;
import systems.dmx.core.CompDef;
import systems.dmx.core.DMXType;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.TopicType;
import systems.dmx.core.service.CoreService;
import systems.dmx.core.util.DMXUtils;
import systems.dmx.tableview.ColumnConfig;

public class TableviewConfig
implements JSONEnabled {
    JSONObject json = null;
    public Topic tableView = null;
    private CoreService dmx;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public TableviewConfig(Topic topic, CoreService dmx) {
        if (!topic.getTypeUri().equals("dmx.topicmaps.topicmap") && !topic.getTypeUri().equals("dmx.tableview")) {
            throw new RuntimeException("Creating TableViewConfiguration failed - Unsupported topic type");
        }
        this.tableView = topic;
        this.dmx = dmx;
    }

    public TopicType getConfiguredType() {
        RelatedTopic topic = this.tableView.getRelatedTopic("dmx.tableview.table_topic_type", null, null, null);
        if (topic != null && topic.getTypeUri().equals("dmx.core.topic_type")) {
            return this.dmx.getTopicType(topic.getUri());
        }
        return null;
    }

    public List<String> getVisibleColumnsCompDefURIs() {
        List<RelatedTopic> columns = this.getVisibleColumnsForTopicTypes();
        ArrayList<String> compDefURIs = new ArrayList<String>();
        for (RelatedTopic column : columns) {
            compDefURIs.add(this.getCompDefUri(this.getConfiguredType(), column.getUri()));
        }
        return compDefURIs;
    }

    public String getCompDefUri(TopicType type, String childTypeUri) {
        Collection compDefs = type.getCompDefs();
        for (CompDef compDef : compDefs) {
            if (!compDef.getChildTypeUri().equals(childTypeUri)) continue;
            return compDef.getCompDefUri();
        }
        return null;
    }

    public List<RelatedTopic> getVisibleColumnsForTopicTypes() {
        return this.tableView.getRelatedTopics("dmx.tableview.table_column", null, null, "dmx.core.topic_type");
    }

    public List<RelatedTopic> getVisibleColumnsForAssocTypes() {
        return this.tableView.getRelatedTopics("dmx.tableview.table_column", null, null, "dmx.core.assoc_type");
    }

    private List<ColumnConfig> replaceWithColumnConfigs(List<RelatedTopic> columnTypeTopics) {
        ArrayList<ColumnConfig> columnConfigs = new ArrayList<ColumnConfig>();
        for (RelatedTopic columnTypeTopic : columnTypeTopics) {
            TopicType type;
            if (columnTypeTopic.getTypeUri().equals("dmx.core.topic_type")) {
                type = this.dmx.getTopicType(columnTypeTopic.getUri());
                columnConfigs.add(new ColumnConfig(this.getConfiguredType(), (DMXType)type));
                continue;
            }
            if (!columnTypeTopic.getTypeUri().equals("dmx.core.assoc_type")) continue;
            type = this.dmx.getAssocType(columnTypeTopic.getUri());
            columnConfigs.add(new ColumnConfig(this.getConfiguredType(), (DMXType)type));
        }
        return columnConfigs;
    }

    private List<ColumnConfig> getColumnConfigs() {
        List<RelatedTopic> visibleColumnTypes = this.getVisibleColumnsForTopicTypes();
        visibleColumnTypes.addAll(this.getVisibleColumnsForAssocTypes());
        this.sortColumnsByVisiblePositionAscending(visibleColumnTypes);
        return this.replaceWithColumnConfigs(visibleColumnTypes);
    }

    public String getName() {
        return this.tableView.getSimpleValue().toString();
    }

    public JSONObject toJSON() {
        this.json = new JSONObject();
        String title = this.tableView.getSimpleValue().toString();
        try {
            this.json.put("title", (Object)(title == null ? "" : title)).put("id", this.tableView.getId()).put("type", (Object)this.getConfiguredType().toJSON()).put("columns", (Object)DMXUtils.toJSONArray(this.getColumnConfigs()));
        }
        catch (JSONException ex) {
            throw new RuntimeException("Building TableViewConfiguration failed", ex);
        }
        return this.json;
    }

    private void sortColumnsByVisiblePositionAscending(List<? extends RelatedTopic> topics) {
        Collections.sort(topics, new Comparator<RelatedTopic>(){

            @Override
            public int compare(RelatedTopic t1, RelatedTopic t2) {
                int val2;
                Assoc one = t1.getRelatingAssoc();
                Assoc two = t2.getRelatingAssoc();
                String obj1 = one.getChildTopics().getString("dmx.tableview.position", null);
                String obj2 = two.getChildTopics().getString("dmx.tableview.position", null);
                if (obj1 == null) {
                    return -1;
                }
                if (obj2 == null) {
                    return -1;
                }
                int val1 = Integer.parseInt(obj1);
                return val1 >= (val2 = Integer.parseInt(obj2)) ? 1 : -1;
            }
        });
    }
}

