/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tableview;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import org.codehaus.jettison.json.JSONObject;
import systems.dmx.core.JSONEnabled;
import systems.dmx.core.RelatedTopic;
import systems.dmx.core.Topic;
import systems.dmx.core.service.CoreService;
import systems.dmx.tableview.AssociationCountColumn;
import systems.dmx.tableview.Column;
import systems.dmx.tableview.TopicmapsColumn;
import systems.dmx.topicmaps.TopicmapsService;

public class Row
implements JSONEnabled {
    private Topic topic;
    private List<String> compDefURIs;
    private List<String> visibleAssocTypes;
    private TopicmapsService topicmapsService;
    private CoreService dmx;
    private JSONObject out;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    public Row(Topic topic, List<String> compDefURIs, List<String> visibleAssocTypes, TopicmapsService topicmapsService, CoreService dmx) {
        topic.loadChildTopics();
        this.topic = topic;
        this.compDefURIs = compDefURIs;
        this.visibleAssocTypes = visibleAssocTypes;
        this.topicmapsService = topicmapsService;
        this.dmx = dmx;
        this.out = this.assembleJSON();
    }

    private List<AssociationCountColumn> getAssocTypes() {
        ArrayList<AssociationCountColumn> columns = new ArrayList<AssociationCountColumn>();
        for (String visibleColumn : this.visibleAssocTypes) {
            columns.add(new AssociationCountColumn(this.topic, visibleColumn));
        }
        return columns;
    }

    private JSONObject assembleJSON() {
        HashMap<String, Serializable> out = new HashMap<String, Serializable>();
        HashMap<String, JSONObject> columns = new HashMap<String, JSONObject>();
        columns.put("topicmaps", new TopicmapsColumn(this.topic, this.topicmapsService).toJSON());
        for (Column column : this.getRowCell()) {
            columns.put(column.uri, column.toJSON());
        }
        for (AssociationCountColumn associationCountColumn : this.getAssocTypes()) {
            columns.put(associationCountColumn.typeUri, associationCountColumn.toJSON());
        }
        out.put("columns", columns);
        out.put("topicId", Long.valueOf(this.topic.getId()));
        return new JSONObject(out);
    }

    public JSONObject toJSON() {
        return this.out;
    }

    private List<Column> getRowCell() {
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String compDefURI : this.compDefURIs) {
            if (compDefURI.equals(this.topic.getTypeUri())) {
                Column column = new Column(this.topic, compDefURI, null);
                columns.add(column);
                continue;
            }
            List<RelatedTopic> childTopics = this.getChildTypeValues(this.topic, compDefURI);
            if (childTopics != null && childTopics.size() > 0) {
                Column column = new Column(this.topic, compDefURI, childTopics);
                columns.add(column);
                continue;
            }
            if (!childTopics.isEmpty()) continue;
            this.logger.warning("Could not find values for " + this.topic.getType().getSimpleValue() + " and columnTypeUri \"" + compDefURI + "\"");
        }
        return columns;
    }

    List<RelatedTopic> getChildTypeValues(Topic parent, String compDefUri) {
        try {
            ArrayList<RelatedTopic> value = new ArrayList<RelatedTopic>();
            value.add(parent.getChildTopics().getTopicOrNull(compDefUri));
            return value;
        }
        catch (Exception e) {
            try {
                return parent.getChildTopics().getTopicsOrNull(compDefUri);
            }
            catch (Exception ex) {
                this.logger.warning("Inaccessible values for childTypeUri => " + compDefUri + " in parentTypeUri => " + parent.getTypeUri());
                return new ArrayList<RelatedTopic>();
            }
        }
    }
}

