/*
 * Decompiled with CFR 0.152.
 */
package systems.dmx.tesseract;

import java.io.File;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import net.sourceforge.tess4j.Tesseract;
import systems.dmx.core.osgi.PluginActivator;
import systems.dmx.core.service.Inject;
import systems.dmx.files.FilesService;
import systems.dmx.tesseract.TesseractService;

@Path(value="/ocr")
public class TesseractPlugin
extends PluginActivator
implements TesseractService {
    private static final String DATA_PATH = System.getProperty("dmx.tesseract.data_path");
    @Inject
    private FilesService files;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @Override
    @GET
    @Path(value="/{repoPath}")
    @Produces(value={"text/plain"})
    public String doOCR(@PathParam(value="repoPath") String repoPath) {
        ClassLoader tccl = null;
        try {
            if (DATA_PATH == null) {
                throw new RuntimeException("dmx.tesseract.data_path configuration is missing");
            }
            File imageFile = this.files.getFile(repoPath);
            this.logger.info("### Tesseract data path: " + DATA_PATH + ", exists=" + new File(DATA_PATH).exists());
            this.logger.info("### Reading image file " + imageFile.getAbsolutePath() + ", exists=" + imageFile.exists());
            Tesseract tesseract = new Tesseract();
            tesseract.setDatapath(DATA_PATH);
            tccl = Thread.currentThread().getContextClassLoader();
            ClassLoader bcl = this.getClass().getClassLoader();
            this.logger.fine("### Classloader\ntccl = " + tccl + "\nbcl  = " + bcl);
            Thread.currentThread().setContextClassLoader(bcl);
            String text = tesseract.doOCR(imageFile);
            this.logger.info("\"" + text + "\"");
            String string = text;
            Thread.currentThread().setContextClassLoader(tccl);
            return string;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("Tesseract OCR failed", e);
            }
            catch (Throwable throwable) {
                Thread.currentThread().setContextClassLoader(tccl);
                throw throwable;
            }
        }
    }
}

