/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.context;

import java.util.Locale;
import java.util.Map;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IContextExecutionInfo;
import org.thymeleaf.context.VariablesMap;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext
implements IContext {
    public static final String EXEC_INFO_VARIABLE_NAME = "execInfo";
    private Locale locale;
    private final VariablesMap<String, Object> variables;

    protected AbstractContext() {
        this(Locale.getDefault());
    }

    AbstractContext(Locale locale) {
        this(locale, (Map)null);
    }

    AbstractContext(Locale locale, Map<String, ?> variables) {
        VariablesMap newVariablesMap;
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        this.locale = locale;
        if (variables != null) {
            newVariablesMap = new VariablesMap(variables.size() * 3 / 2, 1.0f);
            newVariablesMap.putAll(variables);
        } else {
            newVariablesMap = new VariablesMap(5);
        }
        this.variables = newVariablesMap;
    }

    AbstractContext(Locale locale, VariablesMap<String, Object> variablesMap) {
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        Validate.notNull(variablesMap, (String)"Variables map cannot be null");
        this.locale = locale;
        this.variables = variablesMap;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        this.locale = locale;
    }

    @Override
    public final VariablesMap<String, Object> getVariables() {
        return this.variables;
    }

    public final void setVariable(String name, Object value) {
        Validate.notNull((Object)name, (String)"Variable name cannot be null");
        this.variables.put(name, value);
    }

    public final void setVariables(Map<String, ?> additionalVariables) {
        Validate.notNull(additionalVariables, (String)"Variables map cannot be null");
        this.variables.putAll(additionalVariables);
    }

    public final void clearVariables() {
        this.variables.clear();
    }

    @Override
    public final void addContextExecutionInfo(String templateName) {
        Validate.notEmpty((String)templateName, (String)"Template name cannot be null or empty");
        this.setVariable(EXEC_INFO_VARIABLE_NAME, this.buildContextExecutionInfo(templateName));
    }

    protected abstract IContextExecutionInfo buildContextExecutionInfo(String var1);
}

